/*
 * Decompiled with CFR 0.152.
 */
package gravigun.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gravigun.common.GraviGun;
import gravigun.common.core.EntityHelper;
import gravigun.common.core.Settings;
import gravigun.common.entity.EntityBlock;
import gravigun.common.item.ItemGraviGun;
import gravigun.common.packet.PacketGrabEntity;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TickHandlerServer {
    public Map<EntityLivingBase, Entity> grabMap = new HashMap<EntityLivingBase, Entity>();
    public Map<Entity, Double> tossedEntities = new HashMap<Entity, Double>();
    public Map<Entity, EntityLivingBase> tosser = new HashMap<Entity, EntityLivingBase>();
    public Map<EntityCreeper, Boolean> chargedThrow = new HashMap<EntityCreeper, Boolean>();
    public List<EntityPlayer> holdingKey = new ArrayList<EntityPlayer>();
    public EntityLivingBase watchingSpawnFor = null;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.playerTick(event.player.field_70170_p, (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.worldTick(event.world);
        }
    }

    public void worldTick(World world) {
        Entity ent;
        int i;
        for (i = 0; i < world.field_73007_j.size(); ++i) {
            ent = (Entity)world.field_73007_j.get(i);
            if (!(ent instanceof EntityLightningBolt)) continue;
            EntityLightningBolt lightning = (EntityLightningBolt)world.field_73007_j.get(i);
            int lightningState = lightning.field_70262_b;
            if (lightningState < 0) continue;
            double var6 = 3.0;
            List var7 = lightning.field_70170_p.func_72839_b((Entity)lightning, AxisAlignedBB.func_72330_a((double)(lightning.field_70165_t - var6), (double)(lightning.field_70163_u - var6), (double)(lightning.field_70161_v - var6), (double)(lightning.field_70165_t + var6), (double)(lightning.field_70163_u + 6.0 + var6), (double)(lightning.field_70161_v + var6)));
            for (Entity var5 : var7) {
                if (!(var5 instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)var5;
                for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
                    ItemStack is = player.field_71071_by.field_70462_a[j];
                    if (is == null || is.func_77973_b() != GraviGun.itemGraviGun || is.func_77960_j() != 0) continue;
                    player.field_71071_by.field_70462_a[j] = new ItemStack(GraviGun.itemGraviGun, 1, 1);
                    player.field_71071_by.func_70296_d();
                }
            }
        }
        for (i = 0; i < world.field_72996_f.size(); ++i) {
            boolean currentItemIsGraviGun;
            ent = (Entity)world.field_72996_f.get(i);
            if (!(ent instanceof EntityZombie)) continue;
            EntityZombie zombie = (EntityZombie)ent;
            boolean bl = currentItemIsGraviGun = zombie.func_70694_bm() != null && zombie.func_70694_bm().func_77973_b() instanceof ItemGraviGun;
            if (!currentItemIsGraviGun || !(zombie.func_70681_au().nextFloat() < 0.008f)) continue;
            if (zombie.func_70681_au().nextFloat() < 0.6f) {
                Entity grabbed = GraviGun.proxy.tickHandlerServer.getGrabbed((EntityLivingBase)zombie);
                if (grabbed != null) {
                    GraviGun.proxy.tickHandlerServer.setGrabbed((EntityLivingBase)zombie, null);
                    zombie.field_70170_p.func_72956_a((Entity)zombie, "gravigun:drop", 0.3f, 1.0f);
                    continue;
                }
                EntityHelper.tryGrab((EntityLivingBase)zombie, true);
                continue;
            }
            EntityHelper.tryThrow((EntityLivingBase)zombie, true);
        }
    }

    public void playerTick(World world, EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b.size() > 0 && player == FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b.get(0)) {
            for (Map.Entry<EntityLivingBase, Entity> entry : this.grabMap.entrySet()) {
                if (GraviGun.hasPortalGun) continue;
                this.updateGrabbing(entry.getKey().field_70170_p, entry.getKey(), entry.getValue());
            }
            Iterator<Map.Entry<Entity, Double>> grabbedEntities = this.tossedEntities.entrySet().iterator();
            while (grabbedEntities.hasNext()) {
                Map.Entry<Entity, Double> entry = grabbedEntities.next();
                Entity grabbed = entry.getKey();
                double mag = entry.getValue();
                Vec3 var17 = Vec3.func_72443_a((double)grabbed.field_70165_t, (double)grabbed.field_70163_u, (double)grabbed.field_70161_v);
                Vec3 var3 = Vec3.func_72443_a((double)(grabbed.field_70165_t + grabbed.field_70159_w), (double)(grabbed.field_70163_u + grabbed.field_70181_x), (double)(grabbed.field_70161_v + grabbed.field_70179_y));
                MovingObjectPosition var4 = grabbed.field_70170_p.func_147447_a(var17, var3, false, true, false);
                var17 = Vec3.func_72443_a((double)grabbed.field_70165_t, (double)grabbed.field_70163_u, (double)grabbed.field_70161_v);
                var3 = Vec3.func_72443_a((double)(grabbed.field_70165_t + grabbed.field_70159_w), (double)(grabbed.field_70163_u + grabbed.field_70181_x), (double)(grabbed.field_70161_v + grabbed.field_70179_y));
                if (var4 != null) {
                    var3 = Vec3.func_72443_a((double)var4.field_72307_f.field_72450_a, (double)var4.field_72307_f.field_72448_b, (double)var4.field_72307_f.field_72449_c);
                }
                Entity var5 = null;
                List var6 = grabbed.field_70170_p.func_72839_b(grabbed, grabbed.field_70121_D.func_72321_a(grabbed.field_70159_w, grabbed.field_70181_x, grabbed.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                double var7 = 0.0;
                for (Entity var10 : var6) {
                    double var14;
                    float var11;
                    AxisAlignedBB var12;
                    MovingObjectPosition var13;
                    if (!var10.func_70067_L() || (var13 = (var12 = var10.field_70121_D.func_72314_b((double)(var11 = 0.3f), (double)var11, (double)var11)).func_72327_a(var17, var3)) == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                    var5 = var10;
                    var7 = var14;
                }
                if (var5 != null) {
                    var4 = new MovingObjectPosition(var5);
                }
                if (var4 != null && var4.field_72308_g != null) {
                    double volumehit;
                    int dmg = (int)Math.floor(2.5 * mag);
                    double volume = Math.pow(grabbed.field_70131_O * grabbed.field_70130_N * grabbed.field_70130_N, 0.33333);
                    if ((dmg = (int)((double)dmg * (volume / (volumehit = Math.pow(var4.field_72308_g.field_70131_O * var4.field_72308_g.field_70130_N * var4.field_72308_g.field_70130_N, 0.33333)) / 0.925))) > 0) {
                        var4.field_72308_g.func_70097_a(DamageSource.func_76353_a((EntityArrow)new EntityArrow(grabbed.field_70170_p), (Entity)((Entity)this.tosser.get(grabbed))), (float)dmg);
                    }
                    if (grabbed instanceof EntityCreeper) {
                        if (GraviGun.getSettings("creeperExplosion") == 1 || GraviGun.getSettings("creeperExplosion") == 2 && this.getChargedThrow(grabbed)) {
                            boolean var2 = grabbed.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                            int exploRadius = ((EntityCreeper)grabbed).field_82226_g;
                            if (((EntityCreeper)grabbed).func_70830_n()) {
                                grabbed.field_70170_p.func_72876_a(grabbed, grabbed.field_70165_t, grabbed.field_70163_u, grabbed.field_70161_v, (float)(exploRadius * 2), var2);
                            } else {
                                grabbed.field_70170_p.func_72876_a(grabbed, grabbed.field_70165_t, grabbed.field_70163_u, grabbed.field_70161_v, (float)exploRadius, var2);
                            }
                            grabbed.func_70106_y();
                        }
                        this.chargedThrow.remove(grabbed);
                    }
                }
                if (grabbed.field_70132_H || grabbed.field_70128_L) {
                    int dmg;
                    if (grabbed instanceof EntityCreeper && !grabbed.field_70128_L) {
                        if (GraviGun.getSettings("creeperExplosion") == 1 || GraviGun.getSettings("creeperExplosion") == 2 && this.getChargedThrow(grabbed)) {
                            boolean var2 = grabbed.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                            int exploRadius = ((EntityCreeper)grabbed).field_82226_g;
                            if (((EntityCreeper)grabbed).func_70830_n()) {
                                grabbed.field_70170_p.func_72876_a(grabbed, grabbed.field_70165_t, grabbed.field_70163_u, grabbed.field_70161_v, (float)(exploRadius * 2), var2);
                            } else {
                                grabbed.field_70170_p.func_72876_a(grabbed, grabbed.field_70165_t, grabbed.field_70163_u, grabbed.field_70161_v, (float)exploRadius, var2);
                            }
                            grabbed.func_70106_y();
                        }
                        this.chargedThrow.remove(grabbed);
                    }
                    if ((dmg = (int)Math.floor(2.5 * mag)) > 0) {
                        grabbed.func_70097_a(DamageSource.func_76353_a((EntityArrow)new EntityArrow(grabbed.field_70170_p), (Entity)((Entity)this.tosser.get(grabbed))), (float)dmg);
                    }
                    this.tosser.remove(grabbed);
                    grabbedEntities.remove();
                    continue;
                }
                entry.setValue(Math.sqrt(grabbed.field_70159_w * grabbed.field_70159_w + grabbed.field_70181_x * grabbed.field_70181_x + grabbed.field_70179_y * grabbed.field_70179_y));
            }
        }
        if (this.holdingKey.contains(player)) {
            boolean currentItemIsGraviGun;
            boolean bl = currentItemIsGraviGun = player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemGraviGun;
            if (currentItemIsGraviGun) {
                MovingObjectPosition movingObjectPosition = EntityHelper.getEntityLook((EntityLivingBase)player, (double)(player.func_71045_bC().func_77960_j() == 0 ? 10.0 : 15.0));
                if (movingObjectPosition != null) {
                    Block bId;
                    if (movingObjectPosition.field_72308_g != null) {
                        if (EntityHelper.canGrab(movingObjectPosition.field_72308_g)) {
                            double dist;
                            if (movingObjectPosition.field_72308_g instanceof EntityBlock) {
                                ((EntityBlock)movingObjectPosition.field_72308_g).age = -2;
                            }
                            if ((dist = (double)player.func_70032_d(movingObjectPosition.field_72308_g)) <= 4.0) {
                                player.field_70170_p.func_72956_a((Entity)player, "gravigun:pickup", 0.3f, 1.0f);
                                this.setGrabbed((EntityLivingBase)player, movingObjectPosition.field_72308_g);
                                this.holdingKey.remove(player);
                            } else {
                                double distX = player.field_70165_t - movingObjectPosition.field_72308_g.field_70165_t;
                                double distY = player.field_70163_u + (double)player.func_70047_e() - (movingObjectPosition.field_72308_g.field_70121_D.field_72337_e + movingObjectPosition.field_72308_g.field_70121_D.field_72338_b) / 2.0;
                                double distZ = player.field_70161_v - movingObjectPosition.field_72308_g.field_70161_v;
                                double mag = player.func_71045_bC().func_77960_j() == 0 ? 0.01 : 0.02;
                                double mag1 = (player.func_71045_bC().func_77960_j() == 0 ? 10.0 : 15.0) / dist;
                                movingObjectPosition.field_72308_g.func_70024_g(distX *= (mag *= mag1), distY *= mag, distZ *= mag);
                                if (movingObjectPosition.field_72308_g instanceof EntityPlayerMP) {
                                    EntityPlayerMP player1 = (EntityPlayerMP)movingObjectPosition.field_72308_g;
                                    player1.field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(player1.func_145782_y(), player1.field_70159_w, player1.field_70181_x, player1.field_70179_y));
                                }
                            }
                        }
                    } else if (player.func_71045_bC().func_77960_j() == 1 && GraviGun.getSettings("enableChargedGrabbing") == 1 && (bId = player.field_70170_p.func_147439_a(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d)) != Blocks.field_150357_h) {
                        int[] modMeta;
                        boolean grabable = true;
                        int[] meta = GraviGun.getBlockMetaInMap(Settings.grabBlockIds, bId);
                        if (meta != null) {
                            int blockMeta = player.field_70170_p.func_72805_g(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d);
                            if (GraviGun.getSettings("grabBlockWhitelist") == 1) {
                                grabable = false;
                                if (meta.length != 0 && meta[0] == -1) {
                                    grabable = true;
                                }
                                for (int j1 = 0; j1 < meta.length; ++j1) {
                                    if (blockMeta != meta[j1]) continue;
                                    grabable = true;
                                    break;
                                }
                            } else if (meta.length != 0 && meta[0] == -1) {
                                grabable = false;
                            } else {
                                for (int j1 = 0; j1 < meta.length; ++j1) {
                                    if (blockMeta != meta[j1]) continue;
                                    grabable = false;
                                    break;
                                }
                            }
                        }
                        if ((modMeta = GraviGun.getBlockMetaInMap(Settings.modBlockIds, bId)) != null) {
                            int blockMeta = player.field_70170_p.func_72805_g(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d);
                            if (modMeta.length != 0 && modMeta[0] == -1) {
                                grabable = false;
                            } else {
                                for (int j1 = 0; j1 < modMeta.length; ++j1) {
                                    if (blockMeta != modMeta[j1]) continue;
                                    grabable = false;
                                    break;
                                }
                            }
                        }
                        if (grabable && (player.field_70170_p.func_147445_c(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d, false) || bId == Blocks.field_150359_w || bId == Blocks.field_150426_aN || bId == Blocks.field_150414_aQ || bId == Blocks.field_150335_W) && (GraviGun.getSettings("graviGunFuel") == 1 || GraviGun.getSettings("graviGunFuel") != 1)) {
                            EntityBlock entBlock = new EntityBlock(player.field_70170_p, movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d, false);
                            entBlock.age = -2;
                            player.field_70170_p.func_72838_d((Entity)entBlock);
                        }
                    }
                }
            } else {
                this.holdingKey.remove(player);
            }
        }
    }

    public void updateGrabbing(World world, EntityLivingBase ent, Entity grabbed) {
        boolean currentItemIsGraviGun;
        boolean bl = ent instanceof EntityPlayer ? ((EntityPlayer)ent).func_71045_bC() != null && ((EntityPlayer)ent).func_71045_bC().func_77973_b() instanceof ItemGraviGun : (currentItemIsGraviGun = ((EntityZombie)ent).func_70694_bm() != null && ((EntityZombie)ent).func_70694_bm().func_77973_b() instanceof ItemGraviGun);
        if (grabbed != null) {
            if (grabbed.field_70128_L || grabbed == ent.field_70154_o || !currentItemIsGraviGun || !ent.func_70089_S() || ent.field_71093_bK != grabbed.field_71093_bK) {
                this.setGrabbed(ent, null);
                if (currentItemIsGraviGun) {
                    world.func_72956_a((Entity)ent, "gravigun:drop", 0.3f, 1.0f);
                }
            } else {
                double pZ;
                double pY;
                double pX = ent.field_70165_t - 3.5 * Math.sin(Math.toRadians(ent.field_70177_z)) * Math.cos(Math.toRadians(ent.field_70125_A));
                if (grabbed.func_70011_f(pX, pY = ent.field_70163_u + (double)ent.func_70047_e() - 3.5 * Math.sin(Math.toRadians(ent.field_70125_A)), pZ = ent.field_70161_v + 3.5 * Math.cos(Math.toRadians(ent.field_70177_z)) * Math.cos(Math.toRadians(ent.field_70125_A))) > 3.5) {
                    if (grabbed instanceof EntityEnderman && grabbed.func_70011_f(pX, pY, pZ) > 6.0) {
                        this.setGrabbed(ent, null);
                        if (currentItemIsGraviGun) {
                            world.func_72956_a((Entity)ent, "gravigun:drop", 0.3f, 1.0f);
                        }
                    } else {
                        grabbed.field_70169_q = ent.field_70165_t;
                        grabbed.field_70167_r = ent.field_70163_u;
                        grabbed.field_70166_s = ent.field_70161_v;
                        grabbed.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                    }
                }
                if (grabbed instanceof EntityFireball) {
                    EntityFireball fireball = (EntityFireball)grabbed;
                    fireball.field_70232_b = 0.0;
                    fireball.field_70233_c = 0.0;
                    fireball.field_70230_d = 0.0;
                }
                this.setVelocity(grabbed, pX - grabbed.field_70165_t, pY - (grabbed.field_70121_D.field_72337_e + grabbed.field_70121_D.field_72338_b) / 2.0, pZ - grabbed.field_70161_v);
                grabbed.field_70143_R = 0.0f;
                grabbed.field_70122_E = false;
                grabbed.field_70160_al = true;
                grabbed.field_71088_bW = 5;
                if (grabbed instanceof EntityFallingBlock) {
                    ((EntityFallingBlock)grabbed).field_145812_b = 2;
                }
            }
        }
    }

    public boolean getChargedThrow(Entity grabbed) {
        try {
            return this.chargedThrow.get(grabbed);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setGrabbed(EntityLivingBase living, Entity ent) {
        if (living.field_70170_p instanceof WorldServer) {
            for (Map.Entry<EntityLivingBase, Entity> e : this.grabMap.entrySet()) {
                if (e.getValue() != ent || e.getKey() == living) continue;
                this.setGrabbed(e.getKey(), null);
                break;
            }
            if (ent == null) {
                Entity ent1 = this.grabMap.get(living);
                if (ent1 != null) {
                    ent1.field_71088_bW = 0;
                }
                this.grabMap.remove(living);
            } else {
                this.tossedEntities.remove(ent);
                this.grabMap.put(living, ent);
            }
            PacketHandler.sendToAll(GraviGun.channels, (AbstractPacket)new PacketGrabEntity(1, new int[]{living.func_145782_y()}, new int[]{ent == null ? -1 : ent.func_145782_y()}));
        }
    }

    public Entity getGrabbed(EntityLivingBase living) {
        return this.grabMap.get(living);
    }

    public void setVelocity(Entity entity, double d, double d1, double d2) {
        if (entity == null) {
            return;
        }
        entity.field_70159_w = d;
        entity.field_70181_x = d1;
        entity.field_70179_y = d2;
    }
}

