/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.ModItems;
import doggytalents.entity.EntityDog;
import doggytalents.entity.ModeUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityAIFetch
extends EntityAIBase {
    private final EntityDog dog;
    private EntityLivingBase owner;
    private EntityItem fetchableItem;
    private World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    private float maxDist;
    private boolean preShouldAvoidWater;
    private double oldRangeSense;

    public EntityAIFetch(EntityDog dogIn, double followSpeedIn, float maxDistIn) {
        this.dog = dogIn;
        this.world = dogIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = dogIn.func_70661_as();
        this.maxDist = maxDistIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.dog.func_70902_q();
        EntityItem fetchableItem = this.getNearestFetchableItem();
        if (entitylivingbase == null) {
            return false;
        }
        if (fetchableItem == null) {
            return false;
        }
        if (!this.dog.mode.isMode(ModeUtil.EnumMode.DOCILE)) {
            return false;
        }
        if (this.dog.hasBone()) {
            return false;
        }
        if (this.dog.func_70906_o()) {
            return false;
        }
        if (this.dog.isIncapacicated()) {
            return false;
        }
        this.owner = entitylivingbase;
        this.fetchableItem = fetchableItem;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.isPlayingFetch() && this.dog.func_70068_e((Entity)this.fetchableItem) < (double)(this.maxDist * this.maxDist) && !this.dog.func_70906_o();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.preShouldAvoidWater = this.dog.func_70661_as().func_75486_a();
        this.dog.func_70661_as().func_75491_a(false);
        this.oldRangeSense = this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)this.maxDist);
    }

    public void func_75251_c() {
        this.owner = null;
        this.fetchableItem = null;
        this.petPathfinder.func_75499_g();
        this.dog.func_70661_as().func_75491_a(this.preShouldAvoidWater);
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.oldRangeSense);
    }

    public EntityItem getNearestFetchableItem() {
        List list = this.world.func_72839_b((Entity)this.dog, this.dog.field_70121_D.func_72314_b((double)this.maxDist, (double)this.maxDist, (double)this.maxDist));
        for (Entity entity : list) {
            EntityItem entityItem;
            if (!(entity instanceof EntityItem) || (entityItem = (EntityItem)entity).func_92059_d().func_77973_b() != ModItems.THROW_BONE || entityItem.func_92059_d().func_77960_j() % 2 != 0) continue;
            return entityItem;
        }
        return null;
    }

    public void func_75246_d() {
        this.dog.func_70671_ap().func_75651_a((Entity)this.fetchableItem, 10.0f, (float)this.dog.func_70646_bf());
        if (!this.dog.func_70906_o()) {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                this.petPathfinder.func_75497_a((Entity)this.fetchableItem, this.followSpeed);
            }
            if (this.dog.func_70068_e((Entity)this.fetchableItem) < 2.25 && !this.dog.hasBone() && this.fetchableItem.func_70089_S()) {
                this.fetchableItem.func_70097_a(DamageSource.field_76377_j, 12.0f);
                this.dog.setBoneVariant(this.fetchableItem.func_92059_d().func_77960_j() / 2);
                this.fetchableItem = null;
                this.dog.func_70661_as().func_75499_g();
            }
        }
    }

    public boolean isPlayingFetch() {
        return this.fetchableItem != null && this.fetchableItem.func_70089_S();
    }
}

