/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import com.google.common.base.Strings;
import doggytalents.entity.EntityDog;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.NBTTagCompound;

public class LevelUtil {
    private EntityDog dog;
    private static UUID HEALTH_BOOST_ID = UUID.fromString("da97255c-6281-45db-8198-f79226438583");

    public LevelUtil(EntityDog dog) {
        this.dog = dog;
    }

    public void writeTalentsToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("levels", this.getSaveString());
    }

    public void readTalentsFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_150297_b("levels", 8)) {
            this.dog.func_70096_w().func_75692_b(24, (Object)tagCompound.func_74779_i("levels"));
        } else {
            this.dog.func_70096_w().func_75692_b(24, (Object)"0:0");
        }
    }

    public String getSaveString() {
        String saveString = this.dog.func_70096_w().func_75681_e(24);
        return Strings.isNullOrEmpty((String)saveString) ? "0:0" : saveString;
    }

    public int getLevel() {
        return Integer.valueOf(this.getSaveString().split(":")[0]);
    }

    public int getDireLevel() {
        return Integer.valueOf(this.getSaveString().split(":")[1]);
    }

    public void increaseLevel() {
        this.setLevel(this.getLevel() + 1);
    }

    public void increaseDireLevel() {
        this.setDireLevel(this.getDireLevel() + 1);
    }

    public void setLevel(int level) {
        this.dog.func_70096_w().func_75692_b(24, (Object)(level + ":" + this.getDireLevel()));
        this.updateHealthModifier();
    }

    public void setDireLevel(int level) {
        this.dog.func_70096_w().func_75692_b(24, (Object)(this.getLevel() + ":" + level));
        this.updateHealthModifier();
    }

    public void updateHealthModifier() {
        IAttributeInstance iattributeinstance = this.dog.func_110148_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier healthModifier = this.createHealthModifier(this.dog.effectiveLevel() + 1.0);
        if (iattributeinstance.func_111127_a(HEALTH_BOOST_ID) != null) {
            iattributeinstance.func_111124_b(healthModifier);
        }
        iattributeinstance.func_111121_a(healthModifier);
    }

    public AttributeModifier createHealthModifier(double health) {
        return new AttributeModifier(HEALTH_BOOST_ID, "Dog Health", health, 0);
    }

    public boolean isDireDog() {
        return this.getDireLevel() == 30;
    }
}

