/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import doggytalents.ModBlocks;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.proxy.CommonProxy;
import doggytalents.tileentity.TileEntityDogBed;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDogBed
extends BlockContainer {
    public final ThreadLocal<ItemStack> drops = new ThreadLocal();

    public BlockDogBed() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.6f, 1.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDogBed();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        int facingDirection = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, facingDirection, 2);
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("doggytalents")) {
            String beddingId;
            NBTTagCompound tag = stack.field_77990_d.func_74775_l("doggytalents");
            String casingId = tag.func_74779_i("casingId");
            if (DogBedRegistry.CASINGS.isValidId(casingId)) {
                ((TileEntityDogBed)world.func_147438_o(x, y, z)).setCasingId(casingId);
            }
            if (DogBedRegistry.BEDDINGS.isValidId(beddingId = tag.func_74779_i("beddingId"))) {
                ((TileEntityDogBed)world.func_147438_o(x, y, z)).setBeddingId(beddingId);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        if (side == 0) {
            Block block = par1IBlockAccess.func_147439_a(x, y - 1, z);
            if (par1IBlockAccess instanceof World) {
                return block.isSideSolid((IBlockAccess)((World)par1IBlockAccess), x, y - 1, z, ForgeDirection.UP);
            }
            return block.func_149747_d(par1IBlockAccess, x, y - 1, z, 1);
        }
        return true;
    }

    public Item func_149650_a(int meta, Random par2Random, int fortune) {
        return Item.func_150899_d((int)-1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntity target = worldObj.func_147438_o(x, y, z);
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)its;
                    double py = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = worldObj.field_73012_v.nextInt(6);
                    IIcon icon = Blocks.field_150344_f.func_149691_a(0, 0);
                    if (target instanceof TileEntityDogBed) {
                        TileEntityDogBed dogBed = (TileEntityDogBed)target;
                        icon = this.getIconSafe(DogBedRegistry.CASINGS.getIcon(dogBed.getCasingId(), random));
                    }
                    EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, ModBlocks.DOG_BED, random, meta);
                    fx.func_110125_a(icon);
                    effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        int sideHit = target.field_72310_e;
        TileEntity tile = worldObj.func_147438_o(x, y, z);
        IIcon icon = Blocks.field_150344_f.func_149691_a(0, 0);
        if (tile instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tile;
            icon = this.getIconSafe(DogBedRegistry.CASINGS.getIcon(dogBed.getCasingId(), sideHit));
        }
        Block block = ModBlocks.DOG_BED;
        float b = 0.1f;
        double px = (double)x + worldObj.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(b * 2.0f)) + (double)b + block.func_149704_x();
        double py = (double)y + worldObj.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(b * 2.0f)) + (double)b + block.func_149665_z();
        double pz = (double)z + worldObj.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(b * 2.0f)) + (double)b + block.func_149706_B();
        if (sideHit == 0) {
            py = (double)y + block.func_149665_z() - (double)b;
        } else if (sideHit == 1) {
            py = (double)y + block.func_149669_A() + (double)b;
        } else if (sideHit == 2) {
            pz = (double)z + block.func_149706_B() - (double)b;
        } else if (sideHit == 3) {
            pz = (double)z + block.func_149693_C() + (double)b;
        } else if (sideHit == 4) {
            px = (double)x + block.func_149704_x() - (double)b;
        } else if (sideHit == 5) {
            px = (double)x + block.func_149753_y() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, 0.0, 0.0, 0.0, block, sideHit, worldObj.func_72805_g(x, y, z));
        fx.func_110125_a(icon);
        effectRenderer.func_78873_a(fx.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconSafe(IIcon icon) {
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public int func_149645_b() {
        return CommonProxy.RENDER_ID_DOG_BED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tile;
            return DogBedRegistry.CASINGS.getIcon(dogBed.getCasingId(), side);
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149681_a(World worldIn, int x, int y, int z, int metadata, EntityPlayer playerIn) {
        TileEntity tileentity = worldIn.func_147438_o(x, y, z);
        if (tileentity instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tileentity;
            if (!playerIn.field_71075_bZ.field_75098_d) {
                this.drops.set(DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World worldIn, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack cache = this.drops.get();
        this.drops.remove();
        if (cache != null) {
            ret.add(cache);
        } else {
            TileEntity tileentity = worldIn.func_147438_o(x, y, z);
            if (tileentity instanceof TileEntityDogBed) {
                TileEntityDogBed dogBed = (TileEntityDogBed)tileentity;
                ret.add(DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            }
        }
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityDogBed)) {
            return null;
        }
        TileEntityDogBed dogBed = (TileEntityDogBed)tile;
        return DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId());
    }

    public boolean func_149742_c(World worldIn, int x, int y, int z) {
        return super.func_149742_c(worldIn, x, y, z) ? this.func_149718_j(worldIn, x, y, z) : false;
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block block) {
        TileEntity tile;
        if (!this.func_149718_j(worldIn, x, y, z) && (tile = worldIn.func_147438_o(x, y, z)) instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tile;
            this.func_149642_a(worldIn, x, y, z, DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            worldIn.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        return block != null && block.isSideSolid((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP);
    }
}

