/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.craftgui;

import binnie.Binnie;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import binnie.genetics.api.IGene;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Engineering;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ControlGene
extends Control
implements IControlValue<IGene>,
ITooltip {
    protected IGene gene;

    protected ControlGene(IWidget parent, float x, float y) {
        super(parent, x, y, 16.0f, 16.0f);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.addSelfEventHandler((EventHandler)new MouseDownHandler());
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        String cName = Binnie.Genetics.getSystem(this.gene.getSpeciesRoot()).getChromosomeName(this.gene.getChromosome());
        tooltip.add(cName + ": " + this.gene.getName());
        if (this.isMouseOver() && this.canFill(((Window)Window.get(this)).getHeldItemStack())) {
            tooltip.add("Left click to assign gene");
            IGene existingGene = Engineering.getGene(((Window)Window.get(this)).getHeldItemStack(), this.gene.getChromosome().ordinal());
            if (existingGene == null) {
                return;
            }
            String dName = Binnie.Genetics.getSystem(this.gene.getSpeciesRoot()).getChromosomeName(this.gene.getChromosome());
            tooltip.add("Will replace " + dName + ": " + existingGene.getName());
        }
    }

    private boolean canFill(ItemStack stack) {
        return stack != null && stack.field_77994_a == 1 && Engineering.isGeneAcceptor(stack) && Engineering.canAcceptGene(stack, this.getValue());
    }

    @Override
    public IGene getValue() {
        return this.gene;
    }

    @Override
    public void setValue(IGene value) {
        this.gene = value;
    }

    @Override
    public void onRenderForeground() {
    }

    @Override
    public void onRenderBackground() {
        if (this.isMouseOver() && this.canFill(((Window)Window.get(this)).getHeldItemStack())) {
            CraftGUI.render.solid(this.getArea(), -1);
            CraftGUI.render.solid(this.getArea().inset(1), -12303292);
        }
        CraftGUI.render.color(-1);
        CraftGUI.render.iconItem(IPoint.ZERO, GeneticsTexture.dnaIcon.getIcon());
    }

    private class MouseDownHandler
    extends EventMouse.Down.Handler {
        private MouseDownHandler() {
        }

        @Override
        public void onEvent(EventMouse.Down event) {
            if (!ControlGene.this.canFill(((Window)Window.get(ControlGene.this.getWidget())).getHeldItemStack())) {
                return;
            }
            NBTTagCompound action = new NBTTagCompound();
            NBTTagCompound geneNBT = new NBTTagCompound();
            ControlGene.this.getValue().writeToNBT(geneNBT);
            action.func_74782_a("gene", (NBTBase)geneNBT);
            ((Window)Window.get(ControlGene.this.getWidget())).sendClientAction("gene-select", action);
        }
    }
}

