/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.config;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    public static Configuration config;
    public static int maxSearchDistance;
    public static int sampleSpace;
    public static String[] biomeBlacklist;
    public static boolean displayWithChatOpen;
    public static boolean fixBiomeNames;
    public static int lineOffset;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "The maximum distance the compass will search. Raising this value will increase search accuracy but will potentially make the process more resource intensive.";
        maxSearchDistance = ConfigHandler.loadInt("general", "naturescompass.distanceModifier", comment, maxSearchDistance);
        comment = "The space between samples taken by the compass when searching. Lowering this value will increase search accuracy but will make the process more resource intensive.";
        sampleSpace = ConfigHandler.loadInt("general", "naturescompass.sampleSpaceModifier", comment, sampleSpace);
        comment = "A list of biomes that the compass will not be able to search for. Both biome names and numerical biome IDs are accepted.";
        biomeBlacklist = ConfigHandler.loadStringArray("general", "naturescompass.biomeBlacklist", comment, biomeBlacklist);
        comment = "Displays Nature's Compass information even while chat is open.";
        displayWithChatOpen = ConfigHandler.loadBool("client", "naturescompass.displayWithChatOpen", comment, displayWithChatOpen);
        comment = "Fixes biome names by adding missing spaces. Ex: ForestHills becomes Forest Hills";
        fixBiomeNames = ConfigHandler.loadBool("client", "naturescompass.fixBiomeNames", comment, fixBiomeNames);
        comment = "The line offset for information rendered on the HUD.";
        lineOffset = ConfigHandler.loadInt("client", "naturescompass.lineOffset", comment, lineOffset);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadInt(String category, String name, String comment, int def) {
        Property prop = config.get(category, name, def);
        prop.comment = comment;
        int val = prop.getInt(def);
        if (val < 0) {
            val = def;
            prop.set(def);
        }
        return val;
    }

    public static boolean loadBool(String category, String name, String comment, boolean def) {
        Property prop = config.get(category, name, def);
        prop.comment = comment;
        return prop.getBoolean(def);
    }

    public static String[] loadStringArray(String category, String comment, String name, String[] def) {
        Property prop = config.get(category, name, def);
        prop.comment = comment;
        return prop.getStringList();
    }

    public static List<String> getBiomeBlacklist() {
        return Lists.newArrayList((Object[])biomeBlacklist);
    }

    static {
        maxSearchDistance = 10000;
        sampleSpace = 64;
        biomeBlacklist = new String[0];
        displayWithChatOpen = true;
        fixBiomeNames = true;
        lineOffset = 1;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.modID.equals("naturescompass")) {
                ConfigHandler.init();
            }
        }
    }
}

