/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public class DimensionUtils {
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> DIMENSION_NAMES = Lists.newArrayList();
    private String CURRENT_DIMENSION_NAME;
    private String CURRENT_DIMENSION_NAME_ID;
    private List<Integer> DIMENSION_IDS = Lists.newArrayList();
    private List<WorldProvider> DIMENSION_TYPES = Lists.newArrayList();
    private Integer CURRENT_DIMENSION_ID;

    private void emptyData() {
        this.DIMENSION_NAMES.clear();
        this.DIMENSION_IDS.clear();
        this.DIMENSION_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_DIMENSION_NAME = null;
        this.CURRENT_DIMENSION_ID = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgumentData("&DIMENSION&");
        CraftPresence.CLIENT.initIconData("&DIMENSION&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.showCurrentDimension : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.DIMENSION_NAMES.isEmpty() || this.DIMENSION_IDS.isEmpty() || this.DIMENSION_TYPES.isEmpty());
        if (needsUpdate) {
            this.getDimensions();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateDimensionData();
            } else {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateDimensionData() {
        WorldProvider newProvider = CraftPresence.player.field_70170_p.field_73011_w;
        String newDimensionName = StringUtils.formatDimensionName(newProvider.func_80007_l(), false);
        String newDimension_primaryNameID = StringUtils.formatDimensionName(newProvider.func_80007_l(), true);
        String newDimension_alternativeNameID = StringUtils.formatDimensionName(newProvider.getClass().getSimpleName(), true);
        String newDimension_nameID = !this.DIMENSION_NAMES.isEmpty() && this.DIMENSION_NAMES.contains(newDimension_alternativeNameID) ? newDimension_alternativeNameID : newDimension_primaryNameID;
        Integer newDimensionID = newProvider.field_76574_g;
        if (!newDimension_nameID.equals(this.CURRENT_DIMENSION_NAME_ID) || !newDimensionID.equals(this.CURRENT_DIMENSION_ID)) {
            this.CURRENT_DIMENSION_NAME = !StringUtils.isNullOrEmpty(newDimensionName) ? newDimensionName : newDimension_nameID;
            this.CURRENT_DIMENSION_NAME_ID = newDimension_nameID;
            this.CURRENT_DIMENSION_ID = newDimensionID;
            if (!this.DIMENSION_NAMES.contains(newDimension_nameID)) {
                this.DIMENSION_NAMES.add(newDimension_nameID);
            }
            if (!this.DIMENSION_TYPES.contains(newProvider)) {
                this.DIMENSION_TYPES.add(newProvider);
            }
            if (!this.DIMENSION_IDS.contains(newDimensionID)) {
                this.DIMENSION_IDS.add(newDimensionID);
            }
            this.updateDimensionPresence();
        }
    }

    public void updateDimensionPresence() {
        ArrayList dimensionArgs = Lists.newArrayList();
        dimensionArgs.add(new Tuple<String, String>("&DIMENSION&", this.CURRENT_DIMENSION_NAME));
        dimensionArgs.add(new Tuple<String, String>("&ID&", this.CURRENT_DIMENSION_ID.toString()));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            dimensionArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultDimensionMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentDimensionMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_NAME_ID, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultDimensionMSG);
        String currentDimensionIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_NAME_ID, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_DIMENSION_NAME_ID);
        String formattedIconKey = StringUtils.formatPackIcon(currentDimensionIcon.replace(" ", "_"));
        String CURRENT_DIMENSION_ICON = formattedIconKey.replace("&icon&", CraftPresence.CONFIG.defaultDimensionIcon);
        String CURRENT_DIMENSION_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentDimensionMSG, dimensionArgs);
        CraftPresence.CLIENT.syncArgument("&DIMENSION&", CURRENT_DIMENSION_MESSAGE, false);
        CraftPresence.CLIENT.syncArgument("&DIMENSION&", CraftPresence.CLIENT.imageOf(CURRENT_DIMENSION_ICON, CraftPresence.CONFIG.defaultDimensionIcon, true), true);
    }

    private List<WorldProvider> getDimensionTypes() {
        ArrayList dimensionTypes;
        block7: {
            dimensionTypes = Lists.newArrayList();
            Map reflectedDimensionTypes = (Map)StringUtils.lookupObject(DimensionManager.class, null, "providers");
            if (!dimensionTypes.isEmpty()) break block7;
            if (reflectedDimensionTypes != null) {
                for (Object objectType : reflectedDimensionTypes.values()) {
                    WorldProvider type = objectType instanceof WorldProvider ? (WorldProvider)objectType : null;
                    if (type == null || dimensionTypes.contains(type)) continue;
                    dimensionTypes.add(type);
                }
            } else {
                for (Class<?> classObj : FileUtils.getClassNamesMatchingSuperType(WorldProvider.class, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
                    if (classObj == null) continue;
                    try {
                        WorldProvider providerObj = (WorldProvider)classObj.newInstance();
                        if (providerObj == null || dimensionTypes.contains(providerObj)) continue;
                        dimensionTypes.add(providerObj);
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {}
                }
            }
        }
        return dimensionTypes;
    }

    public void getDimensions() {
        for (WorldProvider TYPE : this.getDimensionTypes()) {
            if (TYPE == null) continue;
            if (!this.DIMENSION_NAMES.contains(StringUtils.formatDimensionName(TYPE.func_80007_l(), true))) {
                this.DIMENSION_NAMES.add(StringUtils.formatDimensionName(TYPE.func_80007_l(), true));
            }
            if (!this.DIMENSION_IDS.contains(TYPE.field_76574_g)) {
                this.DIMENSION_IDS.add(TYPE.field_76574_g);
            }
            if (this.DIMENSION_TYPES.contains(TYPE)) continue;
            this.DIMENSION_TYPES.add(TYPE);
        }
        for (String dimensionMessage : CraftPresence.CONFIG.dimensionMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(dimensionMessage) || StringUtils.isNullOrEmpty((part = dimensionMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.DIMENSION_NAMES.contains(StringUtils.formatDimensionName(part[0], true))) continue;
            this.DIMENSION_NAMES.add(StringUtils.formatDimensionName(part[0], true));
        }
    }
}

