/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeUtils {
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> BIOME_NAMES = Lists.newArrayList();
    private List<BiomeGenBase> BIOME_TYPES = Lists.newArrayList();
    private List<Integer> BIOME_IDS = Lists.newArrayList();
    private String CURRENT_BIOME_NAME;
    private Integer CURRENT_BIOME_ID;

    private void emptyData() {
        this.BIOME_NAMES.clear();
        this.BIOME_IDS.clear();
        this.BIOME_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_BIOME_NAME = null;
        this.CURRENT_BIOME_ID = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgumentData("&BIOME&");
        CraftPresence.CLIENT.initIconData("&BIOME&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.showCurrentBiome : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.BIOME_NAMES.isEmpty() || this.BIOME_IDS.isEmpty() || this.BIOME_TYPES.isEmpty());
        if (needsUpdate) {
            this.getBiomes();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateBiomeData();
            } else {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateBiomeData() {
        BiomeGenBase newBiome = CraftPresence.player.field_70170_p.func_72807_a((int)CraftPresence.player.field_70165_t, (int)CraftPresence.player.field_70161_v);
        String newBiomeName = newBiome.field_76791_y;
        Integer newBiomeID = newBiome.field_76756_M;
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME) || !newBiomeID.equals(this.CURRENT_BIOME_ID)) {
            this.CURRENT_BIOME_NAME = newBiomeName;
            this.CURRENT_BIOME_ID = newBiomeID;
            if (!this.BIOME_NAMES.contains(newBiomeName)) {
                this.BIOME_NAMES.add(newBiomeName);
            }
            if (!this.BIOME_IDS.contains(newBiomeID)) {
                this.BIOME_IDS.add(newBiomeID);
            }
            if (!this.BIOME_TYPES.contains(newBiome)) {
                this.BIOME_TYPES.add(newBiome);
            }
            this.updateBiomePresence();
        }
    }

    public void updateBiomePresence() {
        ArrayList biomeArgs = Lists.newArrayList();
        biomeArgs.add(new Tuple<String, String>("&BIOME&", this.CURRENT_BIOME_NAME));
        biomeArgs.add(new Tuple<String, String>("&ID&", this.CURRENT_BIOME_ID.toString()));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            biomeArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultBiomeMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentBiomeMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultBiomeMSG);
        String CURRENT_BIOME_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentBiomeMSG, biomeArgs);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CURRENT_BIOME_MESSAGE, false);
        CraftPresence.CLIENT.initIconData("&BIOME&");
    }

    private List<BiomeGenBase> getBiomeTypes() {
        ArrayList biomeTypes = Lists.newArrayList();
        if (BiomeGenBase.func_150565_n() != null) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || biomeTypes.contains(biome)) continue;
                biomeTypes.add(biome);
            }
        }
        if (biomeTypes.isEmpty()) {
            for (Class clazz : FileUtils.getClassNamesMatchingSuperType(BiomeGenBase.class, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
                if (clazz == null) continue;
                try {
                    BiomeGenBase biomeObj = (BiomeGenBase)clazz.newInstance();
                    if (biomeObj == null || biomeTypes.contains(biomeObj)) continue;
                    biomeTypes.add(biomeObj);
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        }
        return biomeTypes;
    }

    public void getBiomes() {
        for (BiomeGenBase biome : this.getBiomeTypes()) {
            if (biome == null) continue;
            if (!this.BIOME_NAMES.contains(biome.field_76791_y)) {
                this.BIOME_NAMES.add(biome.field_76791_y);
            }
            if (!this.BIOME_IDS.contains(biome.field_76756_M)) {
                this.BIOME_IDS.add(biome.field_76756_M);
            }
            if (this.BIOME_TYPES.contains(biome)) continue;
            this.BIOME_TYPES.add(biome);
        }
        for (String biomeMessage : CraftPresence.CONFIG.biomeMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(biomeMessage) || StringUtils.isNullOrEmpty((part = biomeMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.BIOME_NAMES.contains(part[0])) continue;
            this.BIOME_NAMES.add(part[0]);
        }
    }
}

