/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.updater;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;

public class ModUpdaterUtils {
    private final List<String> latestVersionTags = Lists.newArrayList((Object[])new String[]{"latest", "beta", "alpha", "bleeding-edge", "unstable", "rc", "release-candidate"});
    private final List<String> recommendedVersionTags = Lists.newArrayList((Object[])new String[]{"recommended", "stable", "release"});
    public UpdateState currentState = UpdateState.PENDING;
    public String modID;
    public String updateUrl;
    public String downloadUrl;
    public String targetLatestVersion;
    public String targetRecommendedVersion;
    public String targetVersion;
    public String targetChangelogData;
    public String currentVersion;

    public ModUpdaterUtils(String modID, String updateUrl, String currentVersion) {
        this.modID = modID;
        this.updateUrl = updateUrl;
        this.currentVersion = currentVersion.replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
    }

    public void checkForUpdates() {
        this.currentState = UpdateState.PENDING;
        this.targetRecommendedVersion = "0.0.0";
        this.targetLatestVersion = "0.0.0";
        this.targetVersion = "0.0.0";
        this.targetChangelogData = "";
        this.downloadUrl = "";
        try {
            JsonObject rootUpdateData = FileUtils.parseJson(UrlUtils.getURLText(this.updateUrl, "UTF-8"));
            if (rootUpdateData != null) {
                ModUtils.LOG.debugInfo("Received Update Data: " + rootUpdateData.toString(), new Object[0]);
                if (rootUpdateData.has("homepage")) {
                    this.downloadUrl = rootUpdateData.get("homepage").toString().replace("\"", "").trim();
                } else {
                    ModUtils.LOG.warn("Unable to locate Homepage for this Application...", new Object[0]);
                }
                if (rootUpdateData.has("promos")) {
                    JsonObject mcVersionData;
                    JsonObject promoData = rootUpdateData.get("promos").getAsJsonObject();
                    for (Map.Entry jsonSegment : promoData.entrySet()) {
                        if (((String)jsonSegment.getKey()).contains("-")) {
                            String[] splitPromo = ((String)jsonSegment.getKey()).split("-");
                            String mcVersion = splitPromo[0];
                            if (!mcVersion.equalsIgnoreCase(ModUtils.MCVersion)) continue;
                            String dataTag = splitPromo[1];
                            if (this.latestVersionTags.contains(dataTag.toLowerCase())) {
                                this.targetLatestVersion = ((JsonElement)jsonSegment.getValue()).toString().replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
                            } else if (this.recommendedVersionTags.contains(dataTag.toLowerCase())) {
                                this.targetRecommendedVersion = ((JsonElement)jsonSegment.getValue()).toString().replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
                            }
                            if (this.targetLatestVersion.equalsIgnoreCase("0.0.0") || this.targetRecommendedVersion.equalsIgnoreCase("0.0.0")) continue;
                            break;
                        }
                        if (((String)jsonSegment.getKey()).equalsIgnoreCase(ModUtils.MCVersion)) {
                            this.targetRecommendedVersion = ((JsonElement)jsonSegment.getValue()).toString().replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
                            continue;
                        }
                        ModUtils.LOG.debugWarn("Json Segment " + (String)jsonSegment.getKey() + " is of an incompatible format...", new Object[0]);
                    }
                    ModUtils.LOG.debugInfo("Detected Latest Version for " + ModUtils.MCVersion + ": " + this.targetLatestVersion, new Object[0]);
                    ModUtils.LOG.debugInfo("Detected Recommended Version for " + ModUtils.MCVersion + ": " + this.targetRecommendedVersion, new Object[0]);
                    int recommendedState = this.compareVersions(this.currentVersion, this.targetRecommendedVersion);
                    int latestState = this.compareVersions(this.currentVersion, this.targetLatestVersion);
                    if (recommendedState == 0) {
                        this.currentState = UpdateState.UP_TO_DATE;
                        this.targetVersion = this.targetRecommendedVersion;
                    } else if (recommendedState == -1) {
                        this.currentState = UpdateState.OUTDATED;
                        this.targetVersion = this.targetRecommendedVersion;
                    } else {
                        this.currentState = latestState == 0 || latestState == 1 ? UpdateState.BETA : UpdateState.BETA_OUTDATED;
                        this.targetVersion = this.targetLatestVersion;
                    }
                    ModUtils.LOG.info("Received Update Status for " + this.modID + ": " + this.currentState.name() + " (Target Version: v" + this.targetVersion + ")", new Object[0]);
                    if (rootUpdateData.has(ModUtils.MCVersion) && (mcVersionData = rootUpdateData.get(ModUtils.MCVersion).getAsJsonObject()) != null) {
                        JsonElement annotatedVersionData;
                        JsonElement semanticVersionData = mcVersionData.has(this.targetVersion) ? mcVersionData.get(this.targetVersion) : null;
                        JsonElement jsonElement = annotatedVersionData = mcVersionData.has("v" + this.targetVersion) ? mcVersionData.get("v" + this.targetVersion) : null;
                        if (semanticVersionData != null || annotatedVersionData != null) {
                            JsonElement changelogData = semanticVersionData != null ? semanticVersionData : annotatedVersionData;
                            this.targetChangelogData = changelogData.toString().replace("\"", "").trim();
                            ModUtils.LOG.debugInfo("Received Changelog: " + this.targetChangelogData, new Object[0]);
                        } else {
                            ModUtils.LOG.error("Failed to Locate Changelog Data for " + this.modID + "@" + this.targetVersion, new Object[0]);
                        }
                    }
                }
            }
        }
        catch (Error | Exception ex) {
            ModUtils.LOG.error("Failed to Check for Updates, enable Debug Mode to See Errors...", new Object[0]);
            if (ModUtils.IS_DEV) {
                ex.printStackTrace();
            }
            this.currentState = UpdateState.FAILED;
        }
    }

    int compareVersions(String str1, String str2) {
        int i;
        if (str1.equals(str2)) {
            return 0;
        }
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            return Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
        }
        if (i < vals1.length) {
            boolean allZeros = true;
            int j = i;
            while (allZeros & j < vals1.length) {
                allZeros = Integer.parseInt(vals1[j]) == 0;
                ++j;
            }
            return allZeros ? 0 : -1;
        }
        if (i < vals2.length) {
            boolean allZeros = true;
            int j = i;
            while (allZeros & j < vals2.length) {
                allZeros = Integer.parseInt(vals2[j]) == 0;
                ++j;
            }
            return allZeros ? 0 : 1;
        }
        return 0;
    }

    public static enum UpdateState {
        FAILED,
        UP_TO_DATE,
        OUTDATED,
        BETA_OUTDATED,
        BETA,
        PENDING;

    }
}

