/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import net.minecraft.client.Minecraft;

public class SliderControl
extends ExtendedButtonControl {
    private final float minValue;
    private final float maxValue;
    private final float valueStep;
    private float sliderValue;
    private float denormalizedSlideValue;
    private String windowTitle;
    private boolean dragging;

    public SliderControl(int buttonId, Tuple<Integer, Integer> positionData, Tuple<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        super(buttonId, positionData.getFirst(), positionData.getSecond(), dimensions.getFirst(), dimensions.getSecond(), "", new String[0]);
        this.setSliderValue(startValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        this.field_146126_j = displayString + ": " + this.denormalizedSlideValue;
        this.windowTitle = displayString;
    }

    public int func_146114_a(boolean mouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.sliderValue = this.clamp(this.sliderValue, 0.0f, 1.0f);
                this.denormalizedSlideValue = this.denormalizeValue(this.sliderValue);
                this.field_146126_j = this.windowTitle + ": " + this.denormalizedSlideValue;
            }
            int hoverValue = (this.field_146123_n ? 2 : 1) * 20;
            CraftPresence.GUIS.renderSlider(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 46 + hoverValue, 4, 20, this.field_73735_i, field_146122_a);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            this.sliderValue = this.clamp(this.sliderValue, 0.0f, 1.0f);
            this.denormalizedSlideValue = this.denormalizeValue(this.sliderValue);
            this.field_146126_j = this.windowTitle + ": " + this.denormalizedSlideValue;
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void setSliderValue(float newValue) {
        if (newValue >= 0.0f && newValue <= 1.0f) {
            this.sliderValue = newValue;
            this.denormalizedSlideValue = this.denormalizeValue(newValue);
        } else {
            this.sliderValue = this.normalizeValue(newValue);
            this.denormalizedSlideValue = newValue;
        }
        this.field_146126_j = this.windowTitle + ": " + this.denormalizedSlideValue;
    }

    public float getSliderValue(boolean useNormal) {
        return useNormal ? this.sliderValue : this.denormalizedSlideValue;
    }

    private float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    private float normalizeValue(float value) {
        return this.clamp((this.snapToStepClamp(value) - this.minValue) / (this.maxValue - this.minValue), 0.0f, 1.0f);
    }

    private float denormalizeValue(float value) {
        return this.snapToStepClamp(this.minValue + (this.maxValue - this.minValue) * this.clamp(value, 0.0f, 1.0f));
    }

    private float snapToStepClamp(float originalValue) {
        float value = this.snapToStep(originalValue);
        return this.clamp(value, this.minValue, this.maxValue);
    }

    private float snapToStep(float originalValue) {
        float value = originalValue;
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
    }
}

