/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public boolean openConfigGUI = false;
    public boolean configGUIOpened = false;
    public boolean isInUse = false;
    public boolean isFocused = false;
    public boolean enabled = false;
    public List<String> GUI_NAMES = Lists.newArrayList();
    private String CURRENT_GUI_NAME;
    private Class<?> CURRENT_GUI_CLASS;
    private GuiScreen CURRENT_SCREEN;
    private List<Class<?>> GUI_CLASSES = Lists.newArrayList();

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), zLevel, (double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), zLevel, (double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        tessellator.func_78374_a((double)(x + width), (double)y, zLevel, (double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f));
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f));
        GL11.glEnable((int)3008);
        tessellator.func_78381_a();
    }

    public boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return mouseX >= elementX && mouseX <= elementX + elementWidth && mouseY >= elementY && mouseY <= elementY + elementHeight;
    }

    public boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return this.isMouseOver(mouseX, mouseY, button.field_146128_h, button.field_146129_i, button.getWidth() - 1, button.getHeight() - 1);
    }

    public boolean isMouseOver(double mouseX, double mouseY, CheckBoxControl checkBox) {
        return this.isMouseOver(mouseX, mouseY, checkBox.field_146128_h, checkBox.field_146129_i, checkBox.boxWidth - 1, checkBox.getHeight() - 1);
    }

    private void emptyData() {
        this.GUI_NAMES.clear();
        this.GUI_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.CURRENT_GUI_CLASS = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgumentData("&GUI&");
        CraftPresence.CLIENT.initIconData("&GUI&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePERGUI : this.enabled;
        this.isInUse = this.enabled && (CraftPresence.instance.field_71462_r != null || this.CURRENT_SCREEN != null);
        this.isFocused = CraftPresence.instance.field_71462_r != null && CraftPresence.instance.field_71415_G;
        boolean bl = needsUpdate = this.enabled && (this.GUI_NAMES.isEmpty() || this.GUI_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getGUIs();
        }
        if (this.isInUse) {
            this.updateGUIData();
            if (this.enabled && CraftPresence.instance.field_71462_r == null) {
                this.clearClientData();
            } else if (!this.enabled) {
                this.emptyData();
            }
        }
        if (this.openConfigGUI) {
            this.openScreen(new MainGui(CraftPresence.instance.field_71462_r));
            this.openConfigGUI = false;
        }
    }

    public void openScreen(GuiScreen targetScreen) {
        CraftPresence.instance.func_152344_a(() -> CraftPresence.instance.func_147108_a(targetScreen));
    }

    private void updateGUIData() {
        if (CraftPresence.instance.field_71462_r == null) {
            this.clearClientData();
        } else {
            GuiScreen newScreen = CraftPresence.instance.field_71462_r;
            Class<?> newScreenClass = newScreen.getClass();
            String newScreenName = newScreenClass.getSimpleName();
            if (!(newScreen.equals(this.CURRENT_SCREEN) && newScreenClass.equals(this.CURRENT_GUI_CLASS) && newScreenName.equals(this.CURRENT_GUI_NAME))) {
                this.CURRENT_SCREEN = newScreen;
                this.CURRENT_GUI_CLASS = newScreenClass;
                this.CURRENT_GUI_NAME = newScreenName;
                if (!this.GUI_NAMES.contains(newScreenName)) {
                    this.GUI_NAMES.add(newScreenName);
                }
                if (!this.GUI_CLASSES.contains(newScreenClass)) {
                    this.GUI_CLASSES.add(newScreenClass);
                }
                this.updateGUIPresence();
            }
        }
    }

    public void getGUIs() {
        Class[] searchClasses = new Class[]{GuiScreen.class, GuiContainer.class};
        for (Class<?> classObj : FileUtils.getClassNamesMatchingSuperType(Arrays.asList(searchClasses), "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
            if (!this.GUI_NAMES.contains(classObj.getSimpleName())) {
                this.GUI_NAMES.add(classObj.getSimpleName());
            }
            if (this.GUI_CLASSES.contains(classObj)) continue;
            this.GUI_CLASSES.add(classObj);
        }
        for (String guiMessage : CraftPresence.CONFIG.guiMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(guiMessage) || StringUtils.isNullOrEmpty((part = guiMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.GUI_NAMES.contains(part[0])) continue;
            this.GUI_NAMES.add(part[0]);
        }
    }

    public void updateGUIPresence() {
        ArrayList guiArgs = Lists.newArrayList();
        guiArgs.add(new Tuple<String, String>("&GUI&", this.CURRENT_GUI_NAME));
        guiArgs.add(new Tuple<String, String>("&CLASS&", this.CURRENT_GUI_CLASS.getSimpleName()));
        guiArgs.add(new Tuple<String, String>("&SCREEN&", this.CURRENT_SCREEN.toString()));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            guiArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultGUIMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.guiMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentGUIMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.guiMessages, this.CURRENT_GUI_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultGUIMSG);
        String CURRENT_GUI_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentGUIMSG, guiArgs);
        CraftPresence.CLIENT.syncArgument("&GUI&", CURRENT_GUI_MESSAGE, false);
        CraftPresence.CLIENT.initIconData("&GUI&");
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, boolean withBackground) {
        if (CraftPresence.CONFIG.renderTooltips && !ModUtils.forceBlockTooltipRendering && !textToInput.isEmpty() && font != null) {
            ArrayList textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = StringUtils.getStringWidth(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = posX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = posX > screenWidth / 2 ? posX - 12 - 8 : screenWidth - 16 - posX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList wrappedTextLines = Lists.newArrayList();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List<String> wrappedLine = StringUtils.splitTextByNewLine(StringUtils.wrapFormattedStringToWidth(textLine, tooltipTextWidth));
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = StringUtils.getStringWidth(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = posX > screenWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
            }
            int tooltipY = posY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            if (withBackground) {
                String borderColor;
                String backgroundColor;
                GL11.glDisable((int)2929);
                int zLevel = 300;
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.tooltipBGColor)) {
                    backgroundColor = CraftPresence.CONFIG.tooltipBGColor.length() == 6 ? "#" + CraftPresence.CONFIG.tooltipBGColor : (CraftPresence.CONFIG.tooltipBGColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.tooltipBGColor).intValue()) : CraftPresence.CONFIG.tooltipBGColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                } else {
                    ResourceLocation backGroundTexture;
                    backgroundColor = CraftPresence.CONFIG.tooltipBGColor.contains(CraftPresence.CONFIG.splitCharacter) ? CraftPresence.CONFIG.tooltipBGColor.replace(CraftPresence.CONFIG.splitCharacter, ":") : (CraftPresence.CONFIG.tooltipBGColor.contains(":") && !CraftPresence.CONFIG.tooltipBGColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBGColor : (CraftPresence.CONFIG.tooltipBGColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBGColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.tooltipBGColor));
                    if (backgroundColor.contains(":")) {
                        String[] splitInput = backgroundColor.split(":", 2);
                        backGroundTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        backGroundTexture = new ResourceLocation(backgroundColor);
                    }
                    this.drawTextureRect(300.0, tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 0.0, backGroundTexture);
                }
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.tooltipBorderColor)) {
                    borderColor = CraftPresence.CONFIG.tooltipBorderColor.length() == 6 ? "#" + CraftPresence.CONFIG.tooltipBorderColor : (CraftPresence.CONFIG.tooltipBorderColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.tooltipBorderColor).intValue()) : CraftPresence.CONFIG.tooltipBorderColor);
                    int borderColorCode = borderColor.startsWith("#") ? StringUtils.getColorFromHex(borderColor).getRGB() : Integer.parseInt(borderColor);
                    String borderColorEnd = Integer.toString((borderColorCode & 0xFEFEFE) >> 1 | borderColorCode & 0xFF000000);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColor, borderColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
                } else {
                    ResourceLocation borderTexture;
                    borderColor = CraftPresence.CONFIG.tooltipBorderColor.contains(CraftPresence.CONFIG.splitCharacter) ? CraftPresence.CONFIG.tooltipBorderColor.replace(CraftPresence.CONFIG.splitCharacter, ":") : (CraftPresence.CONFIG.tooltipBorderColor.contains(":") && !CraftPresence.CONFIG.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBorderColor : (CraftPresence.CONFIG.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBorderColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.tooltipBorderColor));
                    if (borderColor.contains(":")) {
                        String[] splitInput = borderColor.split(":", 2);
                        borderTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        borderTexture = new ResourceLocation(borderColor);
                    }
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, tooltipTextWidth + 5, 1.0, 0.0, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipTextWidth + 5, 1.0, 0.0, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, 1.0, tooltipHeight + 5, 0.0, borderTexture);
                    this.drawTextureRect(300.0, tooltipX + tooltipTextWidth + 2, tooltipY - 3, 1.0, tooltipHeight + 6, 0.0, borderTexture);
                }
            }
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                font.func_78261_a(line, tooltipX, tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            if (withBackground) {
                GL11.glEnable((int)2929);
            }
        }
    }

    public void drawBackground(double width, double height) {
        if (CraftPresence.instance.field_71441_e != null) {
            this.drawGradientRect(300.0f, 0.0, 0.0, width, height, "-1072689136", "-804253680");
        } else {
            String bgCode = CraftPresence.CONFIG.guiBGColor;
            if (StringUtils.isValidColorCode(bgCode)) {
                this.drawGradientRect(300.0f, 0.0, 0.0, width, height, bgCode, bgCode);
            } else if (!StringUtils.isNullOrEmpty(bgCode)) {
                ResourceLocation loc;
                if (bgCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                    bgCode = bgCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                }
                if (bgCode.contains(":")) {
                    String[] splitInput = bgCode.split(":", 2);
                    loc = new ResourceLocation(splitInput[0], splitInput[1]);
                } else {
                    loc = new ResourceLocation(bgCode);
                }
                this.drawTextureRect(0.0, 0.0, 0.0, width, height, 0.0, loc);
            }
        }
    }

    public void renderSlider(int x, int y, int u, int v, int width, int height, double zLevel, ResourceLocation texLocation) {
        if (texLocation != null) {
            CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(x, y, u, v, width, height, zLevel);
        this.drawTexturedModalRect(x + 4, y, u + 196, v, width, height, zLevel);
    }

    public void drawTextureRect(double zLevel, double xPos, double yPos, double width, double height, double tint, ResourceLocation texLocation) {
        if (texLocation != null) {
            CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float divider = 32.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78378_d(0x404040);
        tessellator.func_78374_a(xPos, yPos + height, zLevel, 0.0, height / 32.0 + tint);
        tessellator.func_78374_a(xPos + width, yPos + height, zLevel, width / 32.0, height / 32.0 + tint);
        tessellator.func_78374_a(xPos + width, yPos, zLevel, width / 32.0, tint);
        tessellator.func_78374_a(xPos, yPos, zLevel, 0.0, tint);
        tessellator.func_78381_a();
    }

    public void drawGradientRect(float zLevel, double left, double top, double right, double bottom, String startColorCode, String endColorCode) {
        Color startColorObj = null;
        Color endColorObj = null;
        int startColor = 0xFFFFFF;
        int endColor = 0xFFFFFF;
        if (!StringUtils.isNullOrEmpty(startColorCode)) {
            if (startColorCode.startsWith("#")) {
                startColorObj = StringUtils.getColorFromHex(startColorCode);
                endColorObj = !StringUtils.isNullOrEmpty(endColorCode) && endColorCode.startsWith("#") ? StringUtils.getColorFromHex(endColorCode) : startColorObj;
            } else {
                Tuple<Boolean, Integer> startColorData = StringUtils.getValidInteger(startColorCode);
                Tuple<Boolean, Integer> endColorData = StringUtils.getValidInteger(endColorCode);
                if (startColorData.getFirst().booleanValue() || endColorData.getFirst().booleanValue()) {
                    startColor = startColorData.getFirst() != false ? startColorData.getSecond() : endColor;
                    endColor = endColorData.getFirst() != false ? endColorData.getSecond() : startColor;
                }
            }
        }
        int startColorInstance = startColorObj != null ? startColorObj.getRGB() : startColor;
        int endColorInstance = endColorObj != null ? endColorObj.getRGB() : endColor;
        float startAlpha = (float)(startColorInstance >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColorInstance >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColorInstance >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColorInstance & 0xFF) / 255.0f;
        float endAlpha = (float)(endColorInstance >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColorInstance >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColorInstance >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColorInstance & 0xFF) / 255.0f;
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(startRed, startGreen, startBlue, startAlpha);
        tessellator.func_78377_a(right, top, (double)zLevel);
        tessellator.func_78377_a(left, top, (double)zLevel);
        tessellator.func_78369_a(endRed, endGreen, endBlue, endAlpha);
        tessellator.func_78377_a(left, bottom, (double)zLevel);
        tessellator.func_78377_a(right, bottom, (double)zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    public void drawContinuousTexturedBox(Tuple<Integer, Integer> positionData, Tuple<Integer, Integer> uVLevels, Tuple<Integer, Integer> screenDimensions, Tuple<Integer, Integer> textureDimensions, Tuple<Integer, Integer> verticalBorderData, Tuple<Integer, Integer> sideBorderData, double zLevel, ResourceLocation res) {
        if (res != null) {
            CraftPresence.instance.func_110434_K().func_110577_a(res);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int x = positionData.getFirst();
        int y = positionData.getSecond();
        int u = uVLevels.getFirst();
        int v = uVLevels.getSecond();
        int width = screenDimensions.getFirst();
        int height = screenDimensions.getSecond();
        int textureWidth = textureDimensions.getFirst();
        int textureHeight = textureDimensions.getSecond();
        int topBorder = verticalBorderData.getFirst();
        int bottomBorder = verticalBorderData.getSecond();
        int leftBorder = sideBorderData.getFirst();
        int rightBorder = sideBorderData.getSecond();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        this.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        this.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        this.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        this.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                this.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            this.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            this.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }
}

