/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EntityUtils {
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> ENTITY_NAMES = Lists.newArrayList();
    private List<String> BLOCK_NAMES = Lists.newArrayList();
    private List<String> BLOCK_CLASSES = Lists.newArrayList();
    private List<String> ITEM_NAMES = Lists.newArrayList();
    private List<String> ITEM_CLASSES = Lists.newArrayList();
    private List<String> ENTITY_CLASSES = Lists.newArrayList();
    private Item EMPTY_ITEM = null;
    private ItemStack EMPTY_STACK = new ItemStack(this.EMPTY_ITEM);
    private ItemStack CURRENT_MAINHAND_ITEM;
    private ItemStack CURRENT_HELMET;
    private ItemStack CURRENT_CHEST;
    private ItemStack CURRENT_LEGS;
    private ItemStack CURRENT_BOOTS;
    private String CURRENT_MAINHAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;
    private boolean allItemsEmpty = false;
    private boolean currentlyCleared = true;

    private void emptyData() {
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.ENTITY_NAMES.clear();
        this.ENTITY_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_MAINHAND_ITEM = this.EMPTY_STACK;
        this.CURRENT_MAINHAND_ITEM_NAME = null;
        this.CURRENT_HELMET = this.EMPTY_STACK;
        this.CURRENT_CHEST = this.EMPTY_STACK;
        this.CURRENT_LEGS = this.EMPTY_STACK;
        this.CURRENT_BOOTS = this.EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        this.allItemsEmpty = true;
        this.isInUse = false;
        this.currentlyCleared = true;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePERItem : this.enabled;
        this.isInUse = this.enabled && CraftPresence.player != null;
        boolean bl = needsUpdate = this.enabled && (this.ENTITY_NAMES.isEmpty() || this.ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.isInUse) {
            this.updateEntityData();
            if (this.enabled && (CraftPresence.player == null || this.allItemsEmpty)) {
                this.clearClientData();
            } else if (!this.enabled) {
                this.emptyData();
            }
        }
    }

    private boolean isEmpty(Item item) {
        return item == null || this.isEmpty(this.getDefaultInstance(item));
    }

    private boolean isEmpty(Block block) {
        return block == null || this.isEmpty(Item.func_150898_a((Block)block));
    }

    private ItemStack getDefaultInstance(Item itemIn) {
        return new ItemStack(itemIn);
    }

    private boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null || itemStack.equals(this.EMPTY_STACK)) {
            return true;
        }
        if (itemStack.func_77973_b() != this.EMPTY_ITEM) {
            if (itemStack.field_77994_a <= 0) {
                return true;
            }
            return itemStack.func_77960_j() < Short.MIN_VALUE || itemStack.func_77960_j() > 65535;
        }
        return true;
    }

    private void updateEntityData() {
        boolean hasBootsChanged;
        ItemStack NEW_CURRENT_MAINHAND_ITEM = CraftPresence.player.func_70694_bm();
        ItemStack NEW_CURRENT_HELMET = CraftPresence.player.field_71071_by.field_70460_b[3];
        ItemStack NEW_CURRENT_CHEST = CraftPresence.player.field_71071_by.field_70460_b[2];
        ItemStack NEW_CURRENT_LEGS = CraftPresence.player.field_71071_by.field_70460_b[1];
        ItemStack NEW_CURRENT_BOOTS = CraftPresence.player.field_71071_by.field_70460_b[0];
        String NEW_CURRENT_MAINHAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_MAINHAND_ITEM) ? StringUtils.stripColors(NEW_CURRENT_MAINHAND_ITEM.func_82833_r()) : "";
        String NEW_CURRENT_HELMET_NAME = !this.isEmpty(NEW_CURRENT_HELMET) ? StringUtils.stripColors(NEW_CURRENT_HELMET.func_82833_r()) : "";
        String NEW_CURRENT_CHEST_NAME = !this.isEmpty(NEW_CURRENT_CHEST) ? StringUtils.stripColors(NEW_CURRENT_CHEST.func_82833_r()) : "";
        String NEW_CURRENT_LEGS_NAME = !this.isEmpty(NEW_CURRENT_LEGS) ? StringUtils.stripColors(NEW_CURRENT_LEGS.func_82833_r()) : "";
        String NEW_CURRENT_BOOTS_NAME = !this.isEmpty(NEW_CURRENT_BOOTS) ? StringUtils.stripColors(NEW_CURRENT_BOOTS.func_82833_r()) : "";
        boolean hasMainHandChanged = !this.isEmpty(NEW_CURRENT_MAINHAND_ITEM) && !NEW_CURRENT_MAINHAND_ITEM.equals(this.CURRENT_MAINHAND_ITEM) || !NEW_CURRENT_MAINHAND_ITEM_NAME.equals(this.CURRENT_MAINHAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_MAINHAND_ITEM) && !this.isEmpty(this.CURRENT_MAINHAND_ITEM);
        boolean hasHelmetChanged = !this.isEmpty(NEW_CURRENT_HELMET) && !NEW_CURRENT_HELMET.equals(this.CURRENT_HELMET) || !NEW_CURRENT_HELMET_NAME.equals(this.CURRENT_HELMET_NAME) || this.isEmpty(NEW_CURRENT_HELMET) && !this.isEmpty(this.CURRENT_HELMET);
        boolean hasChestChanged = !this.isEmpty(NEW_CURRENT_CHEST) && !NEW_CURRENT_CHEST.equals(this.CURRENT_CHEST) || !NEW_CURRENT_CHEST_NAME.equals(this.CURRENT_CHEST_NAME) || this.isEmpty(NEW_CURRENT_CHEST) && !this.isEmpty(this.CURRENT_CHEST);
        boolean hasLegsChanged = !this.isEmpty(NEW_CURRENT_LEGS) && !NEW_CURRENT_LEGS.equals(this.CURRENT_LEGS) || !NEW_CURRENT_LEGS_NAME.equals(this.CURRENT_LEGS_NAME) || this.isEmpty(NEW_CURRENT_LEGS) && !this.isEmpty(this.CURRENT_LEGS);
        boolean bl = hasBootsChanged = !this.isEmpty(NEW_CURRENT_BOOTS) && !NEW_CURRENT_BOOTS.equals(this.CURRENT_BOOTS) || !NEW_CURRENT_BOOTS_NAME.equals(this.CURRENT_BOOTS_NAME) || this.isEmpty(NEW_CURRENT_BOOTS) && !this.isEmpty(this.CURRENT_BOOTS);
        if (hasMainHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            this.CURRENT_MAINHAND_ITEM = NEW_CURRENT_MAINHAND_ITEM;
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_MAINHAND_ITEM_NAME = NEW_CURRENT_MAINHAND_ITEM_NAME;
            this.CURRENT_HELMET_NAME = NEW_CURRENT_HELMET_NAME;
            this.CURRENT_CHEST_NAME = NEW_CURRENT_CHEST_NAME;
            this.CURRENT_LEGS_NAME = NEW_CURRENT_LEGS_NAME;
            this.CURRENT_BOOTS_NAME = NEW_CURRENT_BOOTS_NAME;
            this.allItemsEmpty = this.isEmpty(this.CURRENT_MAINHAND_ITEM) && this.isEmpty(this.CURRENT_HELMET) && this.isEmpty(this.CURRENT_CHEST) && this.isEmpty(this.CURRENT_LEGS) && this.isEmpty(this.CURRENT_BOOTS);
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultItemMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String mainItemMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_MAINHAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultItemMSG);
        String helmetMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_HELMET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_HELMET_NAME);
        String chestMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_CHEST_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_CHEST_NAME);
        String legsMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_LEGS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_LEGS_NAME);
        String bootsMSG = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_BOOTS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BOOTS_NAME);
        ArrayList entityArgs = Lists.newArrayList();
        entityArgs.add(new Tuple<String, String>("&MAIN&", !StringUtils.isNullOrEmpty(this.CURRENT_MAINHAND_ITEM_NAME) ? StringUtils.replaceAnyCase(mainItemMSG, "&item&", this.CURRENT_MAINHAND_ITEM_NAME) : ""));
        entityArgs.add(new Tuple<String, String>("&OFFHAND&", ""));
        entityArgs.add(new Tuple<String, String>("&HELMET&", !StringUtils.isNullOrEmpty(this.CURRENT_HELMET_NAME) ? StringUtils.replaceAnyCase(helmetMSG, "&item&", this.CURRENT_HELMET_NAME) : ""));
        entityArgs.add(new Tuple<String, String>("&CHEST&", !StringUtils.isNullOrEmpty(this.CURRENT_CHEST_NAME) ? StringUtils.replaceAnyCase(chestMSG, "&item&", this.CURRENT_CHEST_NAME) : ""));
        entityArgs.add(new Tuple<String, String>("&LEGS&", !StringUtils.isNullOrEmpty(this.CURRENT_LEGS_NAME) ? StringUtils.replaceAnyCase(legsMSG, "&item&", this.CURRENT_LEGS_NAME) : ""));
        entityArgs.add(new Tuple<String, String>("&BOOTS&", !StringUtils.isNullOrEmpty(this.CURRENT_BOOTS_NAME) ? StringUtils.replaceAnyCase(bootsMSG, "&item&", this.CURRENT_BOOTS_NAME) : ""));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            entityArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_ITEM_MESSAGE = StringUtils.sequentialReplaceAnyCase(defaultItemMSG, entityArgs);
        if (!this.allItemsEmpty) {
            CraftPresence.CLIENT.syncArgument("&ENTITY&", CURRENT_ITEM_MESSAGE, false);
        } else if (!this.currentlyCleared) {
            CraftPresence.CLIENT.initArgumentData("&ENTITY&");
            CraftPresence.CLIENT.initIconData("&ENTITY&");
        }
    }

    public void getEntities() {
        ArrayList subtypes;
        for (Object blockObj : Block.field_149771_c) {
            Block block = Block.func_149729_e((int)Block.field_149771_c.func_148757_b(blockObj));
            if (this.isEmpty(block)) continue;
            subtypes = Lists.newArrayList();
            for (Object tab : CreativeTabs.field_78032_a) {
                if (tab == null) continue;
                block.func_149666_a(Item.func_150898_a((Block)block), tab, (List)subtypes);
            }
            if (!subtypes.isEmpty()) {
                for (ItemStack itemStack : subtypes) {
                    if (this.isEmpty(itemStack)) continue;
                    if (!this.BLOCK_NAMES.contains(itemStack.func_82833_r())) {
                        this.BLOCK_NAMES.add(itemStack.func_82833_r());
                    }
                    if (this.BLOCK_CLASSES.contains(itemStack.func_77973_b().getClass().getName())) continue;
                    this.BLOCK_CLASSES.add(itemStack.func_77973_b().getClass().getName());
                }
                continue;
            }
            if (!this.BLOCK_NAMES.contains(block.func_149732_F())) {
                this.BLOCK_NAMES.add(block.func_149732_F());
            }
            if (this.BLOCK_CLASSES.contains(block.getClass().getName())) continue;
            this.BLOCK_CLASSES.add(block.getClass().getName());
        }
        for (Object itemObj : Item.field_150901_e) {
            Item item = Item.func_150899_d((int)Item.field_150901_e.func_148757_b(itemObj));
            if (this.isEmpty(item)) continue;
            subtypes = Lists.newArrayList();
            for (Object tab : CreativeTabs.field_78032_a) {
                if (tab == null) continue;
                item.func_150895_a(item, tab, (List)subtypes);
            }
            if (!subtypes.isEmpty()) {
                for (ItemStack itemStack : subtypes) {
                    if (this.isEmpty(itemStack)) continue;
                    if (!this.ITEM_NAMES.contains(itemStack.func_82833_r())) {
                        this.ITEM_NAMES.add(itemStack.func_82833_r());
                    }
                    if (this.ITEM_CLASSES.contains(itemStack.func_77973_b().getClass().getName())) continue;
                    this.ITEM_CLASSES.add(itemStack.func_77973_b().getClass().getName());
                }
                continue;
            }
            if (!this.ITEM_NAMES.contains(item.func_77653_i(this.getDefaultInstance(item)))) {
                this.ITEM_NAMES.add(item.func_77653_i(this.getDefaultInstance(item)));
            }
            if (this.ITEM_CLASSES.contains(item.getClass().getName())) continue;
            this.ITEM_CLASSES.add(item.getClass().getName());
        }
        for (String itemMessage : CraftPresence.CONFIG.itemMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(itemMessage) || StringUtils.isNullOrEmpty((part = itemMessage.split(CraftPresence.CONFIG.splitCharacter))[0])) continue;
            if (!this.ITEM_NAMES.contains(part[0])) {
                this.ITEM_NAMES.add(part[0]);
            }
            if (this.BLOCK_NAMES.contains(part[0])) continue;
            this.BLOCK_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
        ArrayList removingBlocks = Lists.newArrayList();
        ArrayList removingItems = Lists.newArrayList();
        for (String itemName : this.ITEM_NAMES) {
            String lowerItemName;
            if (StringUtils.isNullOrEmpty(itemName) || !(lowerItemName = itemName.toLowerCase()).contains("tile.") && !lowerItemName.contains("item.") && !lowerItemName.contains(".") && !lowerItemName.contains(".name")) continue;
            removingItems.add(itemName);
        }
        for (String blockName : this.BLOCK_NAMES) {
            String lowerBlockName;
            if (StringUtils.isNullOrEmpty(blockName) || !(lowerBlockName = blockName.toLowerCase()).contains("tile.") && !lowerBlockName.contains("item.") && !lowerBlockName.contains(".") && !lowerBlockName.contains(".name")) continue;
            removingBlocks.add(blockName);
        }
        this.ITEM_NAMES.removeAll(removingItems);
        this.ITEM_NAMES.removeAll(this.BLOCK_NAMES);
        this.BLOCK_NAMES.removeAll(this.ITEM_NAMES);
        this.BLOCK_NAMES.removeAll(removingBlocks);
        this.ENTITY_NAMES.addAll(this.BLOCK_NAMES);
        this.ENTITY_NAMES.addAll(this.ITEM_NAMES);
        this.ENTITY_CLASSES.addAll(this.BLOCK_CLASSES);
        this.ENTITY_CLASSES.addAll(this.ITEM_CLASSES);
    }
}

