/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.discord;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.curse.CurseUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.ModIPCListener;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordBuild;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.RichPresence;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.User;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.pipe.PipeStatus;
import com.gitlab.cdagaming.craftpresence.utils.mcupdater.MCUpdaterUtils;
import com.gitlab.cdagaming.craftpresence.utils.multimc.MultiMCUtils;
import com.gitlab.cdagaming.craftpresence.utils.technic.TechnicUtils;
import com.google.common.collect.Lists;
import java.util.List;

public class DiscordUtils {
    public User CURRENT_USER;
    public User REQUESTER_USER;
    public String STATUS;
    public String GAME_STATE;
    public String DETAILS;
    public String SMALLIMAGEKEY;
    public String SMALLIMAGETEXT;
    public String LARGEIMAGEKEY;
    public String LARGEIMAGETEXT;
    public String CLIENT_ID;
    public long START_TIMESTAMP;
    public String PARTY_ID;
    public int PARTY_SIZE;
    public int PARTY_MAX;
    public String JOIN_SECRET;
    public long END_TIMESTAMP;
    public String MATCH_SECRET;
    public String SPECTATE_SECRET;
    public byte INSTANCE;
    public List<Tuple<String, String>> generalArgs = Lists.newArrayList();
    public IPCClient ipcInstance;
    public boolean awaitingReply = false;
    private Tuple<String, String> lastRequestedImageData = new Tuple();
    private RichPresence currentPresence;
    private List<Tuple<String, String>> messageData = Lists.newArrayList();
    private List<Tuple<String, String>> iconData = Lists.newArrayList();
    private List<Tuple<String, String>> modsArgs = Lists.newArrayList();
    private List<Tuple<String, String>> playerInfoArgs = Lists.newArrayList();

    public synchronized void setup() {
        Thread shutdownThread = new Thread("CraftPresence-ShutDown-Handler"){

            @Override
            public void run() {
                CraftPresence.closing = true;
                CraftPresence.timerObj.cancel();
                DiscordUtils.this.shutDown();
            }
        };
        shutdownThread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    public synchronized void init() {
        try {
            this.ipcInstance = new IPCClient(Long.parseLong(this.CLIENT_ID), ModUtils.IS_DEV);
            this.ipcInstance.setListener(new ModIPCListener());
            this.ipcInstance.connect(new DiscordBuild[0]);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN_REQUEST);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_SPECTATE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initArgumentData("&MAINMENU&", "&BRAND&", "&MCVERSION&", "&IGN&", "&MODS&", "&PACK&", "&DIMENSION&", "&BIOME&", "&SERVER&", "&GUI&", "&ENTITY&");
        this.initIconData("&DEFAULT&", "&MAINMENU&", "&PACK&", "&DIMENSION&", "&SERVER&");
        CommandUtils.isInMainMenu = false;
        this.modsArgs.add(new Tuple<String, String>("&MODCOUNT&", Integer.toString(FileUtils.getModCount())));
        this.playerInfoArgs.add(new Tuple<String, String>("&NAME&", ModUtils.USERNAME));
        this.generalArgs.add(new Tuple<String, String>("&MCVERSION&", ModUtils.TRANSLATOR.translate("craftpresence.defaults.state.mcversion", ModUtils.MCVersion)));
        this.generalArgs.add(new Tuple<String, String>("&BRAND&", ModUtils.BRAND));
        this.generalArgs.add(new Tuple<String, String>("&MODS&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.modsPlaceholderMSG, this.modsArgs)));
        this.generalArgs.add(new Tuple<String, String>("&IGN&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.outerPlayerPlaceholderMSG, this.playerInfoArgs)));
        for (Tuple<String, String> generalArgument : this.generalArgs) {
            this.syncArgument(generalArgument.getFirst(), generalArgument.getSecond(), false);
        }
        this.syncArgument("&DEFAULT&", CraftPresence.CONFIG.defaultIcon, true);
        this.syncPackArguments();
    }

    public void updateTimestamp() {
        if (CraftPresence.CONFIG.showTime) {
            this.START_TIMESTAMP = CraftPresence.SYSTEM.CURRENT_TIMESTAMP / 1000L;
        }
    }

    public void syncArgument(String argumentName, String insertString, boolean isIconData) {
        if (!StringUtils.isNullOrEmpty(argumentName)) {
            if (isIconData) {
                if (this.iconData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(argumentName) && !((String)e.getSecond()).equalsIgnoreCase(insertString))) {
                    this.iconData.add(new Tuple<String, String>(argumentName, insertString));
                }
            } else if (this.messageData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(argumentName) && !((String)e.getSecond()).equalsIgnoreCase(insertString))) {
                this.messageData.add(new Tuple<String, String>(argumentName, insertString));
            }
        }
    }

    public void initArgumentData(String ... args) {
        for (String argumentName : args) {
            this.messageData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(argumentName));
            this.messageData.add(new Tuple<String, String>(argumentName, ""));
        }
    }

    public void initIconData(String ... args) {
        for (String iconArgumentName : args) {
            this.iconData.removeIf(e -> ((String)e.getFirst()).equalsIgnoreCase(iconArgumentName));
            this.iconData.add(new Tuple<String, String>(iconArgumentName, ""));
        }
    }

    private void syncPackArguments() {
        String foundPackName = "";
        String foundPackIcon = "";
        if (ModUtils.BRAND.contains("vivecraft")) {
            CraftPresence.packFound = true;
            foundPackName = CraftPresence.CONFIG.vivecraftMessage;
            foundPackIcon = "vivecraft";
        } else if (CurseUtils.manifest != null && !StringUtils.isNullOrEmpty(CurseUtils.manifest.name)) {
            foundPackIcon = foundPackName = CurseUtils.manifest.name;
        } else if (!StringUtils.isNullOrEmpty(MultiMCUtils.INSTANCE_NAME)) {
            foundPackName = MultiMCUtils.INSTANCE_NAME;
            foundPackIcon = MultiMCUtils.ICON_KEY;
        } else if (MCUpdaterUtils.instance != null && !StringUtils.isNullOrEmpty(MCUpdaterUtils.instance.getPackName())) {
            foundPackIcon = foundPackName = MCUpdaterUtils.instance.getPackName();
        } else if (!StringUtils.isNullOrEmpty(TechnicUtils.PACK_NAME)) {
            foundPackName = TechnicUtils.PACK_NAME;
            foundPackIcon = TechnicUtils.ICON_NAME;
        }
        this.syncArgument("&PACK&", StringUtils.formatWord(StringUtils.replaceAnyCase(CraftPresence.CONFIG.packPlaceholderMSG, "&NAME&", !StringUtils.isNullOrEmpty(foundPackName) ? foundPackName : "")), false);
        this.syncArgument("&PACK&", !StringUtils.isNullOrEmpty(foundPackIcon) ? StringUtils.formatPackIcon(foundPackIcon) : "", true);
    }

    public void updatePresence(RichPresence presence) {
        if (!(presence == null || this.currentPresence != null && presence.toJson().toString().equals(this.currentPresence.toJson().toString()) || this.ipcInstance.getStatus() != PipeStatus.CONNECTED)) {
            this.ipcInstance.sendRichPresence(presence);
            this.currentPresence = presence;
        }
    }

    public String imageOf(String evalString, String alternativeString, boolean allowNull) {
        if (DiscordAssetUtils.syncCompleted) {
            if (StringUtils.isNullOrEmpty(this.lastRequestedImageData.getFirst()) || !this.lastRequestedImageData.getFirst().equalsIgnoreCase(evalString)) {
                String defaultIcon = DiscordAssetUtils.contains(CraftPresence.CONFIG.defaultIcon) ? CraftPresence.CONFIG.defaultIcon : DiscordAssetUtils.getRandomAsset();
                this.lastRequestedImageData.setFirst(evalString);
                String finalKey = evalString;
                if (!DiscordAssetUtils.contains(finalKey)) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.fallback", evalString, alternativeString), new Object[0]);
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.request", evalString), new Object[0]);
                    if (DiscordAssetUtils.contains(alternativeString)) {
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.fallback", evalString, alternativeString), new Object[0]);
                        finalKey = alternativeString;
                    } else if (allowNull) {
                        finalKey = "";
                    } else {
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.default", evalString), new Object[0]);
                        finalKey = defaultIcon;
                    }
                }
                this.lastRequestedImageData.setSecond(finalKey);
                return finalKey;
            }
            return this.lastRequestedImageData.getSecond();
        }
        return "";
    }

    public void clearPartyData(boolean clearRequesterData, boolean updateRPC) {
        if (clearRequesterData) {
            this.awaitingReply = false;
            this.REQUESTER_USER = null;
            CraftPresence.SYSTEM.TIMER = 0;
        }
        this.JOIN_SECRET = null;
        this.PARTY_ID = null;
        this.PARTY_SIZE = 0;
        this.PARTY_MAX = 0;
        if (updateRPC) {
            this.updatePresence(this.buildRichPresence());
        }
    }

    public synchronized void shutDown() {
        try {
            this.ipcInstance.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.STATUS = "disconnected";
        this.currentPresence = null;
        this.clearPartyData(true, false);
        this.CURRENT_USER = null;
        this.lastRequestedImageData = new Tuple();
        CraftPresence.DIMENSIONS.clearClientData();
        CraftPresence.ENTITIES.clearClientData();
        CraftPresence.BIOMES.clearClientData();
        CraftPresence.SERVER.clearClientData();
        CraftPresence.GUIS.clearClientData();
        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.shutdown", new Object[0]), new Object[0]);
    }

    public RichPresence buildRichPresence() {
        this.DETAILS = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.detailsMSG, this.messageData));
        this.GAME_STATE = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.gameStateMSG, this.messageData));
        String baseLargeImage = StringUtils.removeMatches(StringUtils.getMatches("&([^\\s]+?)&", CraftPresence.CONFIG.largeImageKey), this.iconData, 1);
        this.LARGEIMAGEKEY = StringUtils.sequentialReplaceAnyCase(baseLargeImage, this.iconData);
        String baseSmallImage = StringUtils.removeMatches(StringUtils.getMatches("&([^\\s]+?)&", CraftPresence.CONFIG.smallImageKey), this.iconData, 1);
        this.SMALLIMAGEKEY = StringUtils.sequentialReplaceAnyCase(baseSmallImage, this.iconData);
        this.LARGEIMAGETEXT = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.largeImageMSG, this.messageData));
        this.SMALLIMAGETEXT = StringUtils.formatWord(StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.smallImageMSG, this.messageData));
        RichPresence newRPCData = new RichPresence.Builder().setState(this.GAME_STATE).setDetails(this.DETAILS).setStartTimestamp(this.START_TIMESTAMP).setEndTimestamp(this.END_TIMESTAMP).setLargeImage(this.LARGEIMAGEKEY, this.LARGEIMAGETEXT).setSmallImage(this.SMALLIMAGEKEY, this.SMALLIMAGETEXT).setParty(this.PARTY_ID, this.PARTY_SIZE, this.PARTY_MAX).setMatchSecret(this.MATCH_SECRET).setJoinSecret(this.JOIN_SECRET).setSpectateSecret(this.SPECTATE_SECRET).build();
        this.GAME_STATE = StringUtils.getConvertedString(this.GAME_STATE, "UTF-8", false);
        this.DETAILS = StringUtils.getConvertedString(this.DETAILS, "UTF-8", false);
        this.LARGEIMAGEKEY = StringUtils.getConvertedString(this.LARGEIMAGEKEY, "UTF-8", false);
        this.SMALLIMAGEKEY = StringUtils.getConvertedString(this.SMALLIMAGEKEY, "UTF-8", false);
        this.LARGEIMAGETEXT = StringUtils.getConvertedString(this.LARGEIMAGETEXT, "UTF-8", false);
        this.SMALLIMAGETEXT = StringUtils.getConvertedString(this.SMALLIMAGETEXT, "UTF-8", false);
        return newRPCData;
    }
}

