/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.commands;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.gui.SelectorGui;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;

public class CommandsGui
extends GuiScreen {
    private static String[] executionCommandArgs;
    public final GuiScreen parentScreen;
    public final GuiScreen currentScreen;
    public ExtendedButtonControl proceedButton;
    private GuiTextField commandInput;
    private String executionString;
    private String[] commandArgs;
    private String[] filteredCommandArgs;
    private List<String> tabCompletions = Lists.newArrayList();

    public CommandsGui(GuiScreen parentScreen) {
        this.field_146297_k = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
    }

    public static void executeCommand(String ... args) {
        executionCommandArgs = args;
    }

    private static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (String s1 : possibleCompletions.stream().map(arg_0 -> ((Function)Functions.toStringFunction()).apply(arg_0)).collect(Collectors.toList())) {
                if (!CommandsGui.doesStringStartWith(s, s1)) continue;
                list.add(s1);
            }
            if (list.isEmpty()) {
                for (Object object : possibleCompletions) {
                    if (StringUtils.isNullOrEmpty(String.valueOf(object)) || !CommandsGui.doesStringStartWith(s, String.valueOf(object))) continue;
                    list.add(String.valueOf(object));
                }
            }
        }
        return list;
    }

    private static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.commandInput = new GuiTextField(this.field_146297_k.field_71466_p, 115, this.field_146295_m - 30, this.field_146294_l - 120, 20);
        this.commandInput.func_146203_f(512);
        this.proceedButton = new ExtendedButtonControl(700, 10, this.field_146295_m - 30, 100, 20, ModUtils.TRANSLATOR.translate("gui.config.buttonMessage.back", new Object[0]), new String[0]);
        this.field_146292_n.add(this.proceedButton);
        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        CraftPresence.GUIS.drawBackground(this.field_146294_l, this.field_146295_m);
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.commands", new Object[0]);
        this.func_73731_b(this.field_146297_k.field_71466_p, mainTitle, this.field_146294_l / 2 - StringUtils.getStringWidth(mainTitle) / 2, 10, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, subTitle, this.field_146294_l / 2 - StringUtils.getStringWidth(subTitle) / 2, 20, 0xFFFFFF);
        if (!StringUtils.isNullOrEmpty(this.commandInput.func_146179_b()) && this.commandInput.func_146179_b().startsWith("/")) {
            this.commandArgs = this.commandInput.func_146179_b().replace("/", "").split(" ");
            this.filteredCommandArgs = this.commandInput.func_146179_b().replace("/", "").replace("cp", "").replace("craftpresence", "").trim().split(" ");
            this.tabCompletions = this.getTabCompletions(this.filteredCommandArgs);
        }
        this.commandInput.func_146194_f();
        if (executionCommandArgs != null) {
            if (executionCommandArgs.length == 0 || executionCommandArgs[0].equalsIgnoreCase("help") || executionCommandArgs[0].equalsIgnoreCase("?") || executionCommandArgs[0].equalsIgnoreCase("")) {
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
            } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[0])) {
                if (executionCommandArgs[0].equalsIgnoreCase("request")) {
                    if (executionCommandArgs.length == 1) {
                        if (!StringUtils.isNullOrEmpty(CraftPresence.CLIENT.STATUS) && CraftPresence.CLIENT.STATUS.equalsIgnoreCase("joinRequest") && CraftPresence.CLIENT.REQUESTER_USER != null) {
                            if (CraftPresence.CONFIG.enableJoinRequest) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.info", CraftPresence.CLIENT.REQUESTER_USER.getName(), CraftPresence.SYSTEM.TIMER);
                                CraftPresence.CLIENT.awaitingReply = true;
                            } else {
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY, null);
                                CraftPresence.CLIENT.STATUS = "ready";
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                            CraftPresence.CLIENT.awaitingReply = false;
                        }
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (CraftPresence.CLIENT.awaitingReply && CraftPresence.CONFIG.enableJoinRequest) {
                            if (executionCommandArgs[1].equalsIgnoreCase("accept")) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.accept", CraftPresence.CLIENT.REQUESTER_USER.getName());
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.ACCEPT, null);
                                CraftPresence.CLIENT.STATUS = "ready";
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            } else if (executionCommandArgs[1].equalsIgnoreCase("deny")) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.denied", CraftPresence.CLIENT.REQUESTER_USER.getName());
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY, null);
                                CraftPresence.CLIENT.STATUS = "ready";
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                        }
                    }
                } else if (executionCommandArgs[0].equalsIgnoreCase("reload")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reload", new Object[0]);
                    CommandUtils.reloadData(true);
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reload.complete", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("shutdown")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.shutdown.pre", new Object[0]);
                    CraftPresence.CLIENT.shutDown();
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.shutdown.post", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("reboot")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reboot.pre", new Object[0]);
                    CommandUtils.rebootRPC();
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reboot.post", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("view")) {
                    if (executionCommandArgs.length == 1) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.view", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (executionCommandArgs[1].equalsIgnoreCase("items")) {
                            if (CraftPresence.ENTITIES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, false));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.hoverMessage.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.itemmessages", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("servers")) {
                            if (CraftPresence.SERVER.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.servers", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, false));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.hoverMessage.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.showstate", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("guis")) {
                            if (CraftPresence.GUIS.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.guis", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, false));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.hoverMessage.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.guimessages", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("biomes")) {
                            if (CraftPresence.BIOMES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.biomes", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, false));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.hoverMessage.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.showbiome", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("dimensions")) {
                            if (CraftPresence.DIMENSIONS.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.dimensions", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, false));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.hoverMessage.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.showdimension", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("currentData")) {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.currentdata", CraftPresence.CLIENT.CURRENT_USER.getName(), StringUtils.getConvertedString(CraftPresence.CLIENT.DETAILS, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.GAME_STATE, "UTF-8", true), CraftPresence.CLIENT.START_TIMESTAMP, CraftPresence.CLIENT.CLIENT_ID, StringUtils.getConvertedString(CraftPresence.CLIENT.LARGEIMAGEKEY, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.LARGEIMAGETEXT, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.SMALLIMAGEKEY, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.SMALLIMAGETEXT, "UTF-8", true), CraftPresence.CLIENT.PARTY_ID, CraftPresence.CLIENT.PARTY_SIZE, CraftPresence.CLIENT.PARTY_MAX, CraftPresence.CLIENT.JOIN_SECRET, CraftPresence.CLIENT.END_TIMESTAMP, CraftPresence.CLIENT.MATCH_SECRET, CraftPresence.CLIENT.SPECTATE_SECRET, CraftPresence.CLIENT.INSTANCE);
                        } else if (executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (executionCommandArgs.length == 2) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.assets", new Object[0]);
                            } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[2])) {
                                if (executionCommandArgs[2].equalsIgnoreCase("large")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.large", new Object[0]), DiscordAssetUtils.LARGE_ICONS, null, null, false));
                                } else if (executionCommandArgs[2].equalsIgnoreCase("small")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.small", new Object[0]), DiscordAssetUtils.SMALL_ICONS, null, null, false));
                                } else if (executionCommandArgs[2].equalsIgnoreCase("all")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, null, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.all", new Object[0]), DiscordAssetUtils.ICON_LIST, null, null, false));
                                }
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                }
            } else {
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.logger.error.command", new Object[0]);
            }
        }
        executionCommandArgs = null;
        CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(this.executionString), 25, 45, this.field_146294_l, this.field_146295_m, -1, this.field_146297_k.field_71466_p, false);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.proceedButton.field_146127_k) {
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }
        if (this.commandInput.func_146206_l() && this.commandInput.func_146179_b().startsWith("/") && this.commandArgs != null && (this.commandArgs[0].equalsIgnoreCase("cp") || this.commandArgs[0].equalsIgnoreCase("craftpresence"))) {
            if (keyCode == 15 && !this.tabCompletions.isEmpty()) {
                if (this.commandArgs.length > 1 && (this.filteredCommandArgs[this.filteredCommandArgs.length - 1].length() > 1 || this.filteredCommandArgs[this.filteredCommandArgs.length - 1].equalsIgnoreCase("?"))) {
                    this.commandInput.func_146180_a(this.commandInput.func_146179_b().replace(this.filteredCommandArgs[this.filteredCommandArgs.length - 1], this.tabCompletions.get(0)));
                }
            } else if (keyCode == 28 || keyCode == 156) {
                CommandsGui.executeCommand(this.filteredCommandArgs);
            }
        }
        this.commandInput.func_146201_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        this.commandInput.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        this.commandInput.func_146178_a();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private List<String> getTabCompletions(String[] args) {
        ArrayList baseCompletions = Lists.newArrayList();
        ArrayList assetsCompletions = Lists.newArrayList();
        ArrayList viewCompletions = Lists.newArrayList();
        ArrayList requestCompletions = Lists.newArrayList();
        baseCompletions.add("?");
        baseCompletions.add("help");
        baseCompletions.add("config");
        baseCompletions.add("reload");
        baseCompletions.add("request");
        baseCompletions.add("view");
        baseCompletions.add("reboot");
        baseCompletions.add("shutdown");
        viewCompletions.add("currentData");
        viewCompletions.add("assets");
        viewCompletions.add("dimensions");
        viewCompletions.add("biomes");
        viewCompletions.add("guis");
        viewCompletions.add("items");
        viewCompletions.add("servers");
        assetsCompletions.add("all");
        assetsCompletions.add("large");
        assetsCompletions.add("small");
        requestCompletions.add("accept");
        requestCompletions.add("deny");
        if (args.length == 1) {
            return CommandsGui.getListOfStringsMatchingLastWord(args, baseCompletions);
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("view")) {
                return CommandsGui.getListOfStringsMatchingLastWord(args, viewCompletions);
            }
            if (args[0].equalsIgnoreCase("request")) {
                return CommandsGui.getListOfStringsMatchingLastWord(args, requestCompletions);
            }
            return Collections.emptyList();
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("view") && args[1].equalsIgnoreCase("assets")) {
                return CommandsGui.getListOfStringsMatchingLastWord(args, assetsCompletions);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

