/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class StringUtils {
    private static final char COLOR_CHAR = '\u00a7';
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\([^0-9]*\\d+[^0-9]*\\)");
    public static int[] MC_CHAR_WIDTH = new int[256];
    public static byte[] MC_GLYPH_WIDTH = new byte[65536];

    public static Color getColorFromHex(String hexColor) {
        try {
            if (hexColor.length() == 7 && !StringUtils.isNullOrEmpty(hexColor.substring(1))) {
                int r = Integer.valueOf(hexColor.substring(1, 3), 16);
                int g = Integer.valueOf(hexColor.substring(3, 5), 16);
                int b = Integer.valueOf(hexColor.substring(5, 7), 16);
                return new Color(r, g, b);
            }
            if (hexColor.length() == 6 && !hexColor.startsWith("#")) {
                int r = Integer.valueOf(hexColor.substring(0, 2), 16);
                int g = Integer.valueOf(hexColor.substring(2, 4), 16);
                int b = Integer.valueOf(hexColor.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            return Color.white;
        }
        catch (Exception ex) {
            return Color.white;
        }
    }

    public static String getConvertedString(String original, String encoding, boolean decode) {
        try {
            if (decode) {
                return new String(original.getBytes(), encoding).replaceAll("\\s+", " ");
            }
            return new String(original.getBytes(encoding)).replaceAll("\\s+", " ");
        }
        catch (Exception ex) {
            return original;
        }
    }

    public static double roundDouble(double value, int places) {
        if (places > 0) {
            BigDecimal bd = new BigDecimal(Double.toString(value));
            bd = bd.setScale(places, RoundingMode.HALF_UP);
            return bd.doubleValue();
        }
        return value;
    }

    public static String getHexFromColor(Color color) {
        return "0x" + StringUtils.toSafeHexValue(color.getAlpha()) + StringUtils.toSafeHexValue(color.getRed()) + StringUtils.toSafeHexValue(color.getGreen()) + StringUtils.toSafeHexValue(color.getBlue());
    }

    private static String toSafeHexValue(int number) {
        StringBuilder builder = new StringBuilder(Integer.toHexString(number & 0xFF));
        while (builder.length() < 2) {
            builder.append("0");
        }
        return builder.toString().toUpperCase();
    }

    public static Tuple<String, List<String>> getMatches(String regexValue, String original) {
        ArrayList matches = Lists.newArrayList();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pattern pattern = Pattern.compile(regexValue);
            Matcher m = pattern.matcher(original);
            while (m.find()) {
                matches.add(m.group());
            }
        }
        return new Tuple<String, List<String>>(original, matches);
    }

    public static String removeMatches(Tuple<String, List<String>> matchData, List<Tuple<String, String>> parsedMatchData, int maxMatches) {
        String finalString = "";
        if (matchData != null) {
            finalString = matchData.getFirst();
            List<String> matchList = matchData.getSecond();
            if (!matchList.isEmpty()) {
                int foundMatches = 0;
                for (String match : matchList) {
                    boolean isValidScan = foundMatches >= maxMatches;
                    boolean alreadyRemoved = false;
                    if (parsedMatchData != null && !parsedMatchData.isEmpty()) {
                        for (Tuple<String, String> parsedArgument : parsedMatchData) {
                            if (!parsedArgument.getFirst().equalsIgnoreCase(match) || !StringUtils.isNullOrEmpty(parsedArgument.getSecond())) continue;
                            finalString = finalString.replaceFirst(match, "");
                            alreadyRemoved = true;
                            break;
                        }
                    }
                    if (alreadyRemoved) continue;
                    if (isValidScan) {
                        finalString = finalString.replaceFirst(match, "");
                    }
                    ++foundMatches;
                }
            }
        }
        return finalString;
    }

    public static String replaceAnyCase(String source, String targetToReplace, String replaceWith) {
        if (!StringUtils.isNullOrEmpty(source)) {
            return Pattern.compile(targetToReplace, 82).matcher(source).replaceAll(Matcher.quoteReplacement(replaceWith));
        }
        return "";
    }

    public static String sequentialReplaceAnyCase(String source, List<Tuple<String, String>> replaceData) {
        if (!StringUtils.isNullOrEmpty(source)) {
            String finalResult = source;
            if (!replaceData.isEmpty()) {
                for (Tuple<String, String> replacementData : replaceData) {
                    finalResult = StringUtils.replaceAnyCase(finalResult, replacementData.getFirst(), replacementData.getSecond());
                }
            }
            return finalResult;
        }
        return "";
    }

    public static boolean isNullOrEmpty(String entry) {
        return entry == null || entry.isEmpty() || entry.equalsIgnoreCase("null");
    }

    public static boolean isValidBoolean(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (entry.equalsIgnoreCase("true") || entry.equalsIgnoreCase("false"));
    }

    public static boolean isValidColorCode(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (entry.startsWith("#") || entry.length() == 6 || entry.startsWith("0x") || StringUtils.getValidInteger(entry).getFirst() != false);
    }

    public static Tuple<Boolean, Integer> getValidInteger(String entry) {
        Tuple<Boolean, Integer> finalSet = new Tuple<Boolean, Integer>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Integer.parseInt(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static Tuple<Boolean, Long> getValidLong(String entry) {
        Tuple<Boolean, Long> finalSet = new Tuple<Boolean, Long>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Long.parseLong(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static String formatIP(String input, boolean returnPort) {
        if (!StringUtils.isNullOrEmpty(input)) {
            String[] formatted = input.split(":", 2);
            return !returnPort ? (StringUtils.elementExists(formatted, 0) ? formatted[0].trim() : "127.0.0.1") : (StringUtils.elementExists(formatted, 1) ? formatted[1].trim() : "25565");
        }
        return !returnPort ? "127.0.0.1" : "25565";
    }

    public static String formatPackIcon(String original) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey)) {
            return formattedKey;
        }
        if (formattedKey.contains("\\s")) {
            formattedKey = formattedKey.replaceAll("\\s+", "");
        }
        if (formattedKey.contains("'")) {
            formattedKey = formattedKey.replaceAll("'", "");
        }
        if (formattedKey.contains(".")) {
            formattedKey = formattedKey.replaceAll("\\.", "_");
        }
        if (BRACKET_PATTERN.matcher(formattedKey).find()) {
            formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
        }
        if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
            formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
        }
        return formattedKey.toLowerCase().trim();
    }

    public static String[] adjustArraySize(String[] theArray, int adjustBy) {
        int currentSize = theArray.length;
        int newSize = currentSize + adjustBy;
        String[] newArray = new String[newSize];
        System.arraycopy(theArray, 0, newArray, 0, theArray.length);
        return newArray;
    }

    public static String[] addToArray(String[] array, int index, String message) {
        if (array.length <= index) {
            int extendNum = index - array.length;
            String[] newArray = StringUtils.adjustArraySize(array, extendNum + 1);
            newArray[index] = message;
            return newArray;
        }
        array[index] = message;
        return array;
    }

    public static String[] removeFromArray(String[] originalArray, String searchTerm, int searchIndex, String splitCharacter) {
        int indexNumber = 0;
        LinkedList formatted = Lists.newLinkedList(Arrays.asList(originalArray));
        if (!StringUtils.isNullOrEmpty(((Object)formatted).toString())) {
            for (String part : formatted) {
                String[] splitPart = part.split(splitCharacter);
                if (!StringUtils.isNullOrEmpty(splitPart[searchIndex]) && splitPart[searchIndex].equalsIgnoreCase(searchTerm)) {
                    formatted.remove(indexNumber);
                    break;
                }
                ++indexNumber;
            }
        }
        return formatted.toArray(new String[0]);
    }

    public static String getConfigPart(String[] original, String searchTerm, int searchIndex, int resultIndex, String splitCharacter, String alternativeMSG) {
        String formattedKey = "";
        boolean matched = false;
        for (String part : original) {
            String[] splitPart = part.split(splitCharacter);
            if (!splitPart[searchIndex].equalsIgnoreCase(searchTerm) || !StringUtils.elementExists(splitPart, resultIndex)) continue;
            formattedKey = splitPart[resultIndex];
            matched = true;
            break;
        }
        return !matched && !StringUtils.isNullOrEmpty(alternativeMSG) ? alternativeMSG : formattedKey;
    }

    public static String[] setConfigPart(String[] original, String searchTerm, int searchIndex, int resultIndex, String splitCharacter, String newMessage) {
        int indexNumber = -1;
        boolean replacing = false;
        Object[] formatted = original;
        String searchKey = searchTerm;
        if (searchKey.contains(" ")) {
            searchKey = searchKey.replaceAll("\\s+", "");
        }
        if (!StringUtils.isNullOrEmpty(Arrays.toString(formatted))) {
            for (Object part : formatted) {
                ++indexNumber;
                String[] splitPart = ((String)part).split(splitCharacter);
                if (!splitPart[searchIndex].equalsIgnoreCase(searchKey)) continue;
                replacing = true;
                if (StringUtils.elementExists(splitPart, resultIndex)) {
                    String formattedText = ((String)part).replace(splitPart[resultIndex], newMessage);
                    formatted[indexNumber] = formattedText;
                    break;
                }
                formatted[indexNumber] = (String)part + splitCharacter + newMessage;
                break;
            }
            if (!replacing) {
                formatted = StringUtils.addToArray(original, indexNumber + 1, searchKey + splitCharacter + newMessage);
            }
        }
        return formatted;
    }

    public static String formatWord(String original) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey)) {
            return formattedKey;
        }
        if (formattedKey.contains("_")) {
            formattedKey = formattedKey.replaceAll("_", " ");
        }
        if (formattedKey.contains("-")) {
            formattedKey = formattedKey.replaceAll("-", " ");
        }
        if (formattedKey.contains(" ")) {
            formattedKey = formattedKey.replaceAll("\\s+", " ");
        }
        if (BRACKET_PATTERN.matcher(formattedKey).find()) {
            formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
        }
        if (STRIP_COLOR_PATTERN.matcher(formattedKey).find()) {
            formattedKey = STRIP_COLOR_PATTERN.matcher(formattedKey).replaceAll("");
        }
        return StringUtils.removeRepeatWords(StringUtils.capitalizeWord(formattedKey)).trim();
    }

    public static String removeRepeatWords(String original) {
        String[] wordList;
        if (StringUtils.isNullOrEmpty(original)) {
            return original;
        }
        String lastWord = "";
        StringBuilder finalString = new StringBuilder();
        for (String word : wordList = original.split(" ")) {
            if (!StringUtils.isNullOrEmpty(lastWord) && word.equals(lastWord)) continue;
            finalString.append(word).append(" ");
            lastWord = word;
        }
        return finalString.toString().trim();
    }

    public static String formatDimensionName(String dimName, boolean formatToID) {
        StringBuilder formattedKey = new StringBuilder(dimName);
        if (StringUtils.isNullOrEmpty(formattedKey.toString())) {
            return formattedKey.toString();
        }
        if (formattedKey.toString().contains("WorldProvider")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("WorldProvider", ""));
        }
        if (formattedKey.toString().contains(" ")) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("\\s+", " "));
        }
        if (formattedKey.toString().contains(":")) {
            formattedKey = new StringBuilder(formattedKey.toString().split(":", 2)[1]);
        }
        if (formattedKey.toString().contains("{") || formattedKey.toString().contains("}")) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("[{}]", ""));
        }
        if (formattedKey.toString().equalsIgnoreCase("surface")) {
            return "overworld";
        }
        if (formattedKey.toString().equalsIgnoreCase("hell") || formattedKey.toString().equalsIgnoreCase("nether")) {
            return "the_nether";
        }
        if (formattedKey.toString().equalsIgnoreCase("end") || formattedKey.toString().equalsIgnoreCase("sky")) {
            return "the_end";
        }
        if (formatToID) {
            return StringUtils.formatPackIcon(formattedKey.toString().replace(" ", "_"));
        }
        return StringUtils.formatWord(formattedKey.toString());
    }

    public static String wrapFormattedStringToWidth(String stringInput, int wrapWidth) {
        int stringSizeToWidth = StringUtils.sizeStringToWidth(stringInput, wrapWidth);
        if (stringInput.length() <= stringSizeToWidth) {
            return stringInput;
        }
        String subString = stringInput.substring(0, stringSizeToWidth);
        char currentCharacter = stringInput.charAt(stringSizeToWidth);
        boolean flag = Character.isSpaceChar(currentCharacter) || currentCharacter == '\n';
        String s1 = StringUtils.getFormatFromString(subString) + stringInput.substring(stringSizeToWidth + (flag ? 1 : 0));
        return subString + "\n" + StringUtils.wrapFormattedStringToWidth(s1, wrapWidth);
    }

    public static String getFormatFromString(String text) {
        StringBuilder s = new StringBuilder();
        int index = -1;
        int stringLength = text.length();
        while ((index = text.indexOf(167, index + 1)) != -1) {
            char currentCharacter;
            if (index >= stringLength - 1 || !STRIP_COLOR_PATTERN.matcher(String.valueOf(currentCharacter = text.charAt(index + 1))).find()) continue;
            s = new StringBuilder("\u00a7" + currentCharacter);
        }
        return s.toString();
    }

    public static int getStringWidth(String stringEntry) {
        if (StringUtils.isNullOrEmpty(stringEntry)) {
            return 0;
        }
        int strLength = 0;
        for (char strChar : stringEntry.toCharArray()) {
            strLength += StringUtils.getCharWidth(strChar, ModUtils.TRANSLATOR.isUnicode);
        }
        return strLength;
    }

    public static int getCharWidth(char characterInput, boolean usingUnicode) {
        if (Character.isSpaceChar(characterInput) || characterInput == '\u00a0') {
            return 4;
        }
        if (characterInput == '\u00a7') {
            return -1;
        }
        try {
            if (characterInput > '\u0000' && characterInput <= MC_CHAR_WIDTH.length && !usingUnicode) {
                return MC_CHAR_WIDTH[characterInput];
            }
            if (MC_GLYPH_WIDTH[characterInput] != 0) {
                int glyphIndex = MC_GLYPH_WIDTH[characterInput] & 0xFF;
                int shiftedIndex = glyphIndex >>> 4;
                int remappedIndex = glyphIndex & 0xF;
                return (++remappedIndex - shiftedIndex) / 2 + 1;
            }
            return 4;
        }
        catch (Exception ex) {
            return 4;
        }
    }

    public static int sizeStringToWidth(String stringEntry, int wrapWidth) {
        int currentLine;
        int stringLength = stringEntry.length();
        int charWidth = 0;
        int currentIndex = -1;
        boolean flag = false;
        for (currentLine = 0; currentLine < stringLength; ++currentLine) {
            char currentCharacter = stringEntry.charAt(currentLine);
            if (currentCharacter == ' ' || currentCharacter == '\n') {
                currentIndex = currentLine;
                if (currentCharacter == '\n') break;
            }
            if (currentCharacter == '\u00a7' && currentLine < stringLength - 1) {
                String stringOfCharacter;
                flag = (stringOfCharacter = String.valueOf(currentCharacter = stringEntry.charAt(++currentLine))).equalsIgnoreCase("l") && !stringOfCharacter.equalsIgnoreCase("r") && !STRIP_COLOR_PATTERN.matcher(stringOfCharacter).find();
            }
            charWidth += StringUtils.getCharWidth(currentCharacter, ModUtils.TRANSLATOR.isUnicode);
            if (flag) {
                ++charWidth;
            }
            if (charWidth > wrapWidth) break;
        }
        return currentLine != stringLength && currentIndex != -1 && currentIndex < currentLine ? currentIndex : currentLine;
    }

    public static String capitalizeWord(String str) {
        StringBuilder s = new StringBuilder();
        int charIndex = 32;
        for (int index = 0; index < str.length(); ++index) {
            if (charIndex == 32 && str.charAt(index) != ' ') {
                s.append(Character.toUpperCase(str.charAt(index)));
            } else {
                s.append(str.charAt(index));
            }
            charIndex = str.charAt(index);
        }
        return s.toString().trim();
    }

    public static List<String> splitTextByNewLine(String original) {
        if (!StringUtils.isNullOrEmpty(original)) {
            String formattedText = original;
            if (formattedText.contains("\n")) {
                formattedText = original.replace("\n", "&newline&");
            }
            if (formattedText.contains("\\n")) {
                formattedText = original.replace("\\n", "&newline&");
            }
            if (formattedText.contains("\\\\n+")) {
                formattedText = original.replace("\\\\n+", "&newline&");
            }
            return Arrays.asList(formattedText.split("&newline&"));
        }
        return Lists.newArrayList();
    }

    public static void sendMessageToPlayer(Entity sender, String message) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            List<String> lines = StringUtils.splitTextByNewLine(message);
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(line));
                }
            }
        }
    }

    public static InputStream getResourceAsStream(Class<?> fallbackClass, String pathToSearch) {
        InputStream in = null;
        boolean useFallback = false;
        try {
            in = ModUtils.CLASS_LOADER.getResourceAsStream(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResourceAsStream(pathToSearch);
        }
        return in;
    }

    public static boolean elementExists(String[] data, int index) {
        return StringUtils.elementExists(Arrays.asList(data), index);
    }

    public static boolean elementExists(List<String> data, int index) {
        boolean result;
        try {
            result = data.size() >= index && !StringUtils.isNullOrEmpty(data.get(index));
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static Object lookupObject(Class<?> classToAccess, Object instance, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                Field lookupField = classToAccess.getDeclaredField(fieldName);
                if (lookupField == null) continue;
                lookupField.setAccessible(true);
                return lookupField.get(instance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void updateField(Class<?> classToAccess, Object instance, Tuple<?, ?> ... fieldData) {
        for (Tuple<?, ?> currentData : fieldData) {
            try {
                Field lookupField = classToAccess.getDeclaredField(currentData.getFirst().toString());
                if (lookupField == null) continue;
                lookupField.setAccessible(true);
                lookupField.set(instance, currentData.getSecond());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void executeMethod(Class<?> classToAccess, Object instance, List<Tuple<String, Tuple<Object[], Class<?>[]>>> methodData) {
        for (Tuple<String, Tuple<Object[], Class<?>[]>> methodInstance : methodData) {
            try {
                Method lookupMethod = classToAccess.getDeclaredMethod(methodInstance.getFirst(), methodInstance.getSecond().getSecond());
                if (lookupMethod == null) continue;
                lookupMethod.setAccessible(true);
                lookupMethod.invoke(instance, methodInstance.getSecond().getFirst());
            }
            catch (Exception exception) {}
        }
    }

    public static int generateHash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static String stripColors(String input) {
        return StringUtils.isNullOrEmpty(input) ? input : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }
}

