/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.lwjgl.input.Keyboard;

public class KeyUtils {
    private int keyStartLimit = 0;
    private List<Integer> invalidKeys = Lists.newArrayList((Object[])new Integer[]{1, 256});

    public boolean isValidKeyCode(int sourceKeyCode) {
        return sourceKeyCode > this.keyStartLimit && !this.invalidKeys.contains(sourceKeyCode);
    }

    public String getKeyName(String original) {
        if (!StringUtils.isNullOrEmpty(original)) {
            Tuple<Boolean, Integer> integerData = StringUtils.getValidInteger(original);
            if (integerData.getFirst().booleanValue() && this.isValidKeyCode(integerData.getSecond())) {
                String keyName = Keyboard.getKeyName((int)integerData.getSecond());
                if (!StringUtils.isNullOrEmpty(keyName)) {
                    return keyName;
                }
                return original;
            }
            return Keyboard.getKeyName((int)0);
        }
        return Keyboard.getKeyName((int)0);
    }

    void onTick() {
        if (Keyboard.isCreated() && CraftPresence.CONFIG != null) {
            try {
                if (this.isValidKeyCode(Integer.parseInt(CraftPresence.CONFIG.configKeyCode)) && Keyboard.isKeyDown((int)Integer.parseInt(CraftPresence.CONFIG.configKeyCode)) && !CraftPresence.GUIS.isFocused && !CraftPresence.GUIS.openConfigGUI && !CraftPresence.GUIS.configGUIOpened) {
                    CraftPresence.GUIS.openConfigGUI = true;
                }
            }
            catch (Error | Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.keybind", CraftPresence.CONFIG.NAME_configKeyCode.replaceAll("_", " ")), new Object[0]);
                CraftPresence.CONFIG.configKeyCode = Integer.toString(41);
                CraftPresence.CONFIG.updateConfig();
            }
        }
    }
}

