/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.reflect.ClassPath;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtils {
    private static Gson GSON = new GsonBuilder().create();

    public static <T> T getJSONFromFile(File file, Class<T> classObj) throws Exception {
        return FileUtils.getJSONFromFile(FileUtils.fileToString(file, "UTF-8"), classObj);
    }

    public static <T> T getJSONFromFile(String file, Class<T> classObj) {
        return (T)GSON.fromJson(file, classObj);
    }

    public static JsonObject parseJson(String json) {
        if (!StringUtils.isNullOrEmpty(json)) {
            JsonParser dataParser = new JsonParser();
            return dataParser.parse(json).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static void downloadFile(String urlString, File file) {
        try {
            boolean fileDeleted;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.download.init", file.getName(), file.getAbsolutePath(), urlString), new Object[0]);
            URL url = new URL(urlString);
            if (file.exists() && !(fileDeleted = file.delete())) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.delete.file", file.getName()), new Object[0]);
            }
            org.apache.commons.io.FileUtils.copyURLToFile((URL)url, (File)file);
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.download.loaded", file.getName(), file.getAbsolutePath(), urlString), new Object[0]);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.download", file.getName(), urlString, file.getAbsolutePath()), new Object[0]);
            ex.printStackTrace();
        }
    }

    public static void loadFileAsDLL(File file) {
        try {
            boolean isPermsSet;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.dll.init", file.getName()), new Object[0]);
            boolean bl = isPermsSet = file.setReadable(true) && file.setWritable(true);
            if (isPermsSet) {
                System.load(file.getAbsolutePath());
            }
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.dll.loaded", file.getName()), new Object[0]);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.dll", file.getName()), new Object[0]);
            ex.printStackTrace();
        }
    }

    public static String fileToString(File file, String encoding) throws Exception {
        return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)Charset.forName(encoding));
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    public static int getModCount() {
        int modCount = ModUtils.IS_DEV ? 1 : 0;
        File[] mods = new File(ModUtils.modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                ++modCount;
            }
        }
        return modCount;
    }

    public static List<Class<?>> getClassNamesMatchingSuperType(List<Class<?>> searchList, String ... sourcePackages) {
        ArrayList matchingClasses = Lists.newArrayList();
        ArrayList availableClassList = Lists.newArrayList();
        ArrayList classList = Lists.newArrayList();
        try {
            classList.addAll(ClassPath.from((ClassLoader)ModUtils.CLASS_LOADER).getTopLevelClasses());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (ClassPath.ClassInfo classInfo : classList) {
            for (String startString : sourcePackages) {
                if (!classInfo.getName().startsWith(startString) || classInfo.getName().contains("FMLServerHandler") || classInfo.getName().toLowerCase().contains("mixin")) continue;
                try {
                    Class<?> classObj = Class.forName(classInfo.getName());
                    availableClassList.add(classObj);
                    for (Class<?> subClassObj : classObj.getClasses()) {
                        if (availableClassList.contains(subClassObj)) continue;
                        availableClassList.add(subClassObj);
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
        }
        Iterator<Object> iterator = availableClassList.iterator();
        while (iterator.hasNext()) {
            Class classObj;
            Class currentClassObj = classObj = (Class)iterator.next();
            ArrayList superClassList = Lists.newArrayList();
            while (currentClassObj.getSuperclass() != null && !searchList.contains(currentClassObj.getSuperclass())) {
                superClassList.add(currentClassObj.getSuperclass());
                currentClassObj = currentClassObj.getSuperclass();
            }
            if (currentClassObj.getSuperclass() == null || !searchList.contains(currentClassObj.getSuperclass())) continue;
            matchingClasses.add(classObj);
            matchingClasses.addAll(superClassList);
        }
        for (String modClassString : FileUtils.getModClassNames()) {
            ArrayList superClassList = Lists.newArrayList();
            if (modClassString.toLowerCase().contains("mixin")) continue;
            try {
                Class<?> modClassObj;
                Class<?> currentClassObj = modClassObj = Class.forName(modClassString);
                if (modClassObj == null) continue;
                while (currentClassObj.getSuperclass() != null && !searchList.contains(currentClassObj.getSuperclass())) {
                    superClassList.add(currentClassObj.getSuperclass());
                    currentClassObj = currentClassObj.getSuperclass();
                }
                if (currentClassObj.getSuperclass() == null || !searchList.contains(currentClassObj.getSuperclass())) continue;
                matchingClasses.add(modClassObj);
                matchingClasses.addAll(superClassList);
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
        }
        return matchingClasses;
    }

    public static List<Class<?>> getClassNamesMatchingSuperType(Class<?> searchTarget, String ... sourcePackages) {
        return FileUtils.getClassNamesMatchingSuperType(Lists.newArrayList((Object[])new Class[]{searchTarget}), sourcePackages);
    }

    public static List<String> getModClassNames() {
        ArrayList classNames = Lists.newArrayList();
        File[] mods = new File(ModUtils.modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                try {
                    JarFile jarFile = new JarFile(modFile.getAbsolutePath());
                    Enumeration<JarEntry> allEntries = jarFile.entries();
                    while (allEntries.hasMoreElements()) {
                        JarEntry entry = allEntries.nextElement();
                        String file = entry.getName();
                        if (!file.endsWith(".class")) continue;
                        String className = file.replace('/', '.').substring(0, file.length() - 6);
                        classNames.add(className);
                    }
                    jarFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return classNames;
        }
        return Lists.newArrayList();
    }
}

