/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.SliderControl;
import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class ColorEditorGui
extends GuiScreen {
    private final GuiScreen parentScreen;
    private int pageNumber;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl nextPageButton;
    private ExtendedButtonControl previousPageButton;
    private String configValueName;
    private String currentNormalHexValue;
    private String currentConvertedHexValue;
    private String startingHexValue;
    private int currentRed;
    private int currentGreen;
    private int currentBlue;
    private int currentAlpha;
    private GuiTextField hexText;
    private SliderControl redText;
    private SliderControl greenText;
    private SliderControl blueText;
    private SliderControl alphaText;
    private String currentNormalMCTexturePath;
    private String currentConvertedMCTexturePath;
    private String startingMCTexturePath;
    private GuiTextField mcTextureText;
    private ResourceLocation currentMCTexture;

    ColorEditorGui(GuiScreen parentScreen, String configValueName) {
        this.field_146297_k = CraftPresence.instance;
        this.pageNumber = 0;
        this.parentScreen = parentScreen;
        this.configValueName = configValueName;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int calc1 = this.field_146294_l / 2 - 183;
        int calc2 = this.field_146294_l / 2 + 3;
        String redTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.redcolorvalue", new Object[0]);
        String greenTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.greencolorvalue", new Object[0]);
        String blueTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.bluecolorvalue", new Object[0]);
        String alphaTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.alphacolorvalue", new Object[0]);
        this.hexText = new GuiTextField(this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(1) + 15, 180, 20);
        this.redText = new SliderControl(110, new Tuple<Integer, Integer>(calc1, CraftPresence.GUIS.getButtonY(3)), new Tuple<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, redTitle);
        this.greenText = new SliderControl(120, new Tuple<Integer, Integer>(calc2, CraftPresence.GUIS.getButtonY(3)), new Tuple<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, greenTitle);
        this.blueText = new SliderControl(130, new Tuple<Integer, Integer>(calc1, CraftPresence.GUIS.getButtonY(4)), new Tuple<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, blueTitle);
        this.alphaText = new SliderControl(140, new Tuple<Integer, Integer>(calc2, CraftPresence.GUIS.getButtonY(4)), new Tuple<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, alphaTitle);
        this.field_146292_n.add(this.redText);
        this.field_146292_n.add(this.greenText);
        this.field_146292_n.add(this.blueText);
        this.field_146292_n.add(this.alphaText);
        this.mcTextureText = new GuiTextField(this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 3, CraftPresence.GUIS.getButtonY(1) + 15, 180, 20);
        this.mcTextureText.func_146203_f(512);
        this.proceedButton = new ExtendedButtonControl(700, 10, this.field_146295_m - 30, 80, 20, ModUtils.TRANSLATOR.translate("gui.config.buttonMessage.back", new Object[0]), new String[0]);
        this.previousPageButton = new ExtendedButtonControl(800, this.proceedButton.field_146128_h + this.proceedButton.getWidth() + 3, this.field_146295_m - 30, 20, 20, "<", new String[0]);
        this.nextPageButton = new ExtendedButtonControl(900, this.previousPageButton.field_146128_h + this.previousPageButton.getWidth() + 3, this.field_146295_m - 30, 20, 20, ">", new String[0]);
        this.field_146292_n.add(this.previousPageButton);
        this.field_146292_n.add(this.nextPageButton);
        this.field_146292_n.add(this.proceedButton);
        this.initValues();
        this.syncValues();
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        CraftPresence.GUIS.drawBackground(this.field_146294_l, this.field_146295_m);
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.color", this.configValueName.replaceAll("_", " "));
        String previewTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.preview", new Object[0]);
        String noticeTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.refresh", new Object[0]);
        this.func_73731_b(this.field_146297_k.field_71466_p, mainTitle, this.field_146294_l / 2 - StringUtils.getStringWidth(mainTitle) / 2, 10, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, subTitle, this.field_146294_l / 2 - StringUtils.getStringWidth(subTitle) / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, previewTitle, this.field_146294_l - 90, this.field_146295_m - 25, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, noticeTitle, this.field_146294_l / 2 - 90, CraftPresence.GUIS.getButtonY(1) - 5, 0xFFFFFF);
        this.redText.field_146125_m = this.redText.field_146124_l = this.pageNumber == 0;
        this.greenText.field_146125_m = this.greenText.field_146124_l = this.pageNumber == 0;
        this.blueText.field_146125_m = this.blueText.field_146124_l = this.pageNumber == 0;
        this.alphaText.field_146125_m = this.alphaText.field_146124_l = this.pageNumber == 0;
        if (this.pageNumber == 0) {
            String hexCodeTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.hexcode", new Object[0]);
            this.func_73731_b(this.field_146297_k.field_71466_p, hexCodeTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(1) + 20, 0xFFFFFF);
            this.hexText.func_146194_f();
            this.proceedButton.field_146124_l = !StringUtils.isNullOrEmpty(this.hexText.func_146179_b());
            CraftPresence.GUIS.drawGradientRect(300.0f, this.field_146294_l - 45, this.field_146295_m - 45, this.field_146294_l - 1, this.field_146295_m - 2, this.currentConvertedHexValue, this.currentConvertedHexValue);
        }
        if (this.pageNumber == 1) {
            String mcTextureTitle = ModUtils.TRANSLATOR.translate("gui.config.editorMessage.texturepath", new Object[0]);
            this.func_73731_b(this.field_146297_k.field_71466_p, mcTextureTitle, this.field_146294_l / 2 - 130, CraftPresence.GUIS.getButtonY(1) + 20, 0xFFFFFF);
            this.mcTextureText.func_146194_f();
            boolean bl = this.proceedButton.field_146124_l = !StringUtils.isNullOrEmpty(this.mcTextureText.func_146179_b());
            if (this.currentMCTexture == null) {
                this.currentMCTexture = new ResourceLocation("");
            }
            CraftPresence.GUIS.drawTextureRect(0.0, this.field_146294_l - 45, this.field_146295_m - 45, 44.0, 43.0, 0.0, this.currentMCTexture);
        }
        this.previousPageButton.field_146124_l = this.pageNumber != 0;
        this.nextPageButton.field_146124_l = this.pageNumber != 1;
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.previousPageButton.field_146127_k && this.pageNumber != 0) {
            --this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (button.field_146127_k == this.nextPageButton.field_146127_k && this.pageNumber != 1) {
            ++this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (button.field_146127_k == this.proceedButton.field_146127_k) {
            this.syncValues();
            if (!StringUtils.isNullOrEmpty(this.configValueName)) {
                if (this.pageNumber == 0) {
                    if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBGColor) && !this.currentNormalHexValue.equals(CraftPresence.CONFIG.tooltipBGColor)) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBGColor = this.currentNormalHexValue;
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBorderColor) && !this.currentNormalHexValue.equals(CraftPresence.CONFIG.tooltipBorderColor)) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBorderColor = this.currentNormalHexValue;
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_guiBGColor) && !this.currentNormalHexValue.equals(CraftPresence.CONFIG.guiBGColor)) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.guiBGColor = this.currentNormalHexValue;
                    }
                }
                if (this.pageNumber == 1) {
                    if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBGColor) && !this.currentNormalMCTexturePath.equals(CraftPresence.CONFIG.tooltipBGColor.replace(CraftPresence.CONFIG.splitCharacter, ":"))) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBGColor = this.currentNormalMCTexturePath.replace(":", CraftPresence.CONFIG.splitCharacter);
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBorderColor) && !this.currentNormalMCTexturePath.equals(CraftPresence.CONFIG.tooltipBorderColor.replace(CraftPresence.CONFIG.splitCharacter, ":"))) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.tooltipBorderColor = this.currentNormalMCTexturePath.replace(":", CraftPresence.CONFIG.splitCharacter);
                    } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_guiBGColor) && !this.currentNormalMCTexturePath.equals(CraftPresence.CONFIG.guiBGColor.replace(CraftPresence.CONFIG.splitCharacter, ":"))) {
                        CraftPresence.CONFIG.hasChanged = true;
                        CraftPresence.CONFIG.guiBGColor = this.currentNormalMCTexturePath.replace(":", CraftPresence.CONFIG.splitCharacter);
                    }
                }
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }
        if (keyCode == 200 && this.pageNumber != 0) {
            --this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (keyCode == 208 && this.pageNumber != 1) {
            ++this.pageNumber;
            this.initValues();
            this.syncValues();
        }
        if (this.pageNumber == 0) {
            this.hexText.func_146201_a(typedChar, keyCode);
        }
        if (this.pageNumber == 1) {
            this.mcTextureText.func_146201_a(typedChar, keyCode);
        }
        if (keyCode == 156 || keyCode == 28) {
            this.syncValues();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.pageNumber == 0) {
            this.hexText.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.pageNumber == 1) {
            this.mcTextureText.func_146192_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        if (this.pageNumber == 0) {
            this.hexText.func_146178_a();
        }
        if (this.pageNumber == 1) {
            this.mcTextureText.func_146178_a();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void initValues() {
        if (!StringUtils.isNullOrEmpty(this.configValueName)) {
            if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBGColor)) {
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.tooltipBGColor)) {
                    this.startingHexValue = CraftPresence.CONFIG.tooltipBGColor;
                } else if (!StringUtils.isNullOrEmpty(CraftPresence.CONFIG.tooltipBGColor)) {
                    this.startingMCTexturePath = CraftPresence.CONFIG.tooltipBGColor;
                }
            } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_tooltipBorderColor)) {
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.tooltipBorderColor)) {
                    this.startingHexValue = CraftPresence.CONFIG.tooltipBorderColor;
                } else if (!StringUtils.isNullOrEmpty(CraftPresence.CONFIG.tooltipBGColor)) {
                    this.startingMCTexturePath = CraftPresence.CONFIG.tooltipBorderColor;
                }
            } else if (this.configValueName.equals(CraftPresence.CONFIG.NAME_guiBGColor)) {
                if (StringUtils.isValidColorCode(CraftPresence.CONFIG.guiBGColor)) {
                    this.startingHexValue = CraftPresence.CONFIG.guiBGColor;
                } else if (!StringUtils.isNullOrEmpty(CraftPresence.CONFIG.guiBGColor)) {
                    this.startingMCTexturePath = CraftPresence.CONFIG.guiBGColor;
                }
            }
            if (StringUtils.isNullOrEmpty(this.hexText.func_146179_b()) && !StringUtils.isNullOrEmpty(this.startingHexValue)) {
                this.hexText.func_146180_a(this.startingHexValue);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedMCTexturePath = null;
                this.currentMCTexture = new ResourceLocation("");
                this.pageNumber = 0;
            } else if (StringUtils.isNullOrEmpty(this.mcTextureText.func_146179_b()) && !StringUtils.isNullOrEmpty(this.startingMCTexturePath)) {
                this.mcTextureText.func_146180_a(this.startingMCTexturePath);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedMCTexturePath = null;
                this.currentMCTexture = new ResourceLocation("");
                this.pageNumber = 1;
            }
        }
    }

    private void syncValues() {
        if (this.pageNumber == 0) {
            Color localColor;
            Integer localValue = null;
            if (!StringUtils.isNullOrEmpty(this.hexText.func_146179_b())) {
                if (this.hexText.func_146179_b().startsWith("#") || this.hexText.func_146179_b().length() == 6) {
                    localValue = StringUtils.getColorFromHex(this.hexText.func_146179_b()).getRGB();
                } else if (this.hexText.func_146179_b().startsWith("0x")) {
                    localColor = new Color(Long.decode(this.hexText.func_146179_b()).intValue(), true);
                    localValue = localColor.getRGB();
                } else if (StringUtils.getValidInteger(this.hexText.func_146179_b()).getFirst().booleanValue()) {
                    localValue = Integer.decode(this.hexText.func_146179_b());
                }
            }
            if (localValue != null && !Integer.toString(localValue).equals(this.currentConvertedHexValue)) {
                this.currentAlpha = localValue >> 24 & 0xFF;
                this.currentRed = localValue >> 16 & 0xFF;
                this.currentGreen = localValue >> 8 & 0xFF;
                this.currentBlue = localValue & 0xFF;
                this.alphaText.setSliderValue(this.currentAlpha);
                this.redText.setSliderValue(this.currentRed);
                this.greenText.setSliderValue(this.currentGreen);
                this.blueText.setSliderValue(this.currentBlue);
                this.currentNormalHexValue = this.hexText.func_146179_b();
                this.currentConvertedHexValue = Integer.toString(localValue);
            } else {
                boolean isAlphaDifferent;
                boolean isRedDifferent = this.alphaText.getSliderValue(false) != (float)this.currentRed;
                boolean isGreenDifferent = this.greenText.getSliderValue(false) != (float)this.currentGreen;
                boolean isBlueDifferent = this.blueText.getSliderValue(false) != (float)this.currentBlue;
                boolean bl = isAlphaDifferent = this.alphaText.getSliderValue(false) != (float)this.currentAlpha;
                if (isRedDifferent || isGreenDifferent || isBlueDifferent || isAlphaDifferent) {
                    this.currentRed = (int)this.redText.getSliderValue(false) & 0xFF;
                    this.currentGreen = (int)this.greenText.getSliderValue(false) & 0xFF;
                    this.currentBlue = (int)this.blueText.getSliderValue(false) & 0xFF;
                    this.currentAlpha = (int)this.alphaText.getSliderValue(false) & 0xFF;
                    localColor = new Color(this.currentRed, this.currentGreen, this.currentBlue, this.currentAlpha);
                    this.currentNormalHexValue = StringUtils.getHexFromColor(localColor);
                    this.hexText.func_146180_a(this.currentNormalHexValue);
                    this.currentConvertedHexValue = Long.toString(Long.decode(this.currentNormalHexValue).intValue());
                }
            }
        }
        if (this.pageNumber == 1) {
            if (!StringUtils.isNullOrEmpty(this.mcTextureText.func_146179_b())) {
                if (this.mcTextureText.func_146179_b().contains(CraftPresence.CONFIG.splitCharacter)) {
                    this.mcTextureText.func_146180_a(this.mcTextureText.func_146179_b().replace(CraftPresence.CONFIG.splitCharacter, ":"));
                }
                this.currentNormalMCTexturePath = this.mcTextureText.func_146179_b().contains(":") && !this.mcTextureText.func_146179_b().startsWith(":") ? this.mcTextureText.func_146179_b() : (this.mcTextureText.func_146179_b().startsWith(":") ? this.mcTextureText.func_146179_b().substring(1) : "minecraft:" + this.mcTextureText.func_146179_b());
                this.currentConvertedMCTexturePath = this.currentNormalMCTexturePath;
                if (this.currentConvertedMCTexturePath.contains(":")) {
                    String[] splitInput = this.currentConvertedMCTexturePath.split(":", 2);
                    this.currentMCTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                } else {
                    this.currentMCTexture = new ResourceLocation(this.currentConvertedMCTexturePath);
                }
            } else {
                this.currentMCTexture = new ResourceLocation("");
            }
        }
    }
}

