/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModLogger;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.TranslationUtils;
import com.gitlab.cdagaming.craftpresence.utils.updater.ModUpdaterUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.realms.RealmsSharedConstants;

public class ModUtils {
    public static final String NAME = "CraftPresence";
    public static final String majorVersion = "1";
    public static final String minorVersion = "6";
    public static final String revisionVersion = "1";
    public static final String VERSION_ID = "v1.6.1";
    public static final String MODID = "craftpresence";
    public static final String GUI_FACTORY = "com.gitlab.cdagaming.craftpresence.config.ConfigGuiDataFactory";
    public static final String MCVersion = RealmsSharedConstants.VERSION_STRING;
    public static final String BRAND = ClientBrandRetriever.getClientModName();
    public static final String configDir = CraftPresence.SYSTEM.USER_DIR + File.separator + "config";
    public static final String modsDir = CraftPresence.SYSTEM.USER_DIR + File.separator + "mods";
    public static final String USERNAME = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    public static final String UPDATE_JSON = "https://gitlab.com/CDAGaming/VersionLibrary/raw/master/CraftPresence/update.json";
    public static final String FINGERPRINT = "eca02c6a597321ad22340897683951ba5c76720a";
    public static final ModLogger LOG = new ModLogger("craftpresence");
    public static final ClassLoader CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    public static final TranslationUtils TRANSLATOR = new TranslationUtils("craftpresence", false);
    public static final ModUpdaterUtils UPDATER = new ModUpdaterUtils("craftpresence", "https://gitlab.com/CDAGaming/VersionLibrary/raw/master/CraftPresence/update.json", "v1.6.1");
    public static final boolean IS_LEGACY = false;
    public static boolean forceBlockTooltipRendering = false;
    public static boolean IS_DEV = Launch.blackboard != null && !Launch.blackboard.isEmpty() && Launch.blackboard.containsKey("fml.deobfuscatedEnvironment") && (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCharData(boolean Update, String encoding) {
        LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.chardata.init", new Object[0]), new Object[0]);
        String fileName = "chardata.properties";
        String charDataPath = "/assets/craftpresence/chardata.properties";
        File charDataDir = new File(MODID + File.separator + "chardata.properties");
        boolean UpdateStatus = Update || !charDataDir.exists();
        boolean errored = false;
        InputStream inputData = null;
        InputStreamReader inputStream = null;
        OutputStream outputData = null;
        BufferedReader reader = null;
        if (UpdateStatus) {
            if (!charDataDir.getParentFile().exists() && !charDataDir.getParentFile().mkdirs()) {
                errored = true;
            }
            LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.download.init", "chardata.properties", charDataDir.getAbsolutePath(), "/assets/craftpresence/chardata.properties"), new Object[0]);
            inputData = StringUtils.getResourceAsStream(ModUtils.class, "/assets/craftpresence/chardata.properties");
            if (inputData != null) {
                try {
                    outputData = new FileOutputStream(charDataDir);
                    byte[] transferBuffer = new byte[inputData.available()];
                    int readBuffer = inputData.read(transferBuffer);
                    while (readBuffer != -1) {
                        outputData.write(transferBuffer, 0, readBuffer);
                        readBuffer = inputData.read(transferBuffer);
                    }
                    LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.download.loaded", "chardata.properties", charDataDir.getAbsolutePath(), "/assets/craftpresence/chardata.properties"), new Object[0]);
                }
                catch (Exception ex) {
                    errored = true;
                }
            } else {
                errored = true;
            }
        }
        if (!errored) {
            try {
                String currentString;
                inputData = new FileInputStream(charDataDir);
                inputStream = new InputStreamReader(inputData, Charset.forName(encoding));
                reader = new BufferedReader(inputStream);
                while ((currentString = reader.readLine()) != null) {
                    int i;
                    String[] localWidths;
                    if ((currentString = currentString.trim()).startsWith("=") || !currentString.contains("=")) continue;
                    String[] splitString = currentString.split("=", 2);
                    if (splitString[0].equalsIgnoreCase("charWidth")) {
                        localWidths = splitString[1].replaceAll("\\[", "").replaceAll("]", "").split(", ");
                        for (i = 0; i < localWidths.length && i <= 256; ++i) {
                            StringUtils.MC_CHAR_WIDTH[i] = Integer.parseInt(localWidths[i].trim());
                        }
                        continue;
                    }
                    if (!splitString[0].equalsIgnoreCase("glyphWidth")) continue;
                    localWidths = splitString[1].replaceAll("\\[", "").replaceAll("]", "").split(", ");
                    for (i = 0; i < localWidths.length && i <= 65536; ++i) {
                        StringUtils.MC_GLYPH_WIDTH[i] = Byte.parseByte(localWidths[i].trim());
                    }
                }
                if (Arrays.equals(StringUtils.MC_CHAR_WIDTH, new int[256]) || Arrays.equals(StringUtils.MC_GLYPH_WIDTH, new byte[65536])) {
                    errored = true;
                }
            }
            catch (Exception ex) {
                ModUtils.loadCharData(true, "UTF-8");
            }
        }
        try {
            if (reader != null) {
                reader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputData != null) {
                inputData.close();
            }
            if (outputData != null) {
                outputData.close();
            }
        }
        catch (Exception ex) {
            LOG.error(TRANSLATOR.translate(true, "craftpresence.logger.error.dataclose", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            if (errored) {
                LOG.error(TRANSLATOR.translate(true, "craftpresence.logger.error.chardata", new Object[0]), new Object[0]);
                forceBlockTooltipRendering = true;
            } else {
                LOG.info(TRANSLATOR.translate(true, "craftpresence.logger.info.chardata.loaded", new Object[0]), new Object[0]);
                forceBlockTooltipRendering = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToCharData(String encoding) {
        ArrayList textData = Lists.newArrayList();
        FileInputStream inputData = null;
        InputStreamReader inputStream = null;
        OutputStream outputData = null;
        OutputStreamWriter outputStream = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File charDataDir = new File(MODID + File.separator + "chardata.properties");
        if (charDataDir.exists()) {
            try {
                String currentString;
                inputData = new FileInputStream(charDataDir);
                inputStream = new InputStreamReader((InputStream)inputData, Charset.forName(encoding));
                br = new BufferedReader(inputStream);
                while (!StringUtils.isNullOrEmpty(currentString = br.readLine())) {
                    if (!currentString.contains("=")) continue;
                    if (currentString.toLowerCase().startsWith("charwidth")) {
                        textData.add("charWidth=" + Arrays.toString(StringUtils.MC_CHAR_WIDTH));
                        continue;
                    }
                    if (!currentString.toLowerCase().startsWith("glyphwidth")) continue;
                    textData.add("glyphWidth=" + Arrays.toString(StringUtils.MC_GLYPH_WIDTH));
                }
                outputData = new FileOutputStream(charDataDir);
                outputStream = new OutputStreamWriter(outputData, Charset.forName(encoding));
                bw = new BufferedWriter(outputStream);
                if (!textData.isEmpty()) {
                    for (String lineInput : textData) {
                        bw.write(lineInput);
                        bw.newLine();
                    }
                }
                ModUtils.loadCharData(true, "UTF-8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (inputData != null) {
                        ((InputStream)inputData).close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (outputData != null) {
                        outputData.close();
                    }
                }
                catch (Exception ex) {
                    LOG.error(TRANSLATOR.translate(true, "craftpresence.logger.error.dataclose", new Object[0]), new Object[0]);
                    ex.printStackTrace();
                }
            }
        } else {
            ModUtils.loadCharData(true, "UTF-8");
        }
    }
}

