/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.ComparableItem;
import cofh.lib.util.helpers.ColorHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.api.crafting.recipes.IPulverizerRecipe;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalfoundation.item.TFItems;
import cofh.thermalfoundation.item.VanillaEquipment;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class PulverizerManager {
    private static Map<ComparableItemStackPulverizer, RecipePulverizer> recipeMap = new THashMap();
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 3200;
    private static int oreMultiplier = 2;

    public static RecipePulverizer getRecipe(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ComparableItemStackPulverizer comparableItemStackPulverizer = new ComparableItemStackPulverizer(itemStack);
        RecipePulverizer recipePulverizer = recipeMap.get((Object)comparableItemStackPulverizer);
        if (recipePulverizer == null) {
            ((ComparableItem)comparableItemStackPulverizer).metadata = Short.MAX_VALUE;
            recipePulverizer = recipeMap.get((Object)comparableItemStackPulverizer);
        }
        return recipePulverizer;
    }

    public static boolean recipeExists(ItemStack itemStack) {
        return PulverizerManager.getRecipe(itemStack) != null;
    }

    public static RecipePulverizer[] getRecipeList() {
        return recipeMap.values().toArray(new RecipePulverizer[0]);
    }

    public static void addDefaultRecipes() {
        int n;
        String string = "RecipeManagers.Pulverizer.Recipes";
        boolean bl = ThermalExpansion.config.get(string, "Sandstone", true);
        boolean bl2 = ThermalExpansion.config.get(string, "Netherrack", true);
        boolean bl3 = ThermalExpansion.config.get(string, "Wool", true);
        boolean bl4 = ThermalExpansion.config.get(string, "Reed", true);
        boolean bl5 = ThermalExpansion.config.get(string, "Bone", true);
        boolean bl6 = ThermalExpansion.config.get(string, "BlazeRod", true);
        boolean bl7 = ThermalExpansion.config.get(string, "BlizzRod", true);
        boolean bl8 = ThermalExpansion.config.get(string, "BlitzRod", true);
        boolean bl9 = ThermalExpansion.config.get(string, "BasalzRod", true);
        boolean bl10 = ThermalExpansion.config.get(string, "HorseArmor", true);
        boolean bl11 = ThermalExpansion.config.get(string, "RedstoneLamp", true);
        boolean bl12 = ThermalExpansion.config.get(string, "GlassBottle", true);
        PulverizerManager.addRecipe(3200, new ItemStack(Blocks.field_150359_w), new ItemStack((Block)Blocks.field_150354_m));
        for (n = 0; n < 16; ++n) {
            PulverizerManager.addRecipe(3200, new ItemStack((Block)Blocks.field_150399_cn, 1, n), new ItemStack((Block)Blocks.field_150354_m));
        }
        if (bl11) {
            PulverizerManager.addRecipe(3200, new ItemStack(Blocks.field_150379_bu), new ItemStack(Items.field_151114_aO, 4), new ItemStack(Items.field_151137_ax, 4));
        }
        PulverizerManager.addRecipe(1800, new ItemStack(Blocks.field_150336_V), new ItemStack(Items.field_151118_aC, 4));
        PulverizerManager.addRecipe(1800, new ItemStack(Blocks.field_150385_bj), new ItemStack(Items.field_151130_bT, 4));
        for (n = 0; n < 3; ++n) {
            PulverizerManager.addRecipe(1800, new ItemStack(Blocks.field_150371_ca, 1, n), new ItemStack(Items.field_151128_bU, 4));
        }
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150389_bf), new ItemStack(Items.field_151118_aC, 6));
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150387_bl), new ItemStack(Items.field_151130_bT, 6));
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150370_cb), new ItemStack(Items.field_151128_bU, 6));
        PulverizerManager.addRecipe(1200, new ItemStack((Block)Blocks.field_150333_U, 1, 4), new ItemStack(Items.field_151118_aC, 2));
        PulverizerManager.addRecipe(1200, new ItemStack((Block)Blocks.field_150333_U, 1, 6), new ItemStack(Items.field_151130_bT, 2));
        PulverizerManager.addRecipe(1200, new ItemStack((Block)Blocks.field_150333_U, 1, 7), new ItemStack(Items.field_151128_bU, 2));
        if (bl) {
            for (n = 0; n < 3; ++n) {
                PulverizerManager.addTERecipe(3200, new ItemStack(Blocks.field_150322_A, 1, n), new ItemStack((Block)Blocks.field_150354_m, 2), TFItems.dustNiter, 50);
            }
            PulverizerManager.addRecipe(4800, new ItemStack(Blocks.field_150372_bz), new ItemStack((Block)Blocks.field_150354_m, 2), TFItems.dustNiter, 75);
            PulverizerManager.addRecipe(2400, new ItemStack((Block)Blocks.field_150333_U, 1, 1), new ItemStack((Block)Blocks.field_150354_m, 1), TFItems.dustNiter, 25);
        }
        PulverizerManager.addRecipe(800, new ItemStack(Items.field_151162_bE), new ItemStack(Items.field_151118_aC, 3));
        if (bl12) {
            PulverizerManager.addRecipe(800, new ItemStack(Items.field_151069_bo), new ItemStack((Block)Blocks.field_150354_m, 1));
        }
        if (bl10) {
            PulverizerManager.addRecipe(4800, new ItemStack(Items.field_151138_bX), ItemHelper.cloneStack((ItemStack)TFItems.dustIron, (int)5));
            PulverizerManager.addRecipe(4800, new ItemStack(Items.field_151136_bY), ItemHelper.cloneStack((ItemStack)TFItems.dustGold, (int)5));
            PulverizerManager.addRecipe(4800, new ItemStack(Items.field_151125_bZ), new ItemStack(Items.field_151045_i, 5, 0));
        }
        PulverizerManager.addRecipe(1500, new ItemStack(Items.field_151048_u), new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(2400, new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151045_i, 3));
        PulverizerManager.addRecipe(2400, new ItemStack(Items.field_151056_x), new ItemStack(Items.field_151045_i, 3));
        PulverizerManager.addRecipe(1200, new ItemStack(Items.field_151047_v), new ItemStack(Items.field_151045_i, 1));
        PulverizerManager.addRecipe(1800, new ItemStack(Items.field_151012_L), new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(3000, new ItemStack((Item)Items.field_151161_ac), new ItemStack(Items.field_151045_i, 5));
        PulverizerManager.addRecipe(4800, new ItemStack((Item)Items.field_151163_ad), new ItemStack(Items.field_151045_i, 8));
        PulverizerManager.addRecipe(4200, new ItemStack((Item)Items.field_151173_ae), new ItemStack(Items.field_151045_i, 7));
        PulverizerManager.addRecipe(2400, new ItemStack((Item)Items.field_151175_af), new ItemStack(Items.field_151045_i, 4));
        PulverizerManager.addRecipe(2400, VanillaEquipment.Diamond.toolBow, new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(2100, VanillaEquipment.Diamond.toolFishingRod, new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(1200, VanillaEquipment.Diamond.toolShears, new ItemStack(Items.field_151045_i, 2));
        PulverizerManager.addRecipe(2100, VanillaEquipment.Diamond.toolSickle, new ItemStack(Items.field_151045_i, 3));
        PulverizerManager.addRecipe(3200, new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m), 15);
        PulverizerManager.addRecipe(3200, new ItemStack(Blocks.field_150347_e), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n), 15);
        PulverizerManager.addRecipe(3200, new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak), new ItemStack((Block)Blocks.field_150354_m), 15);
        PulverizerManager.addRecipe(800, new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 2));
        PulverizerManager.addRecipe(2400, new ItemStack(Items.field_151044_h, 1, 0), TFItems.dustCoal, TFItems.dustSulfur, 15);
        PulverizerManager.addRecipe(2400, new ItemStack(Items.field_151044_h, 1, 1), TFItems.dustCharcoal);
        PulverizerManager.addRecipe(4000, new ItemStack(Blocks.field_150343_Z), ItemHelper.cloneStack((ItemStack)TFItems.dustObsidian, (int)4));
        if (bl2) {
            PulverizerManager.addTERecipe(3200, new ItemStack(Blocks.field_150424_aL), new ItemStack(Blocks.field_150351_n), TFItems.dustSulfur, 15);
        }
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h, 3, 0), TFItems.dustCoal, 25);
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150482_ag), new ItemStack(Items.field_151045_i, 2, 0));
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150412_bA), new ItemStack(Items.field_151166_bC, 2, 0));
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO, 4));
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 12, 4), TFItems.dustSulfur, 20);
        PulverizerManager.addTERecipe(3200, new ItemStack(Blocks.field_150450_ax), new ItemStack(Items.field_151137_ax, 6), TFItems.crystalCinnabar, 25);
        PulverizerManager.addRecipe(2400, new ItemStack(Blocks.field_150449_bY), new ItemStack(Items.field_151128_bU, 3), TFItems.dustSulfur, 15);
        PulverizerManager.addRecipe(1600, new ItemStack(Blocks.field_150364_r), ItemHelper.cloneStack((ItemStack)TEItems.sawdust, (int)8));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150327_N), new ItemStack(Items.field_151100_aR, 4, 11));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 0), new ItemStack(Items.field_151100_aR, 4, 1));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 1), new ItemStack(Items.field_151100_aR, 4, 12));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 2), new ItemStack(Items.field_151100_aR, 4, 13));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 3), new ItemStack(Items.field_151100_aR, 4, 7));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 4), new ItemStack(Items.field_151100_aR, 4, 1));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 5), new ItemStack(Items.field_151100_aR, 4, 14));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 6), new ItemStack(Items.field_151100_aR, 4, 7));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 7), new ItemStack(Items.field_151100_aR, 4, 9));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150328_O, 1, 8), new ItemStack(Items.field_151100_aR, 4, 7));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150398_cm, 1, 0), new ItemStack(Items.field_151100_aR, 8, 11));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150398_cm, 1, 1), new ItemStack(Items.field_151100_aR, 8, 13));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150398_cm, 1, 4), new ItemStack(Items.field_151100_aR, 8, 1));
        PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150398_cm, 1, 5), new ItemStack(Items.field_151100_aR, 8, 9));
        if (bl3) {
            int n2;
            string = "RecipeManagers.Pulverizer.Wool";
            int[] nArray = new int[ColorHelper.woolColorConfig.length];
            String string2 = "This sets the default rate for Wool->String conversion. This number is used in all automatically generated recipes.";
            int n3 = ThermalExpansion.config.get(string, "String", 4, string2);
            ItemStack itemStack = new ItemStack(Items.field_151007_F, n3);
            for (n2 = 0; n2 < ColorHelper.woolColorConfig.length; ++n2) {
                nArray[n2] = 5;
            }
            nArray[0] = 0;
            nArray[12] = 0;
            nArray[13] = 0;
            nArray[15] = 0;
            string = "RecipeManagers.Pulverizer.Wool.Dye";
            for (n2 = 0; n2 < ColorHelper.woolColorConfig.length; ++n2) {
                nArray[n2] = MathHelper.clamp((int)ThermalExpansion.config.get(string, ColorHelper.woolColorConfig[n2], nArray[n2]), (int)0, (int)100);
                if (nArray[n2] > 0) {
                    PulverizerManager.addTERecipe(1600, new ItemStack(Blocks.field_150325_L, 1, n2), itemStack, new ItemStack(Items.field_151100_aR, 1, 15 - n2), nArray[n2]);
                    continue;
                }
                PulverizerManager.addTERecipe(1600, new ItemStack(Blocks.field_150325_L, 1, n2), itemStack);
            }
        }
        if (bl4) {
            PulverizerManager.addTERecipe(800, new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151102_aT, 2));
        }
        if (bl5) {
            PulverizerManager.addTERecipe(1600, new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 6, 15));
        }
        if (bl6) {
            PulverizerManager.addTERecipe(1600, new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 4), TFItems.dustSulfur, 50);
        }
        if (bl7) {
            PulverizerManager.addTERecipe(1600, TFItems.rodBlizz, ItemHelper.cloneStack((ItemStack)TFItems.dustBlizz, (int)4), new ItemStack(Items.field_151126_ay), 50);
        }
        if (bl8) {
            PulverizerManager.addTERecipe(1600, TFItems.rodBlitz, ItemHelper.cloneStack((ItemStack)TFItems.dustBlitz, (int)4), TFItems.dustNiter, 50);
        }
        if (bl9) {
            PulverizerManager.addTERecipe(1600, TFItems.rodBasalz, ItemHelper.cloneStack((ItemStack)TFItems.dustBasalz, (int)4), TFItems.dustObsidian, 50);
        }
        int n4 = 4000;
        PulverizerManager.addOreNameToDustRecipe(n4, "oreIron", TFItems.dustIron, TFItems.dustNickel, 10);
        PulverizerManager.addOreNameToDustRecipe(n4, "oreGold", TFItems.dustGold, TFItems.crystalCinnabar, 5);
        PulverizerManager.addOreNameToDustRecipe(n4, "oreCopper", TFItems.dustCopper, TFItems.dustGold, 10);
        PulverizerManager.addOreNameToDustRecipe(n4, "oreTin", TFItems.dustTin, TFItems.dustIron, 10);
        PulverizerManager.addOreNameToDustRecipe(n4, "oreSilver", TFItems.dustSilver, TFItems.dustLead, 10);
        PulverizerManager.addOreNameToDustRecipe(n4, "oreLead", TFItems.dustLead, TFItems.dustSilver, 10);
        PulverizerManager.addOreNameToDustRecipe(n4, "oreNickel", TFItems.dustNickel, TFItems.dustPlatinum, 10);
        PulverizerManager.addOreNameToDustRecipe(n4, "orePlatinum", TFItems.dustPlatinum, null, 0);
        n4 = 2400;
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotIron", TFItems.dustIron);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotGold", TFItems.dustGold);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotCopper", TFItems.dustCopper);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotTin", TFItems.dustTin);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotSilver", TFItems.dustSilver);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotLead", TFItems.dustLead);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotNickel", TFItems.dustNickel);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotPlatinum", TFItems.dustPlatinum);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotElectrum", TFItems.dustElectrum);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotInvar", TFItems.dustInvar);
        PulverizerManager.addIngotNameToDustRecipe(n4, "ingotBronze", TFItems.dustBronze);
    }

    public static void loadRecipes() {
        String string = "RecipeManagers.Pulverizer.Recipes";
        boolean bl = ThermalExpansion.config.get(string, "Silicon", true);
        boolean bl2 = ThermalExpansion.config.get(string, "Diamond", true);
        boolean bl3 = ThermalExpansion.config.get(string, "EnderPearl", true);
        if (ItemHelper.oreNameExists((String)"itemSilicon") && bl) {
            PulverizerManager.addRecipe(1600, new ItemStack((Block)Blocks.field_150354_m, 1), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"itemSilicon").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"dustDiamond") && bl2) {
            PulverizerManager.addRecipe(3200, new ItemStack(Items.field_151045_i, 1), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustDiamond").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"dustEnderPearl") && bl3) {
            PulverizerManager.addRecipe(1600, new ItemStack(Items.field_151079_bi), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustEnderPearl").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"oreSaltpeter")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreSaltpeter").get(0), ItemHelper.cloneStack((ItemStack)TFItems.dustNiter, (int)4));
        }
        if (ItemHelper.oreNameExists((String)"oreSulfur")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreSulfur").get(0), ItemHelper.cloneStack((ItemStack)TFItems.dustSulfur, (int)6));
        }
        if (ItemHelper.oreNameExists((String)"oreApatite") && ItemHelper.oreNameExists((String)"gemApatite")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreApatite").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"gemApatite").get(0)), (int)12), TFItems.dustSulfur, 10);
        }
        if (ItemHelper.oreNameExists((String)"oreAmethyst") && ItemHelper.oreNameExists((String)"gemAmethyst")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreAmethyst").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"gemAmethyst").get(0)), (int)2));
        }
        if (ItemHelper.oreNameExists((String)"gemAmethyst") && ItemHelper.oreNameExists((String)"dustAmethyst")) {
            PulverizerManager.addRecipe(3200, (ItemStack)OreDictionary.getOres((String)"gemAmethyst").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustAmethyst").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"orePeridot") && ItemHelper.oreNameExists((String)"gemPeridot")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"orePeridot").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"gemPeridot").get(0)), (int)2));
        }
        if (ItemHelper.oreNameExists((String)"gemPeridot") && ItemHelper.oreNameExists((String)"dustPeridot")) {
            PulverizerManager.addRecipe(3200, (ItemStack)OreDictionary.getOres((String)"gemPeridot").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustPeridot").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"oreRuby") && ItemHelper.oreNameExists((String)"gemRuby")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreRuby").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"gemRuby").get(0)), (int)2));
        }
        if (ItemHelper.oreNameExists((String)"gemRuby") && ItemHelper.oreNameExists((String)"dustRuby")) {
            PulverizerManager.addRecipe(3200, (ItemStack)OreDictionary.getOres((String)"gemRuby").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustRuby").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"oreSapphire") && ItemHelper.oreNameExists((String)"gemSapphire")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreSapphire").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"gemSapphire").get(0)), (int)2));
        }
        if (ItemHelper.oreNameExists((String)"gemSapphire") && ItemHelper.oreNameExists((String)"dustSapphire")) {
            PulverizerManager.addRecipe(3200, (ItemStack)OreDictionary.getOres((String)"gemSapphire").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustSapphire").get(0)), (int)1));
        }
        if (ItemHelper.oreNameExists((String)"oreCertusQuartz") && ItemHelper.oreNameExists((String)"dustCertusQuartz") && ItemHelper.oreNameExists((String)"crystalCertusQuartz")) {
            PulverizerManager.addRecipe(2400, (ItemStack)OreDictionary.getOres((String)"oreCertusQuartz").get(0), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0)), (int)2), (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0), 10);
            PulverizerManager.addRecipe(1600, (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0), (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0));
        }
        if (ItemHelper.oreNameExists((String)"dustFluix") && ItemHelper.oreNameExists((String)"crystalFluix")) {
            PulverizerManager.addRecipe(1600, (ItemStack)OreDictionary.getOres((String)"crystalFluix").get(0), (ItemStack)OreDictionary.getOres((String)"dustFluix").get(0));
        }
        if (ItemHelper.oreNameExists((String)"dustNetherQuartz")) {
            PulverizerManager.addRecipe(1600, new ItemStack(Items.field_151128_bU, 1), ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"dustNetherQuartz").get(0)), (int)1));
        }
        String[] stringArray = OreDictionary.getOreNames();
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("ore")) {
                string2 = stringArray[i].substring(3, stringArray[i].length());
                PulverizerManager.addDefaultOreDictionaryRecipe(string2);
                continue;
            }
            if (!stringArray[i].startsWith("dust")) continue;
            string2 = stringArray[i].substring(4, stringArray[i].length());
            PulverizerManager.addDefaultOreDictionaryRecipe(string2);
        }
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackPulverizer, RecipePulverizer> entry : recipeMap.entrySet()) {
            RecipePulverizer recipePulverizer = entry.getValue();
            tHashMap.put(new ComparableItemStackPulverizer(recipePulverizer.input), recipePulverizer);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
    }

    protected static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipePulverizer recipePulverizer = new RecipePulverizer(itemStack, itemStack2, itemStack3, n2, n);
        recipeMap.put(new ComparableItemStackPulverizer(itemStack), recipePulverizer);
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && PulverizerManager.recipeExists(itemStack)) {
            return false;
        }
        RecipePulverizer recipePulverizer = new RecipePulverizer(itemStack, itemStack2, itemStack3, n2, n);
        recipeMap.put(new ComparableItemStackPulverizer(itemStack), recipePulverizer);
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack) {
        return recipeMap.remove((Object)new ComparableItemStackPulverizer(itemStack)) != null;
    }

    public static void addDefaultOreDictionaryRecipe(String string) {
        PulverizerManager.addDefaultOreDictionaryRecipe(string, "");
    }

    public static void addDefaultOreDictionaryRecipe(String string, String string2) {
        if (string.length() <= 0) {
            return;
        }
        String string3 = "ore" + StringHelper.titleCase((String)string);
        String string4 = "dust" + StringHelper.titleCase((String)string);
        String string5 = "ingot" + StringHelper.titleCase((String)string);
        String string6 = null;
        ArrayList arrayList = OreDictionary.getOres((String)string3);
        ArrayList arrayList2 = OreDictionary.getOres((String)string4);
        ArrayList arrayList3 = OreDictionary.getOres((String)string5);
        ArrayList arrayList4 = new ArrayList();
        String string7 = "cluster" + StringHelper.titleCase((String)string);
        ArrayList arrayList5 = OreDictionary.getOres((String)string7);
        if (string2 != "") {
            string6 = "dust" + StringHelper.titleCase((String)string2);
            arrayList4 = OreDictionary.getOres((String)string6);
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        ItemStack itemStack = GameRegistry.findItemStack((String)"ThermalFoundation", (String)string4, (int)1);
        if (itemStack != null && !OreDictionaryArbiter.getAllOreNames((ItemStack)itemStack).contains(string4)) {
            itemStack = null;
        }
        if (itemStack == null) {
            itemStack = (ItemStack)arrayList2.get(0);
        }
        if (arrayList3.isEmpty()) {
            string5 = null;
        }
        if (arrayList.isEmpty()) {
            string3 = null;
        }
        if (arrayList5.isEmpty()) {
            string7 = null;
        }
        ItemStack itemStack2 = null;
        if (string6 != null && (itemStack2 = GameRegistry.findItemStack((String)"ThermalFoundation", (String)string6, (int)1)) != null && !OreDictionaryArbiter.getAllOreNames((ItemStack)itemStack2).contains(string6)) {
            itemStack2 = null;
        }
        if (itemStack2 == null && !arrayList4.isEmpty()) {
            itemStack2 = (ItemStack)arrayList4.get(0);
        }
        PulverizerManager.addOreNameToDustRecipe(4000, string3, ItemHelper.cloneStack((ItemStack)itemStack, (int)oreMultiplier), itemStack2, 5);
        PulverizerManager.addOreNameToDustRecipe(4800, string7, ItemHelper.cloneStack((ItemStack)itemStack, (int)oreMultiplier), itemStack2, 5);
        PulverizerManager.addIngotNameToDustRecipe(2400, string5, ItemHelper.cloneStack((ItemStack)itemStack, (int)1));
    }

    public static void addOreNameToDustRecipe(int n, String string, ItemStack itemStack, ItemStack itemStack2, int n2) {
        if (itemStack == null || string == null) {
            return;
        }
        ArrayList arrayList = OreDictionary.getOres((String)string);
        if (!arrayList.isEmpty()) {
            PulverizerManager.addRecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)itemStack, (int)oreMultiplier), itemStack2, n2);
        }
    }

    public static void addOreToDustRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2) {
        if (itemStack2 == null) {
            return;
        }
        ItemStack itemStack4 = ItemHelper.cloneStack((ItemStack)itemStack2, (int)oreMultiplier);
        PulverizerManager.addRecipe(n, itemStack, itemStack4, itemStack3, n2);
    }

    public static void addIngotNameToDustRecipe(int n, String string, ItemStack itemStack) {
        if (itemStack == null || string == null) {
            return;
        }
        ArrayList arrayList = OreDictionary.getOres((String)string);
        if (!arrayList.isEmpty()) {
            PulverizerManager.addRecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)1), itemStack, null, 0);
        }
    }

    public static void addIngotNameToDustRecipe(int n, String string) {
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        return PulverizerManager.addTERecipe(n, itemStack, itemStack2, null, 0);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        return PulverizerManager.addRecipe(n, itemStack, itemStack2, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        return PulverizerManager.addRecipe(n, itemStack, itemStack2, null, 0, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return PulverizerManager.addRecipe(n, itemStack, itemStack2, itemStack3, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, boolean bl) {
        return PulverizerManager.addRecipe(n, itemStack, itemStack2, itemStack3, 100, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2) {
        return PulverizerManager.addRecipe(n, itemStack, itemStack2, itemStack3, n2, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Pulverizer", "AllowRecipeOverwrite", false);
        String string = "RecipeManagers.Pulverizer.Ore";
        String string2 = "This sets the default rate for Ore->Dust conversion. This number is used in all automatically generated recipes.";
        oreMultiplier = MathHelper.clamp((int)ThermalExpansion.config.get(string, "DefaultMultiplier", oreMultiplier, string2), (int)1, (int)64);
    }

    public static class ComparableItemStackPulverizer
    extends ComparableItemStack {
        static final String ORE = "ore";
        static final String INGOT = "ingot";
        static final String NUGGET = "nugget";
        static final String LOG = "log";
        static final String SAND = "sand";

        public static boolean safeOreType(String string) {
            return string.startsWith(ORE) || string.startsWith(INGOT) || string.startsWith(NUGGET) || string.startsWith(LOG) || string.equals(SAND);
        }

        public static int getOreID(ItemStack itemStack) {
            ArrayList arrayList = OreDictionaryArbiter.getAllOreIDs((ItemStack)itemStack);
            if (arrayList != null) {
                int n = 0;
                int n2 = arrayList.size();
                while (n < n2) {
                    int n3;
                    if ((n3 = ((Integer)arrayList.get(n++)).intValue()) == -1 || !ComparableItemStackPulverizer.safeOreType(ItemHelper.oreProxy.getOreName(n3))) continue;
                    return n3;
                }
            }
            return -1;
        }

        public static int getOreID(String string) {
            if (!ComparableItemStackPulverizer.safeOreType(string)) {
                return -1;
            }
            return ItemHelper.oreProxy.getOreID(string);
        }

        public ComparableItemStackPulverizer(ItemStack itemStack) {
            super(itemStack);
            this.oreID = ComparableItemStackPulverizer.getOreID(itemStack);
        }

        public ComparableItemStackPulverizer(Item item, int n, int n2) {
            super(item, n, n2);
            this.oreID = ComparableItemStackPulverizer.getOreID(this.toItemStack());
        }

        public ComparableItemStackPulverizer set(ItemStack itemStack) {
            super.set(itemStack);
            this.oreID = ComparableItemStackPulverizer.getOreID(itemStack);
            return this;
        }
    }

    public static class RecipePulverizer
    implements IPulverizerRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipePulverizer(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n, int n2) {
            this.input = itemStack;
            this.primaryOutput = itemStack2;
            this.secondaryOutput = itemStack3;
            this.secondaryChance = n;
            this.energy = n2;
            if (itemStack.field_77994_a <= 0) {
                itemStack.field_77994_a = 1;
            }
            if (itemStack2.field_77994_a <= 0) {
                itemStack2.field_77994_a = 1;
            }
            if (itemStack3 != null && itemStack3.field_77994_a <= 0) {
                itemStack3.field_77994_a = 1;
            }
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        @Override
        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        @Override
        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

