/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.gui;

import com.aesireanempire.eplus.EnchantingPlus;
import com.aesireanempire.eplus.inventory.ContainerEnchantTable;
import com.aesireanempire.eplus.inventory.TileEnchantTable;
import com.aesireanempire.eplus.lib.ConfigurationSettings;
import com.aesireanempire.eplus.lib.EnchantmentHelp;
import com.aesireanempire.eplus.lib.Strings;
import com.aesireanempire.eplus.network.packets.EnchantPacket;
import com.aesireanempire.eplus.network.packets.GuiPacket;
import com.aesireanempire.eplus.network.packets.RepairPacket;
import com.aesireanempire.eplus.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiModTable
extends GuiContainer {
    private static boolean TMInagged = false;
    private static int guiOffset = 26;
    private final EntityPlayer player;
    private final ContainerEnchantTable container;
    private final int xPos;
    private final int yPos;
    private final int zPos;
    private final ResourceLocation texture = new ResourceLocation("eplus", "textures/gui/enchant.png");
    public String error = "";
    private ArrayList<GuiItem> enchantmentArray = new ArrayList();
    private double sliderIndex = 0.0;
    private double enchantingPages = 0.0;
    private Map<Integer, Integer> enchantments;
    private boolean clicked = false;
    private boolean sliding = false;
    private int totalCost = 0;
    private int repairAmount = 0;
    private boolean dirty = false;

    public GuiModTable(InventoryPlayer inventory, World world, int x, int y, int z, TileEnchantTable tileEntity) {
        super((Container)new ContainerEnchantTable(inventory, world, x, y, z, tileEntity));
        this.player = inventory.field_70458_d;
        this.container = (ContainerEnchantTable)this.field_147002_h;
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.field_146999_f = 235;
        this.field_147000_g = 182;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        HashMap<Integer, Integer> enchants = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> levels = new HashMap<Integer, Integer>();
        for (GuiItem item : this.enchantmentArray) {
            Integer id = this.enchantments.get(((GuiItem)item).enchantment.field_77352_x);
            if (item.enchantmentLevel == id || item.disabled) continue;
            enchants.put(((GuiItem)item).enchantment.field_77352_x, item.enchantmentLevel);
            levels.put(((GuiItem)item).enchantment.field_77352_x, item.privateLevel);
        }
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                if (enchants.size() > 0) {
                    EnchantingPlus.sendPacketToServer(new EnchantPacket(enchants, levels, this.totalCost));
                }
                return;
            }
            case 1: {
                if (enchants.size() == 0 && ConfigurationSettings.canRepair) {
                    EnchantingPlus.sendPacketToServer(new RepairPacket(this.totalCost, this.repairAmount));
                }
                return;
            }
            case 2: {
                EnchantingPlus.sendPacketToServer(new GuiPacket(this.player.getDisplayName(), 1, this.xPos, this.yPos, this.zPos));
            }
        }
    }

    private ArrayList<GuiItem> convertMapToGuiItems(Map<Integer, Integer> map, int x, int y) {
        ArrayList<GuiItem> temp = new ArrayList<GuiItem>();
        if (map == null) {
            return temp;
        }
        int i = 0;
        int yPos = y;
        Iterator<Integer> i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            Integer obj;
            Integer enchantmentId = obj = i$.next();
            Integer enchantmentLevel = map.get(obj);
            temp.add(new GuiItem(enchantmentId, enchantmentLevel, x, yPos));
            yPos = y + ++i * 18;
        }
        return temp;
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (GuiItem item : this.enchantmentArray) {
            if (item.yPos < this.field_147009_r + 15 || item.yPos >= this.field_147009_r + 87) {
                item.show(false);
            } else {
                item.show(true);
            }
            item.draw();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        block27: {
            StringBuilder sb;
            super.func_73863_a(par1, par2, par3);
            int adjustedMouseX = par1 - this.field_147003_i;
            int adjustedMouseY = par2 - this.field_147009_r;
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            int tempY = adjustedMouseY - 16;
            if (tempY <= 0) {
                tempY = 0;
            }
            if (tempY >= 57) {
                tempY = 57;
            }
            double d = this.sliderIndex = this.sliding ? Utils.round((double)tempY / 57.0 * this.enchantingPages, 0.25) : this.sliderIndex;
            if (this.sliderIndex >= this.enchantingPages) {
                this.sliderIndex = this.enchantingPages;
            }
            double sliderY = this.sliding ? (double)tempY : 57.0 * (this.sliderIndex / this.enchantingPages);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_147003_i + guiOffset + 180, this.field_147009_r + 16 + (int)sliderY, 0, 182, 12, 15);
            if (!this.clicked && Mouse.isButtonDown((int)0)) {
                for (GuiItem item : this.enchantmentArray) {
                    if (this.getItemFromPos(par1, par2) != item || item.disabled || item.locked) continue;
                    item.dragging = true;
                }
                if (adjustedMouseX <= 191 + guiOffset && adjustedMouseX >= 180 + guiOffset && this.enchantingPages != 0.0) {
                    this.sliding = true;
                }
            }
            for (GuiItem item : this.enchantmentArray) {
                if (!item.dragging || this.getItemFromPos(par1, par2) == item) continue;
                item.dragging = false;
            }
            if (!Mouse.isButtonDown((int)0)) {
                for (GuiItem item : this.enchantmentArray) {
                    if (this.getItemFromPos(par1, par2) != item) continue;
                    item.dragging = false;
                }
                if (adjustedMouseX <= 191 + guiOffset && adjustedMouseX >= 180 + guiOffset) {
                    this.sliding = false;
                }
            }
            this.clicked = Mouse.isButtonDown((int)0);
            for (GuiItem item : this.enchantmentArray) {
                if (!item.dragging) continue;
                item.scroll(adjustedMouseX - 36);
            }
            if (EnchantingPlus.Debug) {
                this.field_146289_q.func_78276_b(String.format("%s: %s", "Error", this.error), 5, 5, -5588054);
            }
            int maxWidth = this.field_147003_i - 20;
            ArrayList<List> information = new ArrayList<List>();
            information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", Strings.playerLevel, this.player.field_71068_ca), maxWidth));
            if (this.container.tableInventory.func_70301_a(0) == null || this.levelChanged() || !this.levelChanged() && !this.container.tableInventory.func_70301_a(0).func_77951_h()) {
                information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", Strings.enchantingCost, this.totalCost), maxWidth));
            } else if (ConfigurationSettings.canRepair && !this.levelChanged() && this.container.tableInventory.func_70301_a(0).func_77951_h()) {
                information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", Strings.repairCost, this.totalCost), maxWidth));
            }
            information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", Strings.maxEnchantLevel, Float.valueOf(this.container.bookCases())), maxWidth));
            for (List display : information) {
                int height;
                int n = height = information.indexOf(display) == 0 ? this.field_147009_r + this.field_146289_q.field_78288_b + 8 : this.field_147009_r + (this.field_146289_q.field_78288_b + 8) * (information.indexOf(display) + 1);
                if (information.indexOf(display) > 0) {
                    for (int i = information.indexOf(display) - 1; i >= 0; --i) {
                        height += (this.field_146289_q.field_78288_b + 3) * (((List)information.get(i)).size() - 1);
                    }
                }
                try {
                    this.drawHoveringText(display, this.field_147003_i - 20 - maxWidth, height, this.field_146289_q);
                }
                catch (NoSuchMethodError e) {
                    sb = new StringBuilder();
                    for (String text : display) {
                        sb.append(text);
                        sb.append(" ");
                    }
                    this.func_146279_a(sb.toString(), this.field_147003_i - 20 - maxWidth, height);
                    if (TMInagged) continue;
                    EnchantingPlus.log.error("Please update or remove NEI / TMI. It is causing issues.");
                    TMInagged = true;
                }
            }
            if (GuiModTable.func_146272_n() && this.getItemFromPos(par1, par2) != null) {
                String name = "\u00a7l" + this.getItemFromPos(par1, par2).getTranslatedName();
                String info = EnchantmentHelp.getToolTip(this.getItemFromPos(par1, par2).enchantment);
                if (info.isEmpty()) {
                    info = "\u00a74" + String.format("%s ", Strings.errorToolTip) + this.getItemFromPos(par1, par2).enchantment.func_77320_a();
                }
                info = "\u00a75" + info;
                ArrayList<String> display = new ArrayList<String>();
                display.add(name);
                display.addAll(this.field_146289_q.func_78271_c(info, 150));
                try {
                    this.drawHoveringText(display, par1, par2, this.field_146289_q);
                }
                catch (NoSuchMethodError e) {
                    sb = new StringBuilder();
                    for (String text : display) {
                        sb.append(text);
                        sb.append(" ");
                    }
                    this.func_146279_a(sb.toString(), this.field_147003_i - 20 - maxWidth, this.field_146295_m);
                    if (TMInagged) break block27;
                    EnchantingPlus.log.error("Please update or remove NEI / TMI. It is causing issues.");
                    TMInagged = true;
                }
            }
        }
        if (!this.error.isEmpty()) {
            this.func_146279_a(this.error, (this.field_146999_f + this.field_147003_i) / 2 - this.field_146289_q.func_78256_a(this.error) / 4, this.field_147009_r - this.field_146289_q.field_78288_b);
        }
    }

    private GuiItem getItemFromPos(int x, int y) {
        if (x < this.field_147003_i + guiOffset + 35 || x > this.field_147003_i + this.field_146999_f - 32) {
            return null;
        }
        for (GuiItem item : this.enchantmentArray) {
            if (!item.show || y < item.yPos || y > item.yPos + item.height) continue;
            return item;
        }
        return null;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int eventDWheel = Mouse.getEventDWheel();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        if (eventDWheel != 0 && (mouseX >= 35 + guiOffset && mouseX <= this.field_146999_f + guiOffset - 32 || mouseX >= 180 + guiOffset && mouseX <= 192 + guiOffset) && mouseY >= 15 && mouseY <= 87) {
            if (eventDWheel < 0) {
                this.sliderIndex += 0.25;
                if (this.sliderIndex >= this.enchantingPages) {
                    this.sliderIndex = this.enchantingPages;
                }
            } else {
                this.sliderIndex -= 0.25;
                if (this.sliderIndex <= 0.0) {
                    this.sliderIndex = 0.0;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiIcon(0, this.field_147003_i + guiOffset + 9, this.field_147009_r + 38, "E").customTexture(0));
        this.field_146292_n.add(new GuiIcon(1, this.field_147003_i + guiOffset + 9, this.field_147009_r + 63, "R").customTexture(0));
        String s = "Vanilla";
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + this.field_146999_f + 10, this.field_147009_r + 5, this.field_146289_q.func_78256_a("Vanilla") + 10, 20, "Vanilla"));
        this.dirty = true;
    }

    protected boolean levelChanged() {
        for (GuiItem item : this.enchantmentArray) {
            if (item.enchantmentLevel == item.privateLevel) continue;
            return true;
        }
        return false;
    }

    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        GuiItem itemFromPos = this.getItemFromPos(x, y);
        if (itemFromPos != null) {
            for (GuiItem item : this.enchantmentArray) {
                if (item != itemFromPos) continue;
                itemFromPos.handleClick(par3);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        Map<Integer, Integer> enchantments = this.updateEnchantments(this.container.getEnchantments());
        this.handleChangedScreenSize(enchantments);
        this.enableEnchantments();
        this.enchantingPages = (double)this.enchantmentArray.size() / 4.0 > 1.0 ? (double)this.enchantmentArray.size() / 4.0 - 1.0 : 0.0;
        this.totalCost = 0;
        this.repairAmount = 0;
        this.handleChangedEnchantments(enchantments);
        this.handleButtonLabels(enchantments);
    }

    private void enableEnchantments() {
        GuiItem item;
        int i;
        boolean[] enabled = new boolean[this.enchantmentArray.size()];
        Arrays.fill(enabled, false);
        for (i = 0; i < this.enchantmentArray.size(); ++i) {
            item = this.enchantmentArray.get(i);
            if (item.enchantmentLevel == 0) continue;
            for (int i1 = 0; i1 < this.enchantmentArray.size(); ++i1) {
                GuiItem item2 = this.enchantmentArray.get(i1);
                if (item == item2) continue;
                enabled[i1] = enabled[i1] || i != i1 && (!item.enchantment.func_77326_a(item2.enchantment) || !item2.enchantment.func_77326_a(item.enchantment));
            }
        }
        for (i = 0; i < this.enchantmentArray.size(); ++i) {
            item = this.enchantmentArray.get(i);
            item.disabled = enabled[i];
        }
    }

    private void handleChangedEnchantments(Map<Integer, Integer> enchantments) {
        block3: {
            block2: {
                if (this.enchantmentArray.isEmpty() || !this.levelChanged()) break block2;
                for (GuiItem item : this.enchantmentArray) {
                    this.handleChangedEnchantment(enchantments, item);
                }
                break block3;
            }
            if (!ConfigurationSettings.canRepair || this.levelChanged()) break block3;
            this.totalCost += this.container.repairCostMax(this.player);
            int itemDamage = this.container.tableInventory.func_70301_a(0) != null ? this.container.tableInventory.func_70301_a(0).func_77960_j() : 0;
            int playerLevel = this.player.field_71068_ca;
            this.repairAmount = itemDamage > playerLevel ? playerLevel : itemDamage;
            for (GuiItem item : this.enchantmentArray) {
                item.yPos = item.startingYPos - (int)(72.0 * this.sliderIndex);
            }
        }
    }

    private void handleChangedEnchantment(Map<Integer, Integer> enchantments, GuiItem item) {
        item.yPos = item.startingYPos - (int)(72.0 * this.sliderIndex);
        Integer level = enchantments.get(((GuiItem)item).enchantment.field_77352_x);
        if (item.enchantmentLevel > level && !item.disabled) {
            int temp;
            block8: {
                temp = this.totalCost + this.container.enchantmentCost(((GuiItem)item).enchantment.field_77352_x, item.enchantmentLevel, level);
                try {
                    if (!this.container.canPurchase(this.player, temp)) break block8;
                    item.locked = false;
                }
                catch (Exception e) {
                    item.locked = true;
                    this.error = e.getMessage();
                    while (item.locked && item.enchantmentLevel > 0) {
                        item.dragging = false;
                        item.enchantmentLevel--;
                        temp = this.totalCost + this.container.enchantmentCost(((GuiItem)item).enchantment.field_77352_x, item.enchantmentLevel, level);
                        try {
                            if (!this.container.canPurchase(this.player, temp)) continue;
                            item.locked = false;
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            this.totalCost = temp;
        } else if (item.enchantmentLevel < level && !item.disabled) {
            this.totalCost = Utils.containsKey(this.container.tableInventory.func_70301_a(0).func_77978_p().func_150295_c("restrictions", 10), ((GuiItem)item).enchantment.field_77352_x, item.enchantmentLevel) || ConfigurationSettings.canDisenUnowned ? (this.totalCost += this.container.disenchantmentCost(((GuiItem)item).enchantment.field_77352_x, item.enchantmentLevel, level)) : 0;
        }
    }

    private void handleButtonLabels(Map<Integer, Integer> enchantments) {
        ((GuiIcon)((Object)this.field_146292_n.get(1))).setDisplayString("R");
    }

    private void handleChangedScreenSize(Map<Integer, Integer> enchantments) {
        if (this.dirty) {
            ArrayList<GuiItem> temp = this.convertMapToGuiItems(enchantments, 35 + guiOffset + this.field_147003_i, 15 + this.field_147009_r);
            for (GuiItem item : this.enchantmentArray) {
                for (GuiItem tempItem : temp) {
                    if (item.enchantment != tempItem.enchantment) continue;
                    item.startingXPos = item.xPos = tempItem.xPos;
                    item.startingYPos = item.yPos = tempItem.yPos;
                }
            }
            this.dirty = false;
        }
    }

    private Map<Integer, Integer> updateEnchantments(Map<Integer, Integer> enchantments) {
        if (this.enchantments != enchantments) {
            this.enchantments = enchantments;
            this.enchantmentArray = this.convertMapToGuiItems(enchantments, 35 + guiOffset + this.field_147003_i, 15 + this.field_147009_r);
            this.enchantingPages = 0.0;
            this.sliderIndex = 0.0;
            this.sliding = false;
            this.clicked = false;
            this.error = "";
            return this.enchantments;
        }
        return enchantments;
    }

    class GuiItem
    extends Gui {
        private final Enchantment enchantment;
        private final int height;
        private final int width;
        private final int privateLevel;
        public int startingXPos;
        public int startingYPos;
        public int yPos;
        public boolean locked = false;
        private int xPos;
        private int enchantmentLevel;
        private boolean show = true;
        private float index;
        private boolean dragging = false;
        private int sliderX;
        private boolean disabled;

        public GuiItem(int id, int level, int x, int y) {
            this.enchantment = Enchantment.field_77331_b[id];
            this.enchantmentLevel = level;
            this.privateLevel = level;
            this.xPos = this.startingXPos = x;
            this.yPos = this.startingYPos = y;
            this.sliderX = this.xPos + 1;
            this.height = 18;
            this.width = 143;
        }

        public void draw() {
            if (!this.show) {
                return;
            }
            int indexX = this.dragging ? this.sliderX : (this.enchantmentLevel <= this.enchantment.func_77325_b() ? (int)((double)(this.xPos + 1) + (double)(this.width - 6) * ((double)this.enchantmentLevel / (double)this.enchantment.func_77325_b())) : this.xPos + 1 + this.width - 6);
            GuiItem.func_73734_a((int)indexX, (int)(this.yPos + 1), (int)(indexX + 5), (int)(this.yPos - 1 + this.height), (int)-16777216);
            GuiModTable.this.field_146289_q.func_78276_b(this.getTranslatedName(), this.xPos + 5, this.yPos + this.height / 4, 1437269760);
            if (this.disabled) {
                GuiItem.func_73734_a((int)this.xPos, (int)(this.yPos + 1), (int)(this.xPos + this.width), (int)(this.yPos - 1 + this.height), (int)0x44AAFFFF);
            } else if (this.locked) {
                GuiItem.func_73734_a((int)this.xPos, (int)(this.yPos + 1), (int)(this.xPos + this.width), (int)(this.yPos - 1 + this.height), (int)0x44FF0000);
            } else {
                GuiItem.func_73734_a((int)this.xPos, (int)(this.yPos + 1), (int)(this.xPos + this.width), (int)(this.yPos - 1 + this.height), (int)1152013823);
            }
        }

        public String getTranslatedName() {
            String name = this.enchantment.func_77316_c(this.enchantmentLevel);
            if (this.enchantmentLevel == 0) {
                name = name.lastIndexOf(" ") == -1 ? this.enchantment.func_77320_a() : name.substring(0, name.lastIndexOf(" "));
            }
            return name;
        }

        public void handleClick(int mouseButton) {
        }

        public void scroll(int xPos) {
            int start = guiOffset + GuiModTable.this.field_147003_i + 10;
            if (this.disabled) {
                return;
            }
            this.sliderX = start + xPos;
            if (this.sliderX <= start) {
                this.sliderX = start;
            }
            if (this.sliderX >= start + this.width + 20) {
                this.sliderX = start + this.width + 20;
            }
            this.index = (float)xPos / (float)(this.width + 10);
            int tempLevel = (int)Math.floor(this.privateLevel > this.enchantment.func_77325_b() ? (double)((float)this.privateLevel * this.index) : (double)((float)this.enchantment.func_77325_b() * this.index));
            if (this.locked) {
                if (tempLevel < this.enchantmentLevel && (!((GuiModTable)GuiModTable.this).container.tableInventory.func_70301_a(0).func_77951_h() || ConfigurationSettings.canEnchantDamaged)) {
                    this.enchantmentLevel = tempLevel;
                    this.locked = false;
                }
            } else if (tempLevel >= this.privateLevel || ConfigurationSettings.canDisenchant && !((GuiModTable)GuiModTable.this).container.tableInventory.func_70301_a(0).func_77951_h() || ConfigurationSettings.canEnchantDamaged) {
                this.enchantmentLevel = tempLevel;
            }
            if (this.enchantmentLevel <= 0) {
                this.enchantmentLevel = 0;
            }
        }

        public void show(boolean b) {
            this.show = b;
        }
    }

    class GuiIcon
    extends GuiButton {
        private boolean customTexture;
        private int textureIndex;

        public GuiIcon(int id, int x, int y, int width, int height, String caption) {
            super(id, x, y, width, height, caption);
        }

        public GuiIcon(int id, int x, int y, String caption) {
            this(id, x, y, 16, 16, caption);
        }

        public GuiIcon customTexture(int texture) {
            this.textureIndex = texture;
            boolean bl = this.customTexture = texture != 0;
            if (!this.customTexture) {
                this.field_146120_f = 20;
                this.field_146121_g = 20;
            }
            return this;
        }

        public void func_146112_a(Minecraft mc, int x, int y) {
            if (!this.customTexture) {
                super.func_146112_a(mc, x, y);
            } else {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(GuiModTable.this.texture);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 8 + this.textureIndex * 16, 182, this.field_146120_f, this.field_146121_g);
            }
        }

        public GuiIcon enabled(boolean enabled) {
            this.field_146124_l = enabled;
            return this;
        }

        public String getDisplayString() {
            return this.field_146126_j;
        }

        public void setDisplayString(String displayString) {
            this.field_146126_j = displayString;
        }
    }
}

