/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.reccomplex.utils.ListPresets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PresettedList<T> {
    public final List<T> list = new ArrayList<T>();
    @Nonnull
    protected ListPresets<T> listPresets;
    @Nullable
    protected String preset;

    public PresettedList(@Nonnull ListPresets<T> listPresets, String preset) {
        this.listPresets = listPresets;
        this.setPreset(preset);
    }

    @Nonnull
    public ListPresets<T> getListPresets() {
        return this.listPresets;
    }

    public void setListPresets(@Nonnull ListPresets<T> listPresets) {
        this.listPresets = listPresets;
    }

    @Nullable
    public String getPreset() {
        return this.preset;
    }

    public boolean setPreset(@Nullable String preset) {
        this.preset = preset;
        return this.loadListFromPreset();
    }

    public void setToCustom() {
        this.preset = null;
    }

    public boolean isCustom() {
        return this.preset == null;
    }

    public void setToDefault() {
        this.setPreset(this.listPresets.defaultType());
    }

    @SafeVarargs
    public final void setContents(T ... ts) {
        this.setToCustom();
        this.list.clear();
        Collections.addAll(this.list, ts);
    }

    public void setContents(List<T> ts) {
        this.setToCustom();
        this.list.clear();
        this.list.addAll(ts);
    }

    public boolean loadListFromPreset() {
        this.list.clear();
        if (this.preset != null) {
            List<T> presetList = this.listPresets.preset(this.preset);
            if (presetList != null) {
                this.list.addAll(presetList);
                return true;
            }
            return false;
        }
        return false;
    }
}

