/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import com.google.common.collect.Maps;
import java.util.Map;

public class FMLRemapper {
    protected String domain;
    protected final Map<String, String> blockRemaps = Maps.newHashMap();
    protected final Map<String, String> itemRemaps = Maps.newHashMap();
    protected final Map<String, String> tileEntityRemaps = Maps.newHashMap();

    public FMLRemapper(String domain) {
        this.domain = domain;
    }

    public void registerLegacyBlockIDs(String blockID, boolean inferItem, String ... oldIDs) {
        for (String oldID : oldIDs) {
            String fullID = String.format("%s:%s", this.domain, oldID);
            this.blockRemaps.put(fullID, blockID);
            if (!inferItem) continue;
            this.itemRemaps.put(fullID, blockID);
        }
    }

    public void registerLegacyItemIDs(String itemID, String ... oldIDs) {
        for (String oldID : oldIDs) {
            this.itemRemaps.put(String.format("%s:%s", this.domain, oldID), itemID);
        }
    }

    public void registerLegacyTileEntityIDs(String tileEntityID, String ... oldIDs) {
        for (String oldID : oldIDs) {
            this.tileEntityRemaps.put(String.format("%s:%s", this.domain, oldID), tileEntityID);
        }
    }

    public String mapBlock(String id) {
        String remap = this.blockRemaps.get(id);
        return remap != null ? remap : id;
    }

    public String remapBlock(String id) {
        return this.blockRemaps.get(id);
    }

    public String mapItem(String id) {
        String remap = this.itemRemaps.get(id);
        return remap != null ? remap : id;
    }

    public String remapItem(String id) {
        return this.itemRemaps.get(id);
    }

    public String mapTileEntity(String id) {
        String remap = this.tileEntityRemaps.get(id);
        return remap != null ? remap : id;
    }

    public String remapTileEntity(String id) {
        return this.tileEntityRemaps.get(id);
    }
}

