/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import java.util.HashMap;
import java.util.Map;

public class CustomizableMap<K, V> {
    protected final Map<K, V> map;
    protected final Map<K, V> solidMap;

    protected CustomizableMap(Map<K, V> map, Map<K, V> solidMap) {
        this.map = map;
        this.solidMap = solidMap;
    }

    public CustomizableMap() {
        this(new HashMap(), new HashMap());
    }

    public boolean hasCustom(K k) {
        V v = this.map.get(k);
        return v != null && !v.equals(this.solidMap.get(k));
    }

    public boolean hasSolid(K k) {
        return this.solidMap.containsKey(k);
    }

    public V put(K k, V v, boolean custom) {
        if (custom) {
            return this.map.put(k, v);
        }
        if (!this.hasCustom(k)) {
            this.map.put(k, v);
        }
        return this.solidMap.put(k, v);
    }

    public V remove(K k, boolean custom) {
        if (custom) {
            return this.hasCustom(k) ? (V)this.map.put(k, this.solidMap.get(k)) : null;
        }
        if (!this.hasCustom(k)) {
            this.map.remove(k);
        }
        return this.solidMap.remove(k);
    }

    public void clearCustom() {
        this.map.clear();
        this.map.putAll(this.solidMap);
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public Map<K, V> getSolidMap() {
        return this.solidMap;
    }
}

