/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.reccomplex.utils.IBlockState;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class BlockStates {
    public static IBlockState defaultState(@Nonnull Block block) {
        return new BlockState(block, 0);
    }

    public static IBlockState fromMetadata(@Nonnull Block block, int metadata) {
        return new BlockState(block, metadata);
    }

    public static IBlockState at(World world, BlockCoord coord) {
        return new BlockState(world.func_147439_a(coord.x, coord.y, coord.z), world.func_72805_g(coord.x, coord.y, coord.z));
    }

    public static IBlockState at(IvBlockCollection collection, BlockCoord coord) {
        return new BlockState(collection.getBlock(coord), collection.getMetadata(coord));
    }

    public static int getMetadata(IBlockState state) {
        return state instanceof BlockState ? ((BlockState)state).metadata : 0;
    }

    private static class BlockState
    implements IBlockState {
        @Nonnull
        private final Block block;
        private final int metadata;

        BlockState(@Nonnull Block block, int metadata) {
            this.block = block;
            this.metadata = metadata;
        }

        @Override
        @Nonnull
        public Block getBlock() {
            return this.block;
        }

        @Override
        public IBlockState with(int metadata) {
            return new BlockState(this.block, metadata);
        }

        public String toString() {
            return "BlockState{block=" + this.block + ", metadata=" + this.metadata + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockState that = (BlockState)o;
            if (this.metadata != that.metadata) {
                return false;
            }
            return this.block != null ? this.block.equals(that.block) : that.block == null;
        }

        public int hashCode() {
            int result = this.block != null ? this.block.hashCode() : 0;
            result = 31 * result + this.metadata;
            return result;
        }
    }
}

