/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.reccomplex.utils.Algebra;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Algebras {
    @Nullable
    public static <T> T tryEvaluate(String expression, Algebra<T> algebra, Function<String, T> variableEvaluator) {
        Algebra.Expression<T> parsed = Algebras.tryParse(expression, algebra);
        return parsed != null ? (T)parsed.evaluate(variableEvaluator) : null;
    }

    @Nullable
    public static <T> Algebra.Expression<T> tryParse(String string, Algebra<T> algebra) {
        try {
            return algebra.parse(string);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static abstract class Infix<T>
    extends Algebra.Operator<T> {
        public Infix(float precedence, String symbol) {
            super(precedence, true, true, symbol);
        }

        @Override
        public T evaluate(Function<String, T> variableEvaluator, Algebra.Expression<T>[] expressions) {
            return this.evaluate(variableEvaluator, expressions[0], expressions[1]);
        }

        public abstract T evaluate(Function<String, T> var1, Algebra.Expression<T> var2, Algebra.Expression<T> var3);
    }

    public static abstract class Unary<T>
    extends Algebra.Operator<T> {
        public Unary(float precedence, Notation notation, String symbol) {
            super(precedence, notation == Notation.POSTFIX, notation == Notation.PREFIX, symbol);
        }

        @Override
        public T evaluate(Function<String, T> variableEvaluator, Algebra.Expression<T>[] expressions) {
            return this.evaluate(variableEvaluator, expressions[0]);
        }

        public abstract T evaluate(Function<String, T> var1, Algebra.Expression<T> var2);

        public static enum Notation {
            PREFIX,
            POSTFIX;

        }
    }

    public static class Parentheses<T>
    extends Algebra.Operator<T> {
        public Parentheses(float precedence, String open, String close) {
            super(precedence, false, false, open, close);
        }

        @Override
        public T evaluate(Function<String, T> variableEvaluator, Algebra.Expression<T>[] expressions) {
            return expressions[0].evaluate(variableEvaluator);
        }
    }
}

