/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import ivorius.ivtoolkit.tools.Pairs;
import ivorius.ivtoolkit.tools.Ranges;
import ivorius.ivtoolkit.tools.Visitor;
import ivorius.reccomplex.utils.PrecedenceSet;
import ivorius.reccomplex.utils.PrecedenceSets;
import ivorius.reccomplex.utils.SymbolTokenizer;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class Algebra<T> {
    protected final Set<Operator<T>> operators = new HashSet<Operator<T>>();
    @Nonnull
    protected SymbolTokenizer.CharacterRules characterRules;

    public Algebra() {
        this(new SymbolTokenizer.SimpleCharacterRules());
    }

    public Algebra(@Nonnull SymbolTokenizer.CharacterRules characterRules) {
        this.characterRules = characterRules;
    }

    @SafeVarargs
    public Algebra(Operator<T> ... operators) {
        this(new SymbolTokenizer.SimpleCharacterRules(), operators);
    }

    @SafeVarargs
    public Algebra(@Nonnull SymbolTokenizer.CharacterRules characterRules, Operator<T> ... operators) {
        this.characterRules = characterRules;
        Collections.addAll(this.operators, operators);
    }

    protected static <T> ExpressionToken<T> reduceExpressions(List<SymbolTokenizer.Token> tokens, NavigableSet<PrecedenceSet<Operator<T>>> operators, int stringIndex) throws ParseException {
        SymbolTokenizer.Token startToken;
        if (tokens.size() == 0) {
            throw new ParseException("Expected Expression", stringIndex);
        }
        if (tokens.size() == 1 && (startToken = tokens.get(0)) instanceof ConstantToken) {
            tokens.remove(0);
            ExpressionToken exp = new ExpressionToken(startToken.startIndex, startToken.endIndex, new Constant(((ConstantToken)startToken).identifier));
            tokens.add(exp);
            return exp;
        }
        for (PrecedenceSet<Operator<T>> curOperators : operators) {
            Stack expressionStack = new Stack();
            expressionStack.push(new BuildingExpression(null, stringIndex, tokens.get((int)(tokens.size() - 1)).endIndex, 0, -1));
            for (int t = 0; t < tokens.size(); ++t) {
                SymbolTokenizer.Token token = tokens.get(t);
                if (!(token instanceof OperatorToken)) continue;
                OperatorToken operatorToken = (OperatorToken)token;
                Operator operator = operatorToken.operator;
                if (operator.precedence < curOperators.precedence) {
                    throw new ParseException("Internal Error (Operator Sorting)", operatorToken.startIndex);
                }
                if (!curOperators.contains(operator)) continue;
                if (((BuildingExpression)expressionStack.peek()).isAtLastSymbol() && ((BuildingExpression)expressionStack.peek()).operator.hasRightArgument() && operator.hasLeftArgument()) {
                    t -= Algebra.reduceBuildingExpression((BuildingExpression)expressionStack.pop(), tokens, operators.tailSet(curOperators, false), t);
                }
                if (operatorToken.symbolIndex == 0 || ((BuildingExpression)expressionStack.peek()).isNext(operatorToken.symbolIndex)) {
                    if (operatorToken.symbolIndex > 0 || operator.hasLeftArgument()) {
                        Integer lastTokenIndex = ((BuildingExpression)expressionStack.peek()).currentTokenIndex;
                        Algebra.reduceExpressions(tokens.subList(lastTokenIndex, t), operators.tailSet(curOperators, false), operatorToken.startIndex);
                        t -= t - lastTokenIndex - 1;
                    }
                    if (operatorToken.symbolIndex == 0) {
                        expressionStack.push(new BuildingExpression(operator, operatorToken.startIndex, operatorToken.endIndex, t));
                    } else {
                        ((BuildingExpression)expressionStack.peek()).advance(operatorToken.startIndex, operatorToken.endIndex, t, operatorToken.symbolIndex);
                    }
                    if (((BuildingExpression)expressionStack.peek()).isAtLastSymbol() && !operator.hasRightArgument()) {
                        BuildingExpression curExp = (BuildingExpression)expressionStack.pop();
                        int numberOfArguments = operator.getNumberOfArguments();
                        Algebra.reduceOperator(tokens.subList(t - numberOfArguments, t), curExp.startStringIndex, curExp.endStringIndex, operator);
                        t -= numberOfArguments - 1;
                    }
                    tokens.remove(t--);
                    continue;
                }
                throw new ParseException(String.format("Unexpected Token '%s'", operator.getSymbols()[operatorToken.symbolIndex]), operatorToken.startIndex);
            }
            while (((BuildingExpression)expressionStack.peek()).isAtLastSymbol() && ((BuildingExpression)expressionStack.peek()).operator.hasRightArgument()) {
                Algebra.reduceBuildingExpression((BuildingExpression)expressionStack.pop(), tokens, operators.tailSet(curOperators, false), tokens.size());
            }
            if (expressionStack.size() <= 1) continue;
            BuildingExpression curExp = (BuildingExpression)expressionStack.peek();
            String[] symbols = curExp.operator.getSymbols();
            throw new ParseException(String.format("Expected Token '%s'", symbols[curExp.expectedSymbolIndex()]), curExp.currentStringIndex + symbols[curExp.currentSymbolIndex].length());
        }
        if (tokens.size() > 1 || !(tokens.get(0) instanceof ExpressionToken)) {
            throw new ParseException("Expected Operator", tokens.get((int)1).startIndex);
        }
        return (ExpressionToken)tokens.get(0);
    }

    protected static <T> void reduceOperator(List<SymbolTokenizer.Token> tokens, int startIndex, int endIndex, Operator<T> operator) throws ParseException {
        if (tokens.size() < 1) {
            throw new ParseException("Internal Error (Missing Arguments)", startIndex);
        }
        Expression[] expressions = new Expression[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            SymbolTokenizer.Token token = tokens.get(i);
            if (!(token instanceof ExpressionToken)) {
                throw new ParseException("Internal Error (Unevaluated Token)", startIndex);
            }
            expressions[i] = ((ExpressionToken)token).expression;
        }
        tokens.clear();
        tokens.add(new ExpressionToken<T>(startIndex, endIndex, new Operation<T>(operator, expressions)));
    }

    protected static <T> int reduceBuildingExpression(BuildingExpression<T> buildingExpression, List<SymbolTokenizer.Token> tokens, NavigableSet<PrecedenceSet<Operator<T>>> followingOperators, int currentTokenIndex) throws ParseException {
        Operator endedOperator = buildingExpression.operator;
        int numberOfArguments = endedOperator.getNumberOfArguments();
        Integer lastTokenIndex = buildingExpression.currentTokenIndex;
        Algebra.reduceExpressions(tokens.subList(lastTokenIndex, currentTokenIndex), followingOperators, buildingExpression.endStringIndex);
        int difference = currentTokenIndex - lastTokenIndex - 1;
        Algebra.reduceOperator(tokens.subList((currentTokenIndex -= difference) - numberOfArguments, currentTokenIndex), buildingExpression.startStringIndex, buildingExpression.endStringIndex, endedOperator);
        return difference + numberOfArguments - 1;
    }

    public boolean addOperators(Collection<Operator<T>> operators) {
        return this.operators.addAll(operators);
    }

    public boolean addOperator(Operator<T> operator) {
        return this.operators.add(operator);
    }

    public boolean removeOperators(Collection<Operator<T>> operators) {
        return this.operators.removeAll(operators);
    }

    public boolean removeOperator(Operator<T> operator) {
        return this.operators.remove(operator);
    }

    public Set<Operator<T>> operators() {
        return Collections.unmodifiableSet(this.operators);
    }

    @Nonnull
    public SymbolTokenizer.CharacterRules getCharacterRules() {
        return this.characterRules;
    }

    public void setCharacterRules(@Nonnull SymbolTokenizer.CharacterRules characterRules) {
        this.characterRules = characterRules;
    }

    public SymbolTokenizer.TokenFactory getTokenFactory() {
        return new SymbolTokenizer.TokenFactory(){

            protected boolean hasAt(String string, int index, String symbol) {
                return string.regionMatches(index, symbol, 0, symbol.length());
            }

            @Override
            @Nullable
            public SymbolTokenizer.Token tryConstructSymbolTokenAt(int index, @Nonnull String string) {
                TreeSet sortedSymbols = new TreeSet((o1, o2) -> ((Operator)o2.getLeft()).getSymbols()[(Integer)o2.getRight()].compareTo(((Operator)o1.getLeft()).getSymbols()[(Integer)o1.getRight()]));
                sortedSymbols.addAll(Lists.newArrayList((Iterable)Iterables.concat((Iterable)Algebra.this.operators.stream().map(operator -> Pairs.pairLeft((Object)operator, (Iterable)Ranges.toIterable((int)operator.symbols.length))).collect(Collectors.toList()))));
                for (Pair symbolPair : sortedSymbols) {
                    String symbol = ((Operator)symbolPair.getLeft()).getSymbols()[(Integer)symbolPair.getRight()];
                    if (!this.hasAt(string, index, symbol)) continue;
                    return new OperatorToken(index, index + symbol.length(), (Operator)symbolPair.getLeft(), (Integer)symbolPair.getRight());
                }
                return null;
            }

            @Override
            @Nonnull
            public SymbolTokenizer.Token constructStringToken(int index, @Nonnull String string) {
                return new ConstantToken(index, index + string.length(), string);
            }
        };
    }

    @Nonnull
    public Expression<T> parse(String string) throws ParseException {
        return this.constructExpression(new SymbolTokenizer(this.characterRules, this.getTokenFactory()).tokenize(string));
    }

    public Expression<T> constructExpression(List<SymbolTokenizer.Token> tokens) throws ParseException {
        return Algebra.reduceExpressions((List<SymbolTokenizer.Token>)Lists.newArrayList(tokens), new TreeSet<PrecedenceSet<Operator<T>>>(PrecedenceSets.group(this.operators)), (int)0).expression;
    }

    protected static class OperatorToken<T>
    extends SymbolTokenizer.Token {
        public Operator<T> operator;
        public int symbolIndex;

        public OperatorToken(int startIndex, int endIndex, Operator<T> operator, int symbolIndex) {
            super(startIndex, endIndex);
            this.operator = operator;
            this.symbolIndex = symbolIndex;
        }
    }

    protected static class ConstantToken
    extends SymbolTokenizer.Token {
        public String identifier;

        public ConstantToken(int startIndex, int endIndex, String identifier) {
            super(startIndex, endIndex);
            this.identifier = identifier;
        }
    }

    protected static class ExpressionToken<T>
    extends SymbolTokenizer.Token {
        public Expression<T> expression;

        public ExpressionToken(int startIndex, int endIndex, Expression<T> expression) {
            super(startIndex, endIndex);
            this.expression = expression;
        }
    }

    public static abstract class Operator<T>
    implements PrecedenceSet.NativeEntry {
        protected float precedence;
        protected boolean hasLeftArgument;
        protected boolean hasRightArgument;
        protected String[] symbols;

        public Operator(float precedence, boolean hasLeftArgument, boolean hasRightArgument, String ... symbols) {
            this.precedence = precedence;
            this.hasLeftArgument = hasLeftArgument;
            this.hasRightArgument = hasRightArgument;
            this.symbols = symbols;
        }

        @Override
        public float getPrecedence() {
            return this.precedence;
        }

        public void setPrecedence(float precedence) {
            this.precedence = precedence;
        }

        public boolean hasLeftArgument() {
            return this.hasLeftArgument;
        }

        public void setHasLeftArgument(boolean hasLeftArgument) {
            this.hasLeftArgument = hasLeftArgument;
        }

        public boolean hasRightArgument() {
            return this.hasRightArgument;
        }

        public void setHasRightArgument(boolean hasRightArgument) {
            this.hasRightArgument = hasRightArgument;
        }

        public String[] getSymbols() {
            return this.symbols;
        }

        public void setSymbols(String[] symbols) {
            this.symbols = symbols;
        }

        public int getNumberOfArguments() {
            return this.symbols.length - 1 + (this.hasLeftArgument() ? 1 : 0) + (this.hasRightArgument() ? 1 : 0);
        }

        public abstract T evaluate(Function<String, T> var1, Expression<T>[] var2);
    }

    public static class Operation<T>
    extends Expression<T> {
        protected Operator<T> operator;
        protected Expression<T>[] expressions;

        @SafeVarargs
        public Operation(Operator<T> operator, Expression<T> ... expressions) {
            this.operator = operator;
            this.expressions = expressions;
        }

        public Expression getExpression(int index) {
            return this.expressions[index];
        }

        public void setExpression(int index, Expression<T> expression) {
            this.expressions[index] = expression;
        }

        @Override
        public T evaluate(@Nullable Function<String, T> input) {
            return this.operator.evaluate(input, this.expressions);
        }

        @Override
        public boolean walkVariables(Visitor<String> visitor) {
            for (Expression<T> expression : this.expressions) {
                if (expression.walkVariables(visitor)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString(Function<String, String> stringMapper) {
            StringBuilder builder = new StringBuilder();
            int idx = 0;
            String[] symbols = this.operator.getSymbols();
            boolean hasSpaceRightOfFirst = this.operator.hasLeftArgument();
            boolean hasSpaceLeftOfLast = this.operator.hasRightArgument();
            if (this.operator.hasLeftArgument()) {
                builder.append(this.expressions[idx++].toString(stringMapper));
            }
            for (int i = 0; i < symbols.length; ++i) {
                if ((i > 0 || this.operator.hasLeftArgument()) && (i != symbols.length - 1 || hasSpaceLeftOfLast)) {
                    builder.append(' ');
                }
                builder.append(symbols[i]);
                if ((i < symbols.length - 1 || this.operator.hasRightArgument()) && (i != 0 || hasSpaceRightOfFirst)) {
                    builder.append(' ');
                }
                if (i >= symbols.length - 1 && !this.operator.hasRightArgument()) continue;
                builder.append(this.expressions[idx++].toString(stringMapper));
            }
            return builder.toString();
        }
    }

    public static class Value<T>
    extends Expression<T> {
        public T value;
        public String representation;

        public Value(T value, String representation) {
            this.value = value;
            this.representation = representation;
        }

        @Override
        public T evaluate(@Nullable Function<String, T> input) {
            return this.value;
        }

        @Override
        public boolean walkVariables(Visitor<String> visitor) {
            return true;
        }

        @Override
        public String toString(Function<String, String> stringMapper) {
            return this.representation;
        }
    }

    public static class Constant<T>
    extends Expression<T> {
        public String identifier;

        public Constant(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public T evaluate(@Nullable Function<String, T> input) {
            if (input == null) {
                throw new NullPointerException();
            }
            return input.apply(this.identifier);
        }

        @Override
        public boolean walkVariables(Visitor<String> visitor) {
            return visitor.visit((Object)this.identifier);
        }

        @Override
        public String toString(Function<String, String> stringMapper) {
            return stringMapper.apply(this.identifier);
        }
    }

    public static abstract class Expression<T> {
        public abstract T evaluate(@Nullable Function<String, T> var1);

        public abstract boolean walkVariables(Visitor<String> var1);

        public abstract String toString(Function<String, String> var1);
    }

    protected static class BuildingExpression<T> {
        public int startStringIndex;
        public int currentStringIndex;
        public int endStringIndex;
        public int currentTokenIndex;
        public Operator<T> operator;
        public int currentSymbolIndex;

        public BuildingExpression(Operator<T> operator, int startStringIndex, int endStringIndex, int currentTokenIndex) {
            this.operator = operator;
            this.startStringIndex = startStringIndex;
            this.currentStringIndex = startStringIndex;
            this.endStringIndex = endStringIndex;
            this.currentTokenIndex = currentTokenIndex;
            this.currentSymbolIndex = 0;
        }

        public BuildingExpression(Operator<T> operator, int startStringIndex, int endStringIndex, int currentTokenIndex, int currentSymbolIndex) {
            this.operator = operator;
            this.startStringIndex = startStringIndex;
            this.currentStringIndex = startStringIndex;
            this.endStringIndex = endStringIndex;
            this.currentTokenIndex = currentTokenIndex;
            this.currentSymbolIndex = currentSymbolIndex;
        }

        public void advance(int stringStartIndex, int stringEndIndex, int tokenIndex, int symbolIndex) {
            this.currentStringIndex = stringStartIndex;
            this.endStringIndex = stringEndIndex;
            this.currentTokenIndex = tokenIndex;
            this.currentSymbolIndex = symbolIndex;
        }

        public int expectedSymbolIndex() {
            return this.currentSymbolIndex + 1;
        }

        public boolean isNext(int symbolIndex) {
            return this.currentSymbolIndex + 1 == symbolIndex;
        }

        public boolean isAtLastSymbol() {
            return this.operator != null && this.operator.getSymbols().length - 1 == this.currentSymbolIndex;
        }
    }
}

