/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.transformers;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.utils.BlockStates;
import ivorius.reccomplex.utils.IBlockState;
import ivorius.reccomplex.utils.NBTStorable;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TransformerSingleBlock<S extends NBTStorable>
implements Transformer<S> {
    @Override
    public boolean skipGeneration(S instanceData, IBlockState state) {
        return this.matches(instanceData, state);
    }

    @Override
    public void transform(S instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, List<Pair<Transformer, NBTStorable>> transformers) {
        IvBlockCollection blockCollection = worldData.blockCollection;
        int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
        BlockCoord lowerCoord = context.lowerCoord();
        for (BlockCoord sourceCoord : blockCollection) {
            IBlockState state;
            BlockCoord worldCoord = context.transform.apply(sourceCoord, areaSize).add(lowerCoord);
            if (!context.includes(worldCoord) || !this.matches(instanceData, state = BlockStates.at(blockCollection, sourceCoord))) continue;
            this.transformBlock(instanceData, Transformer.Phase.BEFORE, context, worldCoord, state);
        }
    }

    public abstract boolean matches(S var1, IBlockState var2);

    public abstract void transformBlock(S var1, Transformer.Phase var2, StructureSpawnContext var3, BlockCoord var4, IBlockState var5);
}

