/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.transformers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTReplace;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.WeightedBlockState;
import ivorius.reccomplex.structures.generic.matchers.BlockMatcher;
import ivorius.reccomplex.structures.generic.presets.WeightedBlockStatePresets;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.structures.generic.transformers.TransformerSingleBlock;
import ivorius.reccomplex.utils.BlockStates;
import ivorius.reccomplex.utils.IBlockState;
import ivorius.reccomplex.utils.NBTNone;
import ivorius.reccomplex.utils.PresettedList;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TransformerReplace
extends TransformerSingleBlock<NBTNone> {
    public final PresettedList<WeightedBlockState> destination = new PresettedList<WeightedBlockState>(WeightedBlockStatePresets.instance(), null);
    public BlockMatcher sourceMatcher;

    public TransformerReplace() {
        this(BlockMatcher.of(RecurrentComplex.specialRegistry, Blocks.field_150325_L));
        this.destination.setToDefault();
    }

    public TransformerReplace(String sourceExpression) {
        this.sourceMatcher = new BlockMatcher(RecurrentComplex.specialRegistry, sourceExpression);
    }

    public static NBTTagCompound tryParse(String json) {
        NBTBase nbtbase = null;
        try {
            nbtbase = JsonToNBT.func_150315_a((String)json);
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
        if (nbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        return null;
    }

    public static NBTTagCompound positionedCopy(NBTTagCompound compound, BlockCoord teCoord) {
        NBTTagCompound positioned = (NBTTagCompound)compound.func_74737_b();
        positioned.func_74768_a("x", teCoord.x);
        positioned.func_74768_a("y", teCoord.y);
        positioned.func_74768_a("z", teCoord.z);
        return positioned;
    }

    public TransformerReplace replaceWith(WeightedBlockState ... states) {
        this.destination.setContents(Arrays.asList(states));
        return this;
    }

    @Override
    public boolean matches(NBTNone instanceData, IBlockState state) {
        return this.sourceMatcher.apply(state);
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, BlockCoord coord, IBlockState sourceState) {
        WeightedBlockState blockState = this.destination.list.size() > 0 ? (WeightedBlockState)WeightedSelector.selectItem((Random)context.random, this.destination.list) : new WeightedBlockState(null, null, "");
        NBTTagCompound parsedTileEntityInfo = blockState.tileEntityInfo.trim().length() > 0 ? TransformerReplace.tryParse(blockState.tileEntityInfo) : null;
        TransformerReplace.setBlockWith(context, coord, context.world, blockState, parsedTileEntityInfo);
    }

    public static void setBlockWith(StructureSpawnContext context, BlockCoord coord, World world, WeightedBlockState entry, NBTTagCompound parsedTileEntityInfo) {
        if (entry.state != null && RecurrentComplex.specialRegistry.isSafe(entry.state.getBlock())) {
            TileEntity tileentity;
            NBTTagCompound nbtTagCompound;
            context.setBlock(coord.x, coord.y, coord.z, entry.state);
            if (parsedTileEntityInfo != null && entry.state.getBlock().hasTileEntity(BlockStates.getMetadata(entry.state)) && (nbtTagCompound = TransformerReplace.positionedCopy(parsedTileEntityInfo, coord)) != null && (tileentity = world.func_147438_o(coord.x, coord.y, coord.z)) != null) {
                tileentity.func_145839_a(nbtTagCompound);
            }
        }
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public String getDisplayString() {
        return "Replace: " + this.sourceMatcher.getDisplayString();
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTReplace(this, navigator, delegate);
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerReplace>,
    JsonSerializer<TransformerReplace> {
        private MCRegistry registry;
        private Gson gson;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
            this.gson = new GsonBuilder().registerTypeAdapter(WeightedBlockState.class, (Object)new WeightedBlockState.Serializer(registry)).create();
        }

        public static String readLegacyMatcher(JsonObject jsonObject, String blockKey, String metadataKey) {
            if (jsonObject.has(blockKey)) {
                String sourceBlock = JsonUtils.getJsonObjectStringFieldValue(jsonObject, blockKey);
                int sourceMeta = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonObject, metadataKey, -1);
                return sourceMeta >= 0 ? String.format("%s & %s%d", sourceBlock, "#", sourceMeta) : sourceBlock;
            }
            return null;
        }

        public TransformerReplace deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "transformerReplace");
            String expression = Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "sourceExpression", "");
            }
            TransformerReplace transformer = new TransformerReplace(expression);
            if (!transformer.destination.setPreset(JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "destinationPreset", null)) && jsonObject.has("destination")) {
                Collections.addAll(transformer.destination.list, (Object[])this.gson.fromJson(jsonObject.get("destination"), WeightedBlockState[].class));
            }
            if (jsonObject.has("dest")) {
                String destBlock = JsonUtils.getJsonObjectStringFieldValue(jsonObject, "dest");
                Block dest = this.registry.blockFromID(destBlock);
                byte[] destMeta = (byte[])context.deserialize(jsonObject.get("destMetadata"), byte[].class);
                transformer.destination.setToCustom();
                for (byte b : destMeta) {
                    transformer.destination.list.add(new WeightedBlockState(null, BlockStates.fromMetadata(dest, b), ""));
                }
            }
            return transformer;
        }

        public JsonElement serialize(TransformerReplace transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            if (transformer.destination.getPreset() != null) {
                jsonObject.addProperty("destinationPreset", transformer.destination.getPreset());
            }
            jsonObject.add("destination", this.gson.toJsonTree(transformer.destination.list));
            return jsonObject;
        }
    }
}

