/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePassages;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRooms;
import ivorius.ivtoolkit.maze.components.SetMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureInfos;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.gentypes.MazeGenerationInfo;
import ivorius.reccomplex.structures.generic.maze.Connector;
import ivorius.reccomplex.structures.generic.maze.ConnectorFactory;
import ivorius.reccomplex.structures.generic.maze.MazeComponentStructure;
import ivorius.reccomplex.structures.generic.maze.PlacedStructure;
import ivorius.reccomplex.structures.generic.maze.SavedMazeComponent;
import ivorius.reccomplex.structures.generic.maze.SavedMazePaths;
import ivorius.reccomplex.structures.generic.maze.SavedMazeReachability;
import ivorius.reccomplex.utils.NBTStorable;
import ivorius.reccomplex.worldgen.StructureGenerationData;
import ivorius.reccomplex.worldgen.StructureGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenMaze {
    public static boolean generatePlacedStructures(List<PlacedStructure> placedStructures, StructureSpawnContext context) {
        for (PlacedStructure placedComponent : placedStructures) {
            StructureInfo structureInfo = StructureRegistry.INSTANCE.getStructure(placedComponent.structureID);
            if (structureInfo != null && placedComponent.instanceData != null) {
                AxisAlignedTransform2D componentTransform = placedComponent.transform;
                StructureBoundingBox compBoundingBox = StructureInfos.structureBoundingBox(placedComponent.lowerCoord, StructureInfos.structureSize(structureInfo, componentTransform));
                BlockCoord coord = new BlockCoord(compBoundingBox.field_78897_a, compBoundingBox.field_78895_b, compBoundingBox.field_78896_c);
                StructureGenerator.partially(structureInfo, context.world, context.random, coord, componentTransform, context.generationBB, context.generationLayer + 1, placedComponent.structureID, placedComponent.instanceData, context.isFirstTime);
                if (!context.isFirstTime) continue;
                StructureGenerationData.get(context.world).addCompleteEntry(placedComponent.structureID, coord, componentTransform);
                continue;
            }
            RecurrentComplex.logger.error(String.format("Could not find structure '%s' for maze", placedComponent.structureID));
        }
        return true;
    }

    public static List<PlacedStructure> convertToPlacedStructures(Random random, BlockCoord coord, BlockCoord shift, List<ShiftedMazeComponent<MazeComponentStructure<Connector>, Connector>> placedComponents, int[] roomSize, AxisAlignedTransform2D mazeTransform) {
        return Lists.newArrayList((Iterable)placedComponents.stream().map(placedComponent -> {
            MazeComponentStructure componentInfo = (MazeComponentStructure)placedComponent.getComponent();
            StructureInfo structureInfo = StructureRegistry.INSTANCE.getStructure(componentInfo.structureID);
            if (structureInfo != null) {
                AxisAlignedTransform2D componentTransform = componentInfo.transform.rotateClockwise(mazeTransform.getRotation());
                StructureBoundingBox compBoundingBox = WorldGenMaze.getBoundingBox(coord, shift, roomSize, (ShiftedMazeComponent<MazeComponentStructure<Connector>, Connector>)placedComponent, structureInfo, componentTransform, mazeTransform);
                Object instanceData = structureInfo.prepareInstanceData(new StructurePrepareContext(random, componentTransform, compBoundingBox, false));
                return new PlacedStructure(componentInfo.structureID, componentTransform, new BlockCoord(compBoundingBox.field_78897_a, compBoundingBox.field_78895_b, compBoundingBox.field_78896_c), (NBTStorable)instanceData);
            }
            RecurrentComplex.logger.error(String.format("Could not find structure '%s' for maze", componentInfo.structureID));
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    protected static StructureBoundingBox getBoundingBox(BlockCoord coord, BlockCoord shift, int[] roomSize, ShiftedMazeComponent<MazeComponentStructure<Connector>, Connector> placedComponent, StructureInfo structureInfo, AxisAlignedTransform2D componentTransform, AxisAlignedTransform2D mazeTransform) {
        MazeRoom mazePosition = placedComponent.getShift();
        int[] scaledMazePosition = IvVecMathHelper.mul((int[][])new int[][]{mazePosition.getCoordinates(), roomSize});
        int[] structureBB = StructureInfos.structureSize(structureInfo, componentTransform);
        int[] compRoomSize = StructureInfos.structureSize(IvVecMathHelper.mul((int[][])new int[][]{((MazeComponentStructure)placedComponent.getComponent()).getSize(), roomSize}), mazeTransform);
        int[] sizeDependentShift = new int[compRoomSize.length];
        for (int i = 0; i < structureBB.length; ++i) {
            sizeDependentShift[i] = (compRoomSize[i] - structureBB[i]) / 2;
        }
        BlockCoord lowerCoord = StructureInfos.transformedLowerCoord(coord.add(mazeTransform.apply(shift.add(scaledMazePosition[0], scaledMazePosition[1], scaledMazePosition[2]), new int[]{1, 1, 1})).add(sizeDependentShift[0], sizeDependentShift[1], sizeDependentShift[2]), structureBB, mazeTransform);
        return StructureInfos.structureBoundingBox(lowerCoord, structureBB);
    }

    public static List<MazeComponentStructure<Connector>> transformedComponents(Collection<Pair<StructureInfo, MazeGenerationInfo>> componentStructures, ConnectorFactory factory, AxisAlignedTransform2D transform, Collection<Connector> blockedConnections) {
        ArrayList<MazeComponentStructure<Connector>> transformedComponents = new ArrayList<MazeComponentStructure<Connector>>();
        for (Pair<StructureInfo, MazeGenerationInfo> pair : componentStructures) {
            StructureInfo info = (StructureInfo)pair.getLeft();
            SavedMazeComponent comp = ((MazeGenerationInfo)pair.getRight()).mazeComponent;
            int[] compSize = comp.getSize();
            int roomVariations = (info.isRotatable() ? 4 : 1) * (info.isMirrorable() ? 2 : 1);
            double splitCompWeight = 0.0;
            if (comp.getWeight() > 0.0) {
                splitCompWeight = comp.getWeight() / (double)roomVariations;
            }
            for (int rotations = 0; rotations < 4; ++rotations) {
                if (!info.isRotatable() && transform.apply(rotations) != 0) continue;
                transformedComponents.add(WorldGenMaze.transformedComponent(info, comp, AxisAlignedTransform2D.from((int)rotations, (boolean)false), compSize, splitCompWeight, factory, blockedConnections));
                if (!info.isMirrorable()) continue;
                transformedComponents.add(WorldGenMaze.transformedComponent(info, comp, AxisAlignedTransform2D.from((int)rotations, (boolean)true), compSize, splitCompWeight, factory, blockedConnections));
            }
        }
        return transformedComponents;
    }

    public static MazeComponentStructure<Connector> transformedComponent(StructureInfo info, SavedMazeComponent comp, AxisAlignedTransform2D transform, int[] size, double weight, ConnectorFactory factory, Collection<Connector> blockedConnections) {
        Set<MazeRoom> transformedRooms = comp.getRooms().stream().map(input -> MazeRooms.rotated((MazeRoom)input, (AxisAlignedTransform2D)transform, (int[])size)).collect(Collectors.toSet());
        HashMap<MazePassage, Connector> transformedExits = new HashMap<MazePassage, Connector>();
        comp.getExitPaths().stream().map(SavedMazePaths.buildFunction(factory)).forEach(path -> {
            Connector cfr_ignored_0 = (Connector)transformedExits.put(MazePassages.rotated((MazePassage)((MazePassage)path.getKey()), (AxisAlignedTransform2D)transform, (int[])size), (Connector)path.getValue());
        });
        WorldGenMaze.addMissingExits(transformedRooms, transformedExits, comp.defaultConnector.toConnector(factory));
        ImmutableMultimap<MazePassage, MazePassage> reachability = comp.reachability.build(transform, size, SavedMazeReachability.notBlocked(blockedConnections, transformedExits), transformedExits.keySet());
        return new MazeComponentStructure<Connector>(weight, StructureRegistry.INSTANCE.structureID(info), transform, (ImmutableSet<MazeRoom>)ImmutableSet.copyOf(transformedRooms), ImmutableMap.copyOf(transformedExits), reachability);
    }

    public static <C> SetMazeComponent<C> createCompleteComponent(Set<MazeRoom> rooms, Map<MazePassage, C> exits, C wallConnector) {
        SetMazeComponent component = new SetMazeComponent(rooms, exits, (Multimap)HashMultimap.create());
        WorldGenMaze.addMissingExits(component.rooms, component.exits, wallConnector);
        return component;
    }

    public static <C> void addMissingExits(Set<MazeRoom> rooms, Map<MazePassage, C> exits, C connector) {
        for (MazeRoom room : rooms) {
            MazeRooms.neighborPassages((MazeRoom)room).filter(passage -> !exits.containsKey(passage) && (!rooms.contains(passage.getLeft()) || !rooms.contains(passage.getRight()))).forEach(passage -> exits.put((MazePassage)passage, connector));
        }
    }
}

