/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.Selection;
import ivorius.reccomplex.structures.generic.maze.SavedConnector;
import ivorius.reccomplex.structures.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.structures.generic.maze.SavedMazeReachability;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SavedMazeComponent
implements NBTCompoundObject,
WeightedSelector.Item {
    public Double weight;
    public final Selection rooms = new Selection();
    public final List<SavedMazePathConnection> exitPaths = new ArrayList<SavedMazePathConnection>();
    public final SavedConnector defaultConnector = new SavedConnector("Wall");
    public final SavedMazeReachability reachability = new SavedMazeReachability();

    public SavedMazeComponent() {
    }

    public SavedMazeComponent(Double weight, String defaultConnector) {
        this.weight = weight;
        this.defaultConnector.id = defaultConnector;
    }

    public boolean isValid() {
        return !this.rooms.isEmpty();
    }

    public Collection<MazeRoom> getRooms() {
        return this.rooms.mazeRooms(true);
    }

    public List<SavedMazePathConnection> getExitPaths() {
        return Collections.unmodifiableList(this.exitPaths);
    }

    public void setExitPaths(List<SavedMazePathConnection> exitPaths) {
        this.exitPaths.clear();
        this.exitPaths.addAll(exitPaths);
    }

    public int[] getSize() {
        int[] lowest = ((Selection.Area)this.rooms.get(0)).getMinCoord();
        int[] highest = ((Selection.Area)this.rooms.get(0)).getMaxCoord();
        for (MazeRoom room : this.getRooms()) {
            int[] coordinates = room.getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                if (coordinates[i] < lowest[i]) {
                    lowest[i] = coordinates[i];
                    continue;
                }
                if (coordinates[i] <= highest[i]) continue;
                highest[i] = coordinates[i];
            }
        }
        int[] size = IvVecMathHelper.sub((int[])highest, (int[][])new int[][]{lowest});
        int i = 0;
        while (i < size.length) {
            int n = i++;
            size[n] = size[n] + 1;
        }
        return size;
    }

    public void readFromNBT(NBTTagCompound compound) {
        Double d = this.weight = compound.func_150297_b("weight", 6) ? Double.valueOf(compound.func_74769_h("weight")) : null;
        if (compound.func_150297_b("roomArea", 10)) {
            this.rooms.readFromNBT(compound.func_74775_l("roomArea"), 3);
        } else if (compound.func_150297_b("rooms", 9)) {
            this.rooms.clear();
            this.rooms.addAll(Lists.transform((List)NBTTagLists.compoundsFrom((NBTTagCompound)compound, (String)"rooms"), input -> {
                MazeRoom room = new MazeRoom(input.func_74759_k("coordinates"));
                int[] coordinates = room.getCoordinates();
                return new Selection.Area(true, coordinates, (int[])coordinates.clone());
            }));
        }
        this.exitPaths.clear();
        this.exitPaths.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"exits", SavedMazePathConnection.class));
        this.defaultConnector.id = compound.func_150297_b("defaultConnector", 8) ? compound.func_74779_i("defaultConnector") : "Path";
    }

    public void writeToNBT(NBTTagCompound compound) {
        if (this.weight != null) {
            compound.func_74780_a("weight", this.weight.doubleValue());
        }
        NBTTagCompound roomsCompound = new NBTTagCompound();
        this.rooms.writeToNBT(roomsCompound);
        compound.func_74782_a("rooms", (NBTBase)roomsCompound);
        NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"exits", this.exitPaths);
        compound.func_74778_a("defaultConnector", this.defaultConnector.id);
    }

    public double getWeight() {
        return this.weight != null ? this.weight : 1.0;
    }

    public boolean hasDefaultWeight() {
        return this.weight == null;
    }

    public static class RoomSerializer
    implements JsonSerializer<MazeRoom>,
    JsonDeserializer<MazeRoom> {
        public MazeRoom deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "MazeRoom");
            return new MazeRoom((int[])context.deserialize(jsonObject.get("coordinates"), int[].class));
        }

        public JsonElement serialize(MazeRoom src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("coordinates", context.serialize((Object)src.getCoordinates()));
            return jsonObject;
        }
    }

    public static class Serializer
    implements JsonSerializer<SavedMazeComponent>,
    JsonDeserializer<SavedMazeComponent> {
        public SavedMazeComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Double weight;
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "MazeComponent");
            Double d = weight = jsonObject.has("weightD") ? Double.valueOf(JsonUtils.getJsonObjectDoubleFieldValue(jsonObject, "weightD")) : null;
            if (weight == null && jsonObject.has("weight")) {
                weight = (double)JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "weight") * 0.01;
            }
            String defaultConnector = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "defaultConnector", "Wall");
            SavedMazeComponent mazeComponent = new SavedMazeComponent(weight, defaultConnector);
            if (jsonObject.has("roomArea")) {
                mazeComponent.rooms.addAll((Collection)context.deserialize(jsonObject.get("roomArea"), Selection.class));
            }
            if (jsonObject.has("rooms")) {
                MazeRoom[] rooms;
                for (MazeRoom room : rooms = (MazeRoom[])context.deserialize(jsonObject.get("rooms"), MazeRoom[].class)) {
                    mazeComponent.rooms.add(new Selection.Area(true, room.getCoordinates(), room.getCoordinates()));
                }
            }
            SavedMazePathConnection[] exits = (SavedMazePathConnection[])context.deserialize(jsonObject.get("exits"), SavedMazePathConnection[].class);
            mazeComponent.setExitPaths(Arrays.asList(exits));
            if (jsonObject.has("reachability")) {
                mazeComponent.reachability.set((SavedMazeReachability)context.deserialize(jsonObject.get("reachability"), SavedMazeReachability.class));
            }
            return mazeComponent;
        }

        public JsonElement serialize(SavedMazeComponent src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (src.weight != null) {
                jsonObject.addProperty("weightD", (Number)src.weight);
            }
            jsonObject.add("roomArea", context.serialize((Object)src.rooms));
            jsonObject.add("exits", context.serialize(src.exitPaths));
            jsonObject.addProperty("defaultConnector", src.defaultConnector.id);
            jsonObject.add("reachability", context.serialize((Object)src.reachability));
            return jsonObject;
        }
    }
}

