/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.scripts.world;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.worldscripts.multi.TableDataSourceWorldScriptList;
import ivorius.reccomplex.scripts.world.WorldScript;
import ivorius.reccomplex.scripts.world.WorldScriptRegistry;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.utils.IvTranslations;
import ivorius.reccomplex.utils.NBTStorable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class WorldScriptMulti
implements WorldScript<InstanceData> {
    public final List<WorldScript> scripts = new ArrayList<WorldScript>();

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, BlockCoord coord, World world) {
        InstanceData instanceData = new InstanceData();
        for (WorldScript script : this.scripts) {
            instanceData.addInstanceData((NBTStorable)script.prepareInstanceData(context, coord, world), WorldScriptRegistry.INSTANCE.type(script.getClass()));
        }
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound(), this.scripts, context);
    }

    @Override
    public void generate(StructureSpawnContext context, InstanceData instanceData, BlockCoord coord) {
        for (int i = 0; i < this.scripts.size(); ++i) {
            NBTStorable scriptData = instanceData.instanceDates.get(i);
            if (scriptData == null) continue;
            this.scripts.get(i).generate(context, scriptData, coord);
        }
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.worldscript.multi");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptList(this.scripts, tableDelegate, navigator);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts.clear();
        this.scripts.addAll(NBTTagLists.compoundsFrom((NBTTagCompound)compound, (String)"scripts").stream().map(WorldScriptRegistry.INSTANCE::read).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagLists.writeCompoundsTo((NBTTagCompound)compound, (String)"scripts", this.scripts.stream().map(WorldScriptRegistry.INSTANCE::write).collect(Collectors.toList()));
    }

    public static class InstanceData
    implements NBTStorable {
        public final List<NBTStorable> instanceDates = new ArrayList<NBTStorable>();
        public final List<String> ids = new ArrayList<String>();

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound, List<WorldScript> expectedScripts, StructureLoadContext context) {
            int i;
            List compoundsFrom = NBTTagLists.compoundsFrom((NBTTagCompound)compound, (String)"instanceDates");
            for (i = 0; i < compoundsFrom.size(); ++i) {
                NBTTagCompound scriptTag = (NBTTagCompound)compoundsFrom.get(i);
                WorldScript script = expectedScripts.get(i);
                if (WorldScriptRegistry.INSTANCE.type(script.getClass()).equals(scriptTag.func_74779_i("id"))) {
                    this.instanceDates.add((NBTStorable)script.loadInstanceData(context, compound.func_74781_a("data")));
                    continue;
                }
                this.instanceDates.add(null);
            }
            for (i = compoundsFrom.size(); i < expectedScripts.size(); ++i) {
                this.instanceDates.add(null);
            }
        }

        public void addInstanceData(NBTStorable instanceData, String id) {
            this.instanceDates.add(instanceData);
            this.ids.add(id);
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList dataList = new NBTTagList();
            for (int i = 0; i < this.instanceDates.size(); ++i) {
                NBTTagCompound scriptTag = new NBTTagCompound();
                scriptTag.func_74782_a("data", this.instanceDates.get(i).writeToNBT());
                scriptTag.func_74778_a("id", this.ids.get(i));
                dataList.func_74742_a((NBTBase)scriptTag);
            }
            nbt.func_74782_a("instanceDates", (NBTBase)dataList);
            return null;
        }
    }
}

