/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random;

import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class BlurredValueField
implements NBTCompoundObject {
    private final List<Value> values = new ArrayList<Value>();
    private int[] size;

    public BlurredValueField() {
    }

    public BlurredValueField(int ... size) {
        this.size = size;
    }

    public int[] getSize() {
        return (int[])this.size.clone();
    }

    public void addValue(Value value) {
        this.values.add(value);
    }

    public void addValue(float value, Random random) {
        int[] pos = new int[this.size.length];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = random.nextInt(this.size[i]);
        }
        this.addValue(new Value(value, pos));
    }

    public float getValue(int ... position) {
        double[] pos = new double[position.length];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = position[i];
        }
        float total = 0.0f;
        float[] inf = new float[this.values.size()];
        for (int i = 0; i < inf.length; ++i) {
            Value value = this.values.get(i);
            double[] valPos = new double[this.size.length];
            for (int j = 0; j < valPos.length; ++j) {
                valPos[j] = value.pos[j];
            }
            double dist = IvVecMathHelper.distanceSQ((double[])pos, (double[])valPos);
            dist *= dist;
            if ((dist *= dist) <= 1.0E-4) {
                return value.value;
            }
            inf[i] = (float)(1.0 / dist);
            total += inf[i];
        }
        float retVal = 0.0f;
        for (int i = 0; i < inf.length; ++i) {
            retVal += this.values.get(i).value * (inf[i] / total);
        }
        return retVal;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.size = compound.func_74759_k("size");
        this.values.addAll(NBTCompoundObjects.readListFrom((NBTTagCompound)compound, (String)"values", Value.class));
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74783_a("size", this.size);
        NBTCompoundObjects.writeListTo((NBTTagCompound)compound, (String)"values", this.values);
    }

    public static class Value
    implements NBTCompoundObject {
        private float value;
        private int[] pos;

        public Value() {
        }

        public Value(float value, int[] pos) {
            this.value = value;
            this.pos = pos;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.value = compound.func_74760_g("value");
            this.pos = compound.func_74759_k("pos");
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74776_a("value", this.value);
            compound.func_74783_a("pos", this.pos);
        }
    }
}

