/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.operation;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.operation.Operation;
import ivorius.reccomplex.utils.ServerTranslations;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class OperationRegistry {
    private static BiMap<String, Class<? extends Operation>> operations = HashBiMap.create();

    public static void register(String id, Class<? extends Operation> operation) {
        operations.put((Object)id, operation);
    }

    @Nullable
    public static Operation readOperation(@Nonnull NBTTagCompound compound) {
        String opID = compound.func_74779_i("opID");
        Class clazz = (Class)operations.get((Object)opID);
        if (clazz == null) {
            RecurrentComplex.logger.error(String.format("Unrecognized Operation ID '%s'", opID));
            return null;
        }
        try {
            Operation operation = (Operation)clazz.newInstance();
            operation.readFromNBT(compound);
            return operation;
        }
        catch (IllegalAccessException | InstantiationException e) {
            RecurrentComplex.logger.error(String.format("Could not read Operation with ID '%s'", opID), (Throwable)e);
            return null;
        }
    }

    public static NBTTagCompound writeOperation(@Nonnull Operation operation) {
        NBTTagCompound compound = new NBTTagCompound();
        operation.writeToNBT(compound);
        compound.func_74778_a("opID", (String)operations.inverse().get(operation.getClass()));
        return compound;
    }

    public static void queueOperation(Operation operation, ICommandSender commandSender) {
        EntityPlayerMP player;
        StructureEntityInfo info;
        boolean instant = true;
        if (commandSender instanceof EntityPlayer && (info = StructureEntityInfo.getStructureEntityInfo((Entity)(player = CommandBase.func_71521_c((ICommandSender)commandSender)))) != null && info.getPreviewType() != Operation.PreviewType.NONE) {
            info.queueOperation(operation, (Entity)player);
            instant = false;
            ChatComponentText confirmComponent = new ChatComponentText("/" + RCCommands.confirm.func_71517_b());
            confirmComponent.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
            confirmComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + RCCommands.confirm.func_71517_b()));
            confirmComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ServerTranslations.get("commands.rcconfirm.run")));
            ChatComponentText cancelComponent = new ChatComponentText("/" + RCCommands.cancel.func_71517_b());
            cancelComponent.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            cancelComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + RCCommands.cancel.func_71517_b()));
            cancelComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ServerTranslations.get("commands.rccancel.run")));
            IChatComponent component = ServerTranslations.format("commands.rc.queuedOp", confirmComponent, cancelComponent);
            commandSender.func_145747_a(component);
        }
        if (instant) {
            operation.perform(commandSender.func_130014_f_());
        }
    }
}

