/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.structuregenerator;

import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDataSourceBlockCoord;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellBoolean;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableCellString;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.scripts.world.WorldScriptStructureGenerator;
import ivorius.reccomplex.structures.StructureRegistry;
import java.util.Arrays;
import joptsimple.internal.Strings;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class TableDataSourceStructureBlock
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    protected WorldScriptStructureGenerator script;
    protected TableNavigator tableNavigator;
    protected TableDelegate tableDelegate;

    public TableDataSourceStructureBlock(WorldScriptStructureGenerator script, TableNavigator tableNavigator, TableDelegate tableDelegate) {
        this.script = script;
        this.tableNavigator = tableNavigator;
        this.tableDelegate = tableDelegate;
        this.addManagedSection(2, new TableDataSourceBlockCoord(script.getStructureShift(), script::setStructureShift, new IntegerRange(-50, 50), "Range: %s"));
    }

    private static boolean doAllStructuresExist(Iterable<String> structures) {
        for (String s : structures) {
            if (s.length() == 0 || StructureRegistry.INSTANCE.getStructure(s) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int numberOfSegments() {
        return this.script.isSimpleMode() ? 4 : 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        if (segment == 0) {
            return 1;
        }
        if (segment == 1) {
            return 1;
        }
        if (segment == 3) {
            return this.script.isSimpleMode() ? 2 : 1;
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellBoolean cell = new TableCellBoolean("simpleMode", this.script.isSimpleMode());
            cell.addPropertyListener(this);
            return new TableElementCell("Simple Mode", cell);
        }
        if (segment == 1) {
            if (this.script.isSimpleMode()) {
                TableCellString cell = new TableCellString("generators", Strings.join(this.script.getStructureNames(), (String)","));
                cell.setShowsValidityState(true);
                cell.setValidityState(TableDataSourceStructureBlock.doAllStructuresExist(this.script.getStructureNames()) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
                cell.addPropertyListener(this);
                return new TableElementCell("Generators (A,B,...)", cell);
            }
            TableCellString cell = new TableCellString("listID", this.script.getStructureListID());
            cell.addPropertyListener(this);
            return new TableElementCell("List ID", cell);
        }
        if (segment == 3) {
            if (this.script.isSimpleMode()) {
                if (index == 0) {
                    TableCellEnum<Integer> cell = new TableCellEnum<Integer>("rotation", this.script.getStructureRotation(), new TableCellEnum.Option<Integer>(0, "0 Clockwise"), new TableCellEnum.Option<Integer>(1, "1 Clockwise"), new TableCellEnum.Option<Integer>(2, "2 Clockwise"), new TableCellEnum.Option<Integer>(3, "3 Clockwise"), new TableCellEnum.Option<Object>(null, "Random (if rotatable)"));
                    cell.addPropertyListener(this);
                    return new TableElementCell("Rotation", cell);
                }
                if (index == 1) {
                    TableCellEnum<Boolean> cell = new TableCellEnum<Boolean>("mirror", this.script.getStructureMirror(), new TableCellEnum.Option<Boolean>(false, "false"), new TableCellEnum.Option<Boolean>(true, "true"), new TableCellEnum.Option<Object>(null, "Random (if mirrorable)"));
                    cell.addPropertyListener(this);
                    return new TableElementCell("Mirror", cell);
                }
            } else {
                TableCellEnum<ForgeDirection> cell = new TableCellEnum<ForgeDirection>("front", this.script.getFront(), TableDirections.getDirectionOptions((ForgeDirection[])ArrayUtils.add((Object[])Directions.HORIZONTAL, null), "random"));
                cell.addPropertyListener(this);
                return new TableElementCell("Front", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "simpleMode": {
                    this.script.setSimpleMode((Boolean)cell.getPropertyValue());
                    this.tableDelegate.reloadData();
                    break;
                }
                case "generators": {
                    String value = (String)cell.getPropertyValue();
                    this.script.setStructureNames(Arrays.asList(value.split(",")));
                    ((TableCellString)cell).setValidityState(TableDataSourceStructureBlock.doAllStructuresExist(this.script.getStructureNames()) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
                    break;
                }
                case "listID": {
                    this.script.setStructureListID((String)cell.getPropertyValue());
                    break;
                }
                case "rotation": {
                    this.script.setStructureRotation((Integer)cell.getPropertyValue());
                    break;
                }
                case "mirror": {
                    this.script.setStructureMirror((Boolean)cell.getPropertyValue());
                    break;
                }
                case "front": {
                    this.script.setFront((ForgeDirection)cell.getPropertyValue());
                }
            }
        }
    }
}

