/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.multi;

import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.scripts.world.WorldScript;
import ivorius.reccomplex.scripts.world.WorldScriptRegistry;
import ivorius.reccomplex.utils.IvClasses;
import ivorius.reccomplex.utils.IvTranslations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

public class TableDataSourceWorldScriptList
extends TableDataSourceList<WorldScript, List<WorldScript>> {
    public TableDataSourceWorldScriptList(List<WorldScript> list, TableDelegate tableDelegate, TableNavigator navigator) {
        super(list, tableDelegate, navigator);
        this.setUsesPresetActionForAdding(true);
    }

    @Override
    public String getDisplayString(WorldScript script) {
        return StringUtils.abbreviate((String)script.getDisplayString(), (int)24);
    }

    @Override
    public WorldScript newEntry(String actionID) {
        return (WorldScript)IvClasses.instantiate(WorldScriptRegistry.INSTANCE.objectClass(actionID));
    }

    @Override
    public TableDataSource editEntryDataSource(WorldScript entry) {
        return entry.tableDataSource(this.navigator, this.tableDelegate);
    }

    @Override
    public TableCellButton.Action[] getAddActions() {
        Collection<String> allTypes = WorldScriptRegistry.INSTANCE.allIDs();
        ArrayList<TableCellButton.Action> actions = new ArrayList<TableCellButton.Action>(allTypes.size());
        for (String type : allTypes) {
            String baseKey = "reccomplex.worldscript." + type;
            actions.add(new TableCellButton.Action(type, StatCollector.func_74838_a((String)baseKey), IvTranslations.formatLines(baseKey + ".tooltip", new Object[0])));
        }
        return actions.toArray(new TableCellButton.Action[actions.size()]);
    }
}

