/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator.reachability;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellTitle;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceMazeReachabilityGroup
extends TableDataSourceSegmented
implements TableCellActionListener {
    private List<Set<SavedMazePath>> groups;
    private Set<SavedMazePath> expected;
    private TableDelegate tableDelegate;
    private TableNavigator tableNavigator;

    public TableDataSourceMazeReachabilityGroup(List<Set<SavedMazePath>> groups, Set<SavedMazePath> expected, TableDelegate tableDelegate, TableNavigator tableNavigator) {
        this.groups = groups;
        this.expected = expected;
        this.tableDelegate = tableDelegate;
        this.tableNavigator = tableNavigator;
    }

    public List<Set<SavedMazePath>> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Set<SavedMazePath>> groups) {
        this.groups = groups;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getTableNavigator() {
        return this.tableNavigator;
    }

    public void setTableNavigator(TableNavigator tableNavigator) {
        this.tableNavigator = tableNavigator;
    }

    @Override
    public int numberOfSegments() {
        return 2 + this.groups.size() * 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment % 2 == 0 ? 1 : this.getVirtualGroup(segment / 2 - 1).size();
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        int group = segment / 2 - 1;
        if (segment % 2 == 0) {
            return new TableElementCell(new TableCellTitle("groupTitle" + group, group < 0 ? "Default" : "Group " + (group + 1)));
        }
        SavedMazePath t = this.getVirtualGroup(group).get(index);
        TableCellButton cell = new TableCellButton("entry" + group + "," + index, this.getEntryActions(group, index));
        cell.addListener(this);
        return new TableElementCell(this.getDisplayString(t), cell);
    }

    public TableCellButton.Action[] getEntryActions(int group, int index) {
        boolean first = group < 0;
        boolean second = group == 0;
        boolean last = group == this.groups.size() - 1;
        List<SavedMazePath> groupL = this.getVirtualGroup(group);
        boolean enabled = true;
        return new TableCellButton.Action[]{new TableCellButton.Action(second ? "default" : "earlier", "Previous Group", enabled && !first), new TableCellButton.Action(last ? "new" : "later", last ? "New Group" : "Next Group", enabled && (!last || groupL.size() > 1))};
    }

    private List<SavedMazePath> getVirtualGroup(int group) {
        Set<SavedMazePath> paths = group < 0 ? this.defaultGroup() : this.groups.get(group);
        ArrayList sorted = Lists.newArrayList(paths);
        Collections.sort(sorted);
        return sorted;
    }

    private Set<SavedMazePath> defaultGroup() {
        Sets.SetView view = this.expected;
        for (Set<SavedMazePath> group : this.groups) {
            view = Sets.difference(view, group);
        }
        return view;
    }

    private String getDisplayString(SavedMazePath path) {
        return String.format("%s%s%s %s", EnumChatFormatting.BLUE, path.getForgeDirection(), EnumChatFormatting.RESET, path.getSourceRoom());
    }

    @Override
    public void actionPerformed(TableCell cell, String action) {
        if (cell.getID() != null && cell.getID().startsWith("entry")) {
            String[] split = cell.getID().substring(5).split(",");
            int groupIndex = Integer.valueOf(split[0]);
            int index = Integer.valueOf(split[1]);
            SavedMazePath element = this.getVirtualGroup(groupIndex).get(index);
            if (groupIndex >= 0) {
                this.groups.get(groupIndex).remove(element);
            }
            switch (action) {
                case "earlier": {
                    this.groups.get(groupIndex - 1).add(element);
                    break;
                }
                case "later": {
                    this.groups.get(groupIndex + 1).add(element);
                    break;
                }
                case "new": {
                    this.groups.add(Sets.newHashSet((Object[])new SavedMazePath[]{element}));
                }
            }
            if (groupIndex >= 0 && this.groups.get(groupIndex).isEmpty()) {
                this.groups.remove(groupIndex);
            }
            this.tableDelegate.reloadData();
        }
    }
}

