/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.editstructure.TableDataSourceBiomeGenList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceDimensionGenList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceNaturalGenLimitation;
import ivorius.reccomplex.gui.editstructure.TableDataSourceYSelector;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationInfo;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableCellActionListener;
import ivorius.reccomplex.gui.table.TableCellButton;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import ivorius.reccomplex.worldgen.StructureSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TableDataSourceNaturalGenerationInfo
extends TableDataSourceSegmented
implements TableCellActionListener,
TableCellPropertyListener {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private NaturalGenerationInfo generationInfo;

    public TableDataSourceNaturalGenerationInfo(TableNavigator navigator, TableDelegate tableDelegate, NaturalGenerationInfo generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.generationInfo = generationInfo;
        this.addManagedSection(0, new TableDataSourceGenerationInfo(generationInfo));
        this.addManagedSection(2, new TableDataSourceYSelector(generationInfo.ySelector));
    }

    public static List<TableCellEnum.Option<String>> allGenerationCategories() {
        Set<String> categories = StructureSelector.allCategoryIDs();
        ArrayList<TableCellEnum.Option<String>> generationCategories = new ArrayList<TableCellEnum.Option<String>>();
        for (String category : categories) {
            StructureSelector.Category categoryObj = StructureSelector.categoryForID(category);
            if (!categoryObj.selectableInGUI()) continue;
            generationCategories.add(new TableCellEnum.Option<String>(category, categoryObj.title(), categoryObj.tooltip()));
        }
        return generationCategories;
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                if (index != 0) break;
                TableCellEnum<String> cell = new TableCellEnum<String>("category", this.generationInfo.generationCategory, TableDataSourceNaturalGenerationInfo.allGenerationCategories());
                cell.addPropertyListener(this);
                return new TableElementCell("Category", cell);
            }
            case 3: {
                if (index == 0) {
                    return RCGuiTables.defaultWeightElement(this, this.generationInfo.getGenerationWeight());
                }
                if (index == 1) {
                    TableCellButton cell = new TableCellButton("editBiomes", new TableCellButton.Action("edit", "Edit"));
                    cell.addListener(this);
                    return new TableElementCell("Biomes", cell);
                }
                if (index == 2) {
                    TableCellButton cell = new TableCellButton("editDimensions", new TableCellButton.Action("edit", "Edit"));
                    cell.addListener(this);
                    return new TableElementCell("Dimensions", cell);
                }
                if (index != 3) break;
                TableCellButton cell = new TableCellButton("editLimitations", new TableCellButton.Action("edit", "Edit", this.generationInfo.hasLimitations()), this.generationInfo.hasLimitations() ? new TableCellButton.Action("remove", "Remove") : new TableCellButton.Action("add", "Add"));
                cell.addListener(this);
                return new TableElementCell("Limitations", cell);
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void actionPerformed(TableCell cell, String actionID) {
        if ("editBiomes".equals(cell.getID()) && "edit".equals(actionID)) {
            GuiTable table = new GuiTable(this.tableDelegate, new TableDataSourceBiomeGenList(this.generationInfo.biomeWeights, this.tableDelegate, this.navigator));
            this.navigator.pushTable(table);
        } else if ("editDimensions".equals(cell.getID()) && "edit".equals(actionID)) {
            GuiTable table = new GuiTable(this.tableDelegate, new TableDataSourceDimensionGenList(this.generationInfo.dimensionWeights, this.tableDelegate, this.navigator));
            this.navigator.pushTable(table);
        } else if ("editLimitations".equals(cell.getID())) {
            switch (actionID) {
                case "edit": {
                    GuiTable table = new GuiTable(this.tableDelegate, new TableDataSourceNaturalGenLimitation(this.generationInfo.spawnLimitation, this.tableDelegate));
                    this.navigator.pushTable(table);
                    break;
                }
                case "remove": {
                    this.generationInfo.spawnLimitation = null;
                    this.tableDelegate.reloadData();
                    break;
                }
                case "add": {
                    this.generationInfo.spawnLimitation = new NaturalGenerationInfo.SpawnLimitation();
                    this.tableDelegate.reloadData();
                }
            }
        }
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "category": {
                    this.generationInfo.generationCategory = (String)cell.getPropertyValue();
                    break;
                }
                case "weight": {
                    this.generationInfo.setGenerationWeight(TableElements.toDouble((Float)cell.getPropertyValue()));
                }
            }
        }
    }
}

