/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.structures.generic.gentypes.NaturalGenerationInfo;
import java.util.Arrays;

public class TableDataSourceNaturalGenLimitation
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private NaturalGenerationInfo.SpawnLimitation limitation;
    private TableDelegate tableDelegate;

    public TableDataSourceNaturalGenLimitation(NaturalGenerationInfo.SpawnLimitation limitation, TableDelegate tableDelegate) {
        this.limitation = limitation;
        this.tableDelegate = tableDelegate;
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            switch (index) {
                case 0: {
                    TableCellEnum<NaturalGenerationInfo.SpawnLimitation.Context> cell = new TableCellEnum<NaturalGenerationInfo.SpawnLimitation.Context>("context", this.limitation.context, TableCellEnum.options(Arrays.asList(NaturalGenerationInfo.SpawnLimitation.Context.values()), "reccomplex.generationInfo.natural.limitation.context.", false));
                    cell.addPropertyListener(this);
                    return new TableElementCell("Context", cell);
                }
                case 1: {
                    TableCellInteger cell = new TableCellInteger("max", this.limitation.maxCount, 1, 50);
                    cell.addPropertyListener(this);
                    return new TableElementCell("Max Occurrences", cell);
                }
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("context".equals(cell.getID())) {
            this.limitation.context = (NaturalGenerationInfo.SpawnLimitation.Context)((Object)cell.getPropertyValue());
            this.tableDelegate.reloadData();
        } else if ("max".equals(cell.getID())) {
            this.limitation.maxCount = (Integer)cell.getPropertyValue();
        }
    }
}

