/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editinventorygen;

import ivorius.reccomplex.gui.InventoryWatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;

public class InventoryGenericInvGen
implements IInventory {
    public List<WeightedRandomChestContent> chestContents;
    private List<ItemStack> cachedItemStacks = new ArrayList<ItemStack>();
    private List<InventoryWatcher> watchers = new ArrayList<InventoryWatcher>();

    public InventoryGenericInvGen(List<WeightedRandomChestContent> chestContents) {
        this.chestContents = chestContents;
        this.buildCachedStacks();
    }

    public void addWatcher(InventoryWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void removeWatcher(InventoryWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public List<InventoryWatcher> watchers() {
        return Collections.unmodifiableList(this.watchers);
    }

    public int func_70302_i_() {
        return this.cachedItemStacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return var1 < this.cachedItemStacks.size() ? this.cachedItemStacks.get(var1) : null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        int stackIndex = var1 / 2;
        if (stackIndex < this.chestContents.size()) {
            WeightedRandomChestContent chestContent = this.chestContents.get(stackIndex);
            if (var1 % 2 == 0) {
                chestContent.field_76295_d -= var2;
            } else {
                chestContent.field_76296_e -= var2;
            }
            InventoryGenericInvGen.validateMinMax(chestContent);
            ItemStack returnStack = this.cachedItemStacks.get(var1).func_77979_a(var2);
            this.markDirtyFromInventoryGenerator();
            return returnStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        int stackIndex = var1 / 2;
        if (stackIndex < this.chestContents.size()) {
            if (var2 != null) {
                WeightedRandomChestContent chestContent = this.chestContents.get(stackIndex);
                chestContent.field_76297_b = var2;
                if (var1 % 2 == 0) {
                    chestContent.field_76295_d = var2.field_77994_a;
                } else {
                    chestContent.field_76296_e = var2.field_77994_a;
                }
                InventoryGenericInvGen.validateMinMax(chestContent);
            } else {
                this.chestContents.remove(stackIndex);
            }
        } else if (var2 != null) {
            int min = var1 % 2 == 0 ? var2.field_77994_a : 1;
            int max = var1 % 2 == 1 ? var2.field_77994_a : var2.func_77976_d();
            WeightedRandomChestContent weightedRandomChestContent = new WeightedRandomChestContent(var2, min, max, 100);
            this.chestContents.add(weightedRandomChestContent);
        }
        this.markDirtyFromInventoryGenerator();
    }

    private static void validateMinMax(WeightedRandomChestContent chestContent) {
        if (chestContent.field_76296_e < chestContent.field_76295_d) {
            int tmp = chestContent.field_76296_e;
            chestContent.field_76296_e = chestContent.field_76295_d;
            chestContent.field_76295_d = tmp;
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.calculateMinMax();
        this.buildCachedStacks();
        for (InventoryWatcher watcher : this.watchers) {
            watcher.inventoryChanged(this);
        }
    }

    public void markDirtyFromInventoryGenerator() {
        this.buildCachedStacks();
        for (InventoryWatcher watcher : this.watchers) {
            watcher.inventoryChanged(this);
        }
    }

    private void calculateMinMax() {
        for (int i = 0; i < this.cachedItemStacks.size(); ++i) {
            ItemStack stack = this.cachedItemStacks.get(i);
            int stackIndex = i / 2;
            if (stackIndex >= this.chestContents.size()) continue;
            WeightedRandomChestContent chestContent = this.chestContents.get(stackIndex);
            if (i % 2 == 0) {
                chestContent.field_76295_d = stack.field_77994_a;
                continue;
            }
            chestContent.field_76296_e = stack.field_77994_a;
        }
        this.chestContents.forEach(InventoryGenericInvGen::validateMinMax);
    }

    private void buildCachedStacks() {
        this.cachedItemStacks.clear();
        for (WeightedRandomChestContent chestContent : this.chestContents) {
            ItemStack stackLow = chestContent.field_76297_b.func_77946_l();
            stackLow.field_77994_a = chestContent.field_76295_d;
            ItemStack stackHigh = chestContent.field_76297_b.func_77946_l();
            stackHigh.field_77994_a = chestContent.field_76296_e;
            this.cachedItemStacks.add(stackLow);
            this.cachedItemStacks.add(stackHigh);
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }
}

