/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import java.util.function.Consumer;

public class TableDataSourceBlockCoord
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private BlockCoord coord;
    private Consumer<BlockCoord> consumer;
    private IntegerRange rangeX;
    private IntegerRange rangeY;
    private IntegerRange rangeZ;
    private String titleX;
    private String titleY;
    private String titleZ;

    public TableDataSourceBlockCoord(BlockCoord coord, Consumer<BlockCoord> consumer, IntegerRange rangeX, IntegerRange rangeY, IntegerRange rangeZ, String titleX, String titleY, String titleZ) {
        this.coord = coord;
        this.consumer = consumer;
        this.rangeX = rangeX;
        this.rangeY = rangeY;
        this.rangeZ = rangeZ;
        this.titleX = titleX;
        this.titleY = titleY;
        this.titleZ = titleZ;
    }

    public TableDataSourceBlockCoord(BlockCoord coord, Consumer<BlockCoord> consumer, IntegerRange range, String titleFormat) {
        this.coord = coord;
        this.consumer = consumer;
        this.rangeX = range;
        this.rangeY = range;
        this.rangeZ = range;
        this.titleX = String.format(titleFormat, "X");
        this.titleY = String.format(titleFormat, "Y");
        this.titleZ = String.format(titleFormat, "Z");
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return 3;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (index) {
            case 0: {
                TableCellInteger cell = new TableCellInteger("x", this.coord.x, this.rangeX.min, this.rangeX.max);
                cell.addPropertyListener(this);
                return new TableElementCell(this.titleX, cell);
            }
            case 1: {
                TableCellInteger cell = new TableCellInteger("y", this.coord.y, this.rangeY.min, this.rangeY.max);
                cell.addPropertyListener(this);
                return new TableElementCell(this.titleY, cell);
            }
            case 2: {
                TableCellInteger cell = new TableCellInteger("z", this.coord.z, this.rangeZ.min, this.rangeZ.max);
                cell.addPropertyListener(this);
                return new TableElementCell(this.titleZ, cell);
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "x": {
                    this.coord = new BlockCoord(((Integer)cell.getPropertyValue()).intValue(), this.coord.y, this.coord.z);
                    this.consumer.accept(this.coord);
                    break;
                }
                case "y": {
                    this.coord = new BlockCoord(this.coord.x, ((Integer)cell.getPropertyValue()).intValue(), this.coord.z);
                    this.consumer.accept(this.coord);
                    break;
                }
                case "z": {
                    this.coord = new BlockCoord(this.coord.x, this.coord.y, ((Integer)cell.getPropertyValue()).intValue());
                    this.consumer.accept(this.coord);
                }
            }
        }
    }
}

