/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.structures.generic.Metadata;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.commons.lang3.StringUtils;

public class CommandSearchStructure
extends CommandBase {
    public static final int MAX_RESULTS = 20;

    public static ChatComponentText createStructureChatComponent(String strucID) {
        ChatComponentText comp = new ChatComponentText(strucID);
        comp.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s %s", RCCommands.lookup.func_71517_b(), strucID)));
        comp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ServerTranslations.format("commands.rcsearch.lookup", new Object[0])));
        comp.func_150256_b().func_150238_a(EnumChatFormatting.BLUE);
        return comp;
    }

    public static float searchRank(List<String> query, String id, StructureInfo structure) {
        return structure instanceof GenericStructureInfo ? CommandSearchStructure.searchRank(query, id, ((GenericStructureInfo)structure).metadata) : 0.0f;
    }

    public static float searchRank(List<String> query, String id, Metadata metadata) {
        ArrayList keywords = Lists.newArrayList((Object[])new String[]{id});
        keywords.add(metadata.authors);
        keywords.add(metadata.comment);
        keywords.add(metadata.weblink);
        return keywords.stream().anyMatch(arg_0 -> ((Predicate)Predicates.contains((Pattern)Pattern.compile(Strings.join((List)Lists.transform(query, Pattern::quote), (String)"|")))).apply(arg_0)) ? 1.0f : 0.0f;
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "search";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender var1) {
        return ServerTranslations.usage("commands.rcsearch.usage");
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        ChatComponentText[] components;
        if (args.length >= 1) {
            List<String> query = Arrays.asList(args);
            PriorityQueue strucs = new PriorityQueue(10, (o1, o2) -> {
                float r1 = CommandSearchStructure.searchRank(query, o1, StructureRegistry.INSTANCE.getStructure((String)o1));
                float r2 = CommandSearchStructure.searchRank(query, o2, StructureRegistry.INSTANCE.getStructure((String)o2));
                return Floats.compare((float)r1, (float)r2);
            });
            strucs.addAll(StructureRegistry.INSTANCE.allStructureIDs().stream().filter(s -> CommandSearchStructure.searchRank(query, s, StructureRegistry.INSTANCE.getStructure((String)s)) > 0.0f).collect(Collectors.toList()));
            boolean cut = strucs.size() > 20;
            components = new ChatComponentText[cut ? 20 : strucs.size()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = cut && i == components.length - 1 ? new ChatComponentText("... (" + strucs.size() + ")") : CommandSearchStructure.createStructureChatComponent((String)strucs.remove());
            }
        } else {
            throw ServerTranslations.commandException("commands.rclookup.usage", new Object[0]);
        }
        commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation(StringUtils.repeat((String)"%s", (String)", ", (int)components.length), (Object[])components));
    }
}

