/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.aobdorechunks.config;

import com.rcx.aobdorechunks.AOBDOC;
import com.rcx.aobdorechunks.OreChunkAddon;
import com.rcx.aobdorechunks.config.OreChunksConfigs;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.aobd.ore.Ore;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration configFile;
    public Set<String> usedCategories = new HashSet<String>();

    public void preInit(File file) {
        this.configFile = new Configuration(file, true);
    }

    public void init() {
        this.usedCategories.clear();
        this.usedCategories.add("AOBDOC");
        AOBDOC.processingUnit = this.configFile.get("The oredict prefix of the ore chunks", "general", "ore").setRequiresMcRestart(true).setRequiresWorldRestart(true).getString();
        for (Map.Entry<Ore, OreChunksConfigs> entry : OreChunkAddon.chunkMap.entrySet()) {
            this.init(entry.getKey().name(), entry.getValue());
        }
    }

    public OreChunksConfigs init(Ore ore) {
        OreChunksConfigs config = new OreChunksConfigs(ore.name().toLowerCase());
        this.init(ore.name(), config);
        return config;
    }

    public void init(String name, OreChunksConfigs config) {
        config.setEnabled(this.getBoolean(name, "Enabled", true, true));
        config.setDropCount(this.getInt(name, "Amount of chunks to drop", config.getDropCount()));
        config.setMinXPDrop(this.getInt(name, "Minimum XP drop", config.getMinXPDrop()));
        config.setMaxXPDrop(this.getInt(name, "Maximum XP drop", config.getMaxXPDrop()));
        config.setStoneType(this.getString(name, "Stone type", config.getStoneType()));
        this.usedCategories.add(name);
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("aobd".equals(eventArgs.modID)) {
            this.configFile.load();
            this.init();
        }
    }

    private boolean getBoolean(String category, String name, boolean requiresRestart, boolean def) {
        return this.configFile.get(category, name, def).setRequiresMcRestart(requiresRestart).getBoolean(def);
    }

    private int getInt(String category, String name, int def) {
        return this.configFile.get(category, name, def).getInt(def);
    }

    private String getString(String category, String name, String def) {
        return this.configFile.get(category, name, def).getString();
    }
}

