/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.aobdorechunks;

import com.rcx.aobdorechunks.OreChunkAddon;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class OreSwapper {
    @SubscribeEvent
    public void SwapOres(BlockEvent.HarvestDropsEvent event) {
        if (event.isSilkTouching) {
            return;
        }
        if (event.drops.isEmpty()) {
            return;
        }
        OreChunkAddon.OreInfos oreInfos = null;
        String orename = null;
        boolean alreadyDropped = false;
        ArrayList<ItemStack> oldDrops = new ArrayList<ItemStack>();
        ArrayList<ItemStack> modifiedDrops = new ArrayList<ItemStack>();
        for (ItemStack drop : event.drops) {
            int[] oreids = OreDictionary.getOreIDs((ItemStack)drop);
            for (int i = 0; i < oreids.length; ++i) {
                orename = OreDictionary.getOreName((int)oreids[i]);
                int count = drop.field_77994_a;
                if (!orename.startsWith("ore") && !orename.startsWith("dust")) continue;
                if (orename.startsWith("dust")) {
                    orename = orename.replace("dust", "ore");
                    count = 1;
                    if (alreadyDropped) continue;
                }
                if (!OreChunkAddon.dropMap.containsKey(orename)) continue;
                oreInfos = OreChunkAddon.dropMap.get(orename);
                count = this.randomCount(count * oreInfos.count, event.fortuneLevel, event.world);
                ItemStack chunkStack = new ItemStack(oreInfos.chunkItem);
                for (int c = 0; c < count; ++c) {
                    modifiedDrops.add(chunkStack);
                    alreadyDropped = true;
                }
                break;
            }
            if (oreInfos == null) continue;
            oldDrops.add(drop);
        }
        if (oreInfos == null) {
            return;
        }
        event.drops.removeAll(oldDrops);
        event.dropChance = 1.0f;
        event.drops.addAll(modifiedDrops);
        if (oreInfos.maxXP <= 0) {
            return;
        }
        int countOrbs = event.world.field_73012_v.nextInt(oreInfos.maxXP - oreInfos.minXP);
        countOrbs += oreInfos.minXP;
        for (int i = 0; i < countOrbs; ++i) {
            event.world.func_72838_d((Entity)new EntityXPOrb(event.world, (double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, 1));
        }
    }

    private int randomCount(int baseCount, int fortuneLevel, World world) {
        if (fortuneLevel > 0) {
            int j = world.field_73012_v.nextInt(fortuneLevel + 3) - 3;
            if (j < 0) {
                j = 0;
            }
            return baseCount + j;
        }
        return baseCount;
    }
}

