/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.wind;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;

public class WindManager {
    public WeatherManagerBase manager;
    public float windAngleGlobal = 0.0f;
    public float windSpeedGlobal = 0.0f;
    public float windSpeedGlobalChangeRate = 0.05f;
    public int windSpeedGlobalRandChangeTimer = 0;
    public int windSpeedGlobalRandChangeDelay = 10;
    public float windSpeedMin = 0.01f;
    public float windSpeedMax = 1.0f;
    public float windAngleEvent = 0.0f;
    public float windSpeedEvent = 0.0f;
    public int windTimeEvent = 0;
    public float windAngleGust = 0.0f;
    public float windSpeedGust = 0.0f;
    public int windTimeGust = 0;
    public int windGustEventTimeRand = 60;
    public float chanceOfWindGustEvent = 0.5f;
    public int lowWindTimer = 0;
    public int lowWindTimerEnableAmountBase = 2400;
    public int lowWindTimerEnableAmountRnd = 12000;
    public int lowWindOddsTo1 = 4000;

    public WindManager(WeatherManagerBase parManager) {
        this.manager = parManager;
        Random rand = new Random();
        this.windAngleGlobal = rand.nextInt(360);
    }

    public float getWindSpeedForPriority() {
        if (this.windTimeEvent > 0) {
            return this.getWindSpeedForEvents();
        }
        if (this.windTimeGust > 0) {
            return this.getWindSpeedForGusts();
        }
        return this.getWindSpeedForClouds();
    }

    public float getWindSpeedForEvents() {
        if (this.windTimeEvent > 0) {
            return this.windSpeedEvent;
        }
        return 0.0f;
    }

    public float getWindSpeedForGusts() {
        return this.windSpeedGust;
    }

    public float getWindSpeedForClouds() {
        return this.windSpeedGlobal;
    }

    public float getWindAngleForPriority() {
        if (this.windTimeEvent > 0) {
            return this.getWindAngleForEvents();
        }
        if (this.windTimeGust > 0) {
            return this.getWindAngleForGusts();
        }
        return this.getWindAngleForClouds();
    }

    public float getWindAngleForEvents() {
        return this.windAngleEvent;
    }

    public float getWindAngleForGusts() {
        return this.windAngleGust;
    }

    public float getWindAngleForClouds() {
        return this.windAngleGlobal;
    }

    public void setWindTimeGust(int parVal) {
        this.windTimeGust = parVal;
        this.syncData();
    }

    public void setWindTimeEvent(int parVal) {
        this.windTimeEvent = parVal;
    }

    public void tick() {
        Random rand = new Random();
        if (!ConfigMisc.Misc_windOn) {
            this.windSpeedGlobal = 0.0f;
            this.windSpeedGust = 0.0f;
            this.windTimeGust = 0;
        } else if (!this.manager.getWorld().field_72995_K) {
            if (!ConfigMisc.Wind_NoWindEvents) {
                this.lowWindTimer = 0;
            }
            if (this.lowWindTimer <= 0) {
                if (this.windSpeedGlobalRandChangeTimer-- <= 0) {
                    this.windSpeedGlobal = (float)((double)this.windSpeedGlobal + (rand.nextDouble() * (double)this.windSpeedGlobalChangeRate - (double)(this.windSpeedGlobalChangeRate / 2.0f)));
                    this.windSpeedGlobalRandChangeTimer = this.windSpeedGlobalRandChangeDelay;
                }
                if (ConfigMisc.Wind_NoWindEvents && rand.nextInt(this.lowWindOddsTo1) == 0) {
                    this.lowWindTimer = this.lowWindTimerEnableAmountBase + rand.nextInt(this.lowWindTimerEnableAmountRnd);
                    Weather.dbg("no wind event, for ticks: " + this.lowWindTimer);
                }
            } else {
                --this.lowWindTimer;
                this.windSpeedGlobal -= 0.01f;
            }
            if (this.windSpeedGlobal < this.windSpeedMin) {
                this.windSpeedGlobal = this.windSpeedMin;
            }
            if (this.windSpeedGlobal > this.windSpeedMax) {
                this.windSpeedGlobal = this.windSpeedMax;
            }
            if (this.windTimeGust > 0) {
                --this.windTimeGust;
                if (this.windTimeGust == 0) {
                    this.syncData();
                }
            }
            float randGustWindFactor = 1.0f;
            if (this.windTimeGust == 0 && this.lowWindTimer <= 0 && this.chanceOfWindGustEvent > 0.0f && rand.nextInt((int)((100.0f - this.chanceOfWindGustEvent) * randGustWindFactor)) == 0) {
                this.windSpeedGust = this.windSpeedGlobal + rand.nextFloat() * 0.6f;
                this.windAngleGust = rand.nextInt(360) - 180;
                this.setWindTimeGust(rand.nextInt(this.windGustEventTimeRand));
            }
            this.windAngleGlobal += (float)(new Random().nextInt(5) - 2) * 0.5f;
            if (this.windAngleGlobal < -180.0f) {
                this.windAngleGlobal += 360.0f;
            }
            if (this.windAngleGlobal > 180.0f) {
                this.windAngleGlobal -= 360.0f;
            }
        } else {
            this.tickClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        StormObject so;
        EntityClientPlayerMP entP = FMLClientHandler.instance().getClient().field_71439_g;
        if (this.windTimeEvent > 0) {
            --this.windTimeEvent;
        }
        if (entP != null && this.manager.getWorld().func_82737_E() % 10L == 0L && (so = this.manager.getClosestStorm(Vec3.func_72443_a((double)entP.field_70165_t, (double)StormObject.layers.get(0).intValue(), (double)entP.field_70161_v), 256.0, StormObject.STATE_HIGHWIND)) != null) {
            float yaw;
            this.setWindTimeEvent(80);
            double stormDist = entP.func_70011_f(so.posGround.field_72450_a, so.posGround.field_72448_b, so.posGround.field_72449_c);
            double var11 = so.posGround.field_72450_a - entP.field_70165_t;
            double var15 = so.posGround.field_72449_c - entP.field_70161_v;
            this.windAngleEvent = yaw = -((float)Math.atan2(var11, var15)) * 180.0f / (float)Math.PI;
            this.windSpeedEvent = 2.0f;
        }
    }

    public NBTTagCompound nbtSyncForClient() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74776_a("windSpeedGlobal", this.windSpeedGlobal);
        data.func_74776_a("windAngleGlobal", this.windAngleGlobal);
        data.func_74776_a("windSpeedGust", this.windSpeedGust);
        data.func_74776_a("windAngleGust", this.windAngleGust);
        data.func_74768_a("windTimeGust", this.windTimeGust);
        return data;
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        this.windSpeedGlobal = parNBT.func_74760_g("windSpeedGlobal");
        this.windAngleGlobal = parNBT.func_74760_g("windAngleGlobal");
        this.windSpeedGust = parNBT.func_74760_g("windSpeedGust");
        this.windAngleGust = parNBT.func_74760_g("windAngleGust");
        this.windTimeGust = parNBT.func_74762_e("windTimeGust");
    }

    public void syncData() {
        if (this.manager instanceof WeatherManagerServer) {
            ((WeatherManagerServer)this.manager).syncWindUpdate(this);
        }
    }

    public void reset() {
        this.manager = null;
    }
}

