/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import CoroUtil.util.CoroUtilBlock;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.entity.EntityMovingBlock;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilEntity;
import weather2.util.WeatherUtilSound;
import weather2.weathersystem.storm.StormObject;

public class TornadoHelper {
    public StormObject storm;
    public int blockCount = 0;
    public int ripCount = 0;
    public long lastGrabTime = 0L;
    public int tickGrabCount = 0;
    public int removeCount = 0;
    public int tryRipCount = 0;
    public int tornadoBaseSize = 5;
    public int grabDist = 100;
    public boolean lastTickPlayerClose;

    public TornadoHelper(StormObject parStorm) {
        this.storm = parStorm;
    }

    public int getTornadoBaseSize() {
        int sizeChange = 10;
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE5) {
            return sizeChange * 9;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE4) {
            return sizeChange * 7;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE3) {
            return sizeChange * 5;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE2) {
            return sizeChange * 4;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE1) {
            return sizeChange * 3;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
            return sizeChange * 1;
        }
        return 5;
    }

    public void tick(World parWorld) {
        if (this.storm == null) {
            return;
        }
        boolean seesLight = false;
        this.tickGrabCount = 0;
        this.removeCount = 0;
        this.tryRipCount = 0;
        int tryRipMax = 300;
        this.tornadoBaseSize = this.getTornadoBaseSize();
        if (this.storm.stormType == StormObject.TYPE_WATER) {
            this.tornadoBaseSize *= 3;
        }
        this.forceRotate(parWorld);
        Random rand = new Random();
        int spawnYOffset = (int)this.storm.posBaseFormationPos.field_72448_b;
        if (!parWorld.field_72995_K && ConfigMisc.Storm_Tornado_grabBlocks) {
            int yStart = 0;
            int yEnd = (int)this.storm.pos.field_72448_b;
            int yInc = 1;
            BiomeGenBase bgb = parWorld.func_72807_a(MathHelper.func_76128_c((double)this.storm.pos.field_72450_a), MathHelper.func_76128_c((double)this.storm.pos.field_72449_c));
            if (bgb != null && (double)(bgb.field_76748_D + bgb.field_76749_E) <= 0.7) {
                for (int i = yStart; i < yEnd; i += yInc) {
                    int YRand = i;
                    int ii = YRand / 4;
                    if (i > 20 && rand.nextInt(2) != 0) continue;
                    if (this.tryRipCount > tryRipMax) break;
                    int extraTry = (int)(((float)(this.storm.levelCurIntensityStage + 1) - StormObject.levelStormIntensityFormingStartVal) * 5.0f);
                    int loopAmount = 5 + ii + extraTry;
                    if (this.storm.stormType == StormObject.TYPE_WATER) {
                        loopAmount = 1 + ii / 2;
                    }
                    for (int k = 0; k < loopAmount && this.tryRipCount <= tryRipMax; ++k) {
                        int tryZ;
                        double d2;
                        int tryX;
                        double d0;
                        double dist;
                        int tryY = (int)((double)(spawnYOffset + YRand) - 1.5);
                        if (tryY > 255) {
                            tryY = 255;
                        }
                        if (!((dist = (double)MathHelper.func_76133_a((double)((d0 = this.storm.pos.field_72450_a - (double)(tryX = (int)this.storm.pos.field_72450_a + rand.nextInt(this.tornadoBaseSize + ii) - (this.tornadoBaseSize / 2 + ii / 2))) * d0 + (d2 = this.storm.pos.field_72449_c - (double)(tryZ = (int)this.storm.pos.field_72449_c + rand.nextInt(this.tornadoBaseSize + ii) - (this.tornadoBaseSize / 2 + ii / 2))) * d2))) < (double)(this.tornadoBaseSize / 2 + ii / 2)) || this.tryRipCount >= tryRipMax) continue;
                        Block blockID = parWorld.func_147439_a(tryX, tryY, tryZ);
                        boolean performed = false;
                        if (!CoroUtilBlock.isAir((Block)blockID) && this.canGrab(parWorld, blockID)) {
                            ++this.tryRipCount;
                            performed = seesLight = this.tryRip(parWorld, tryX, tryY, tryZ, true);
                        }
                        if (performed || !ConfigMisc.Storm_Tornado_RefinedGrabRules || blockID != Blocks.field_150349_c) continue;
                        parWorld.func_147449_b(tryX, tryY, tryZ, Blocks.field_150346_d);
                    }
                }
                for (int k = 0; k < 10; ++k) {
                    Block blockID;
                    int randSize = 40;
                    int tryX = (int)this.storm.pos.field_72450_a + rand.nextInt(randSize) - 20;
                    int tryY = spawnYOffset - 2 + rand.nextInt(8);
                    double d0 = this.storm.pos.field_72450_a - (double)tryX;
                    int tryZ = (int)this.storm.pos.field_72449_c + rand.nextInt(randSize) - 20;
                    double d2 = this.storm.pos.field_72449_c - (double)tryZ;
                    double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    if (!(dist < (double)(this.tornadoBaseSize / 2 + randSize / 2)) || this.tryRipCount >= tryRipMax || CoroUtilBlock.isAir((Block)(blockID = parWorld.func_147439_a(tryX, tryY, tryZ))) || !this.canGrab(parWorld, blockID)) continue;
                    ++this.tryRipCount;
                    this.tryRip(parWorld, tryX, tryY, tryZ, true);
                }
            }
        } else {
            seesLight = true;
        }
        if (Math.abs((double)spawnYOffset - this.storm.pos.field_72448_b) > 5.0) {
            seesLight = true;
        }
    }

    public boolean isNoDigCoord(int x, int y, int z) {
        return false;
    }

    public boolean tryRip(World parWorld, int tryX, int tryY, int tryZ, boolean notify) {
        if (!ConfigMisc.Storm_Tornado_grabBlocks) {
            return true;
        }
        if (this.isNoDigCoord(tryX, tryY, tryZ)) {
            return true;
        }
        if (parWorld.field_72995_K) {
            boolean bl = false;
        }
        boolean seesLight = false;
        Block blockID = parWorld.func_147439_a(tryX, tryY, tryZ);
        if (parWorld.func_72976_f(tryX, tryZ) - 1 == tryY || parWorld.func_72976_f(tryX + 1, tryZ) - 1 < tryY || parWorld.func_72976_f(tryX, tryZ + 1) - 1 < tryY || parWorld.func_72976_f(tryX - 1, tryZ) - 1 < tryY || parWorld.func_72976_f(tryX, tryZ - 1) - 1 < tryY) {
            if (parWorld.func_72863_F().func_73149_a((int)this.storm.pos.field_72450_a / 16, (int)this.storm.pos.field_72449_c / 16) && this.blockCount <= ConfigMisc.Storm_Tornado_maxBlocksPerStorm && this.lastGrabTime < System.currentTimeMillis() && this.tickGrabCount < ConfigMisc.Storm_Tornado_maxBlocksGrabbedPerTick) {
                this.lastGrabTime = System.currentTimeMillis() - 5L;
                if (blockID != Blocks.field_150433_aE && blockID != Blocks.field_150359_w) {
                    if (parWorld.func_72977_a(this.storm.posBaseFormationPos.field_72450_a, this.storm.posBaseFormationPos.field_72448_b, this.storm.posBaseFormationPos.field_72449_c, 140.0) != null) {
                        EntityMovingBlock mBlock = blockID == Blocks.field_150349_c ? new EntityMovingBlock(parWorld, tryX, tryY, tryZ, Blocks.field_150346_d, this.storm) : new EntityMovingBlock(parWorld, tryX, tryY, tryZ, blockID, this.storm);
                        ++this.blockCount;
                        mBlock.func_70107_b(tryX, tryY, tryZ);
                        if (!parWorld.field_72995_K) {
                            parWorld.func_72838_d((Entity)mBlock);
                        }
                        ++this.tickGrabCount;
                        ++this.ripCount;
                        if (this.ripCount % 10 == 0) {
                            // empty if block
                        }
                        mBlock.type = 0;
                        seesLight = true;
                    }
                } else if (blockID == Blocks.field_150359_w) {
                    parWorld.func_72908_a((double)tryX, (double)tryY, (double)tryZ, "random.glass", 5.0f, 1.0f);
                }
            }
            if (WeatherUtil.shouldRemoveBlock(blockID)) {
                ++this.removeCount;
                if (notify) {
                    parWorld.func_147465_d(tryX, tryY, tryZ, Blocks.field_150350_a, 0, 3);
                } else {
                    parWorld.func_147465_d(tryX, tryY, tryZ, Blocks.field_150350_a, 0, 0);
                }
            }
        }
        return seesLight;
    }

    public boolean canGrab(World parWorld, Block blockID) {
        return !CoroUtilBlock.isAir((Block)blockID) && WeatherUtil.shouldGrabBlock(parWorld, blockID);
    }

    public boolean forceRotate(World parWorld) {
        double dist = this.grabDist;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.storm.pos.field_72450_a, (double)this.storm.currentTopYBlock, (double)this.storm.pos.field_72449_c, (double)this.storm.pos.field_72450_a, (double)this.storm.currentTopYBlock, (double)this.storm.pos.field_72449_c);
        List list = parWorld.func_72872_a(Entity.class, aabb.func_72314_b(dist, (double)(this.storm.maxHeight * 3), dist));
        boolean foundEnt = false;
        boolean killCount = false;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (!(entity1 instanceof EntityPlayer) || ConfigMisc.Storm_Tornado_grabPlayer) {
                    if (!(entity1 instanceof EntityPlayer) && ConfigMisc.Storm_Tornado_grabPlayersOnly) continue;
                    if (this.getDistanceXZ(this.storm.posBaseFormationPos, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v) < dist) {
                        if (entity1 instanceof EntityMovingBlock && !((EntityMovingBlock)entity1).collideFalling) {
                            this.storm.spinEntity(entity1);
                            foundEnt = true;
                        } else if (entity1 instanceof EntityPlayer) {
                            if (WeatherUtilEntity.isEntityOutside(entity1)) {
                                this.storm.spinEntity(entity1);
                                foundEnt = true;
                            }
                        } else if (entity1 instanceof EntityLivingBase && WeatherUtilEntity.isEntityOutside(entity1, true)) {
                            this.storm.spinEntity(entity1);
                            foundEnt = true;
                        }
                    }
                }
                if (entity1 instanceof EntityMovingBlock && !entity1.field_70128_L) {
                    int var3 = MathHelper.func_76128_c((double)entity1.field_70165_t);
                    int var4 = MathHelper.func_76128_c((double)entity1.field_70161_v);
                    int n = 32;
                }
                if (!(entity1 instanceof EntityMovingBlock) || this.blockCount + 5 <= ConfigMisc.Storm_Tornado_maxBlocksPerStorm || !(entity1.field_70163_u > 255.0)) continue;
                entity1.func_70106_y();
            }
        }
        return foundEnt;
    }

    public double getDistanceXZ(Vec3 parVec, double var1, double var3, double var5) {
        double var7 = parVec.field_72450_a - var1;
        double var11 = parVec.field_72449_c - var5;
        return MathHelper.func_76133_a((double)(var7 * var7 + var11 * var11));
    }

    public double getDistanceXZ(Entity ent, double var1, double var3, double var5) {
        double var7 = ent.field_70165_t - var1;
        double var11 = ent.field_70161_v - var5;
        return MathHelper.func_76133_a((double)(var7 * var7 + var11 * var11));
    }

    @SideOnly(value=Side.CLIENT)
    public void soundUpdates(boolean playFarSound, boolean playNearSound) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g == null) {
            return;
        }
        int far = 200;
        int close = 120;
        if (this.storm.stormType == StormObject.TYPE_WATER) {
            close = 200;
        }
        Vec3 plPos = Vec3.func_72443_a((double)mc.field_71439_g.field_70165_t, (double)mc.field_71439_g.field_70163_u, (double)mc.field_71439_g.field_70161_v);
        double distToPlayer = this.storm.posGround.func_72438_d(plPos);
        float volScaleFar = (float)(((double)far - distToPlayer) / (double)far);
        float volScaleClose = (float)(((double)close - distToPlayer) / (double)close);
        if (volScaleFar < 0.0f) {
            volScaleFar = 0.0f;
        }
        if (volScaleClose < 0.0f) {
            volScaleClose = 0.0f;
        }
        if (distToPlayer < (double)close) {
            if (!this.lastTickPlayerClose) {
                // empty if block
            }
            this.lastTickPlayerClose = true;
        } else {
            this.lastTickPlayerClose = false;
        }
        if (distToPlayer < (double)far) {
            if (playFarSound) {
                this.tryPlaySound(WeatherUtilSound.snd_wind_far, 2, (Entity)mc.field_71439_g, volScaleFar, far);
            }
            if (playNearSound) {
                this.tryPlaySound(WeatherUtilSound.snd_wind_close, 1, (Entity)mc.field_71439_g, volScaleClose, close);
            }
            if (this.storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
                if (this.storm.stormType == StormObject.TYPE_LAND) {
                    this.tryPlaySound(WeatherUtilSound.snd_dmg_close, 0, (Entity)mc.field_71439_g, volScaleClose, close);
                }
            }
        }
    }

    public boolean tryPlaySound(String[] sound, int arrIndex, Entity source, float vol, float parCutOffRange) {
        Entity soundTarget = source;
        Random rand = new Random();
        if (WeatherUtilSound.soundTimer[arrIndex] <= System.currentTimeMillis()) {
            WeatherUtilSound.playMovingSound(this.storm, Weather.modID + ":streaming." + sound[WeatherUtilSound.snd_rand[arrIndex]], vol, 1.0f, parCutOffRange);
            int length = (Integer)WeatherUtilSound.soundToLength.get(sound[WeatherUtilSound.snd_rand[arrIndex]]);
            WeatherUtilSound.soundTimer[arrIndex] = System.currentTimeMillis() + (long)length - 500L;
            WeatherUtilSound.snd_rand[arrIndex] = rand.nextInt(3);
        }
        return false;
    }
}

