/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import CoroUtil.packet.PacketHelper;
import CoroUtil.util.CoroUtilEntity;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import weather2.ClientTickHandler;
import weather2.Weather;
import weather2.util.WeatherUtilConfig;

public class EventHandlerPacket {
    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound((ByteBuf)event.packet.payload());
            String packetCommand = nbt.func_74779_i("packetCommand");
            if (packetCommand.equals("WeatherData")) {
                ClientTickHandler.checkClientWeather();
                ClientTickHandler.weatherManager.nbtSyncFromServer(nbt);
            } else if (packetCommand.equals("EZGuiData")) {
                String command = nbt.func_74779_i("command");
                Weather.dbg("receiving GUI data for client, command: " + command);
                if (command.equals("syncUpdate")) {
                    WeatherUtilConfig.nbtReceiveServerDataForCache(nbt);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP entP = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound((ByteBuf)event.packet.payload());
            String packetCommand = nbt.func_74779_i("packetCommand");
            Weather.dbg("Weather2 packet command from client: " + packetCommand);
            if (packetCommand.equals("EZGuiData")) {
                String command = nbt.func_74779_i("command");
                Weather.dbg("packet handling command: " + command);
                if (command.equals("syncRequest")) {
                    Weather.dbg("EZGUI syncRequest");
                    NBTTagCompound sendNBT = new NBTTagCompound();
                    sendNBT.func_74778_a("packetCommand", "EZGuiData");
                    sendNBT.func_74778_a("command", "syncUpdate");
                    sendNBT.func_74757_a("markUpdated", true);
                    sendNBT.func_74757_a("isPlayerOP", MinecraftServer.func_71276_C().func_71264_H() || MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(entP.func_146103_bH()));
                    sendNBT.func_74782_a("data", (NBTBase)WeatherUtilConfig.nbtServerData);
                    sendNBT.func_74782_a("dimListing", (NBTBase)WeatherUtilConfig.createNBTDimensionListing());
                    Weather.eventChannel.sendTo(PacketHelper.getNBTPacket((NBTTagCompound)sendNBT, (String)Weather.eventChannelName), entP);
                } else if (command.equals("applySettings") && (MinecraftServer.func_71276_C().func_71264_H() || MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(entP.func_146103_bH()))) {
                    WeatherUtilConfig.nbtReceiveClientData(nbt.func_74775_l("guiData"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getSelfUsername() {
        return CoroUtilEntity.getName((Entity)Minecraft.func_71410_x().field_71439_g);
    }
}

