/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultkeys.localconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.defaultkeys.localconfig.LocalConfigEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeConfigHandler {
    private static final Logger logger = LogManager.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void backup(PrintWriter writer, List<LocalConfigEntry> entries, File configFile) {
        boolean[] foundProperty = new boolean[entries.size()];
        ArrayList<LocalConfigEntry> notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        ArrayList<String> categoryPath = new ArrayList<String>();
        boolean isInQuotes = false;
        boolean isInList = false;
        boolean consumeList = false;
        boolean listFlag = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            block20: while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    int i = 0;
                    while (i < foundProperty.length) {
                        if (!foundProperty[i] && !entries.get((int)i).not) {
                            logger.warn("Failed to backup local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
                        }
                        ++i;
                    }
                    return;
                }
                StringBuilder buffer = new StringBuilder();
                int i = 0;
                while (true) {
                    block43: {
                        char c;
                        block44: {
                            block42: {
                                if (i >= line.length()) continue block20;
                                c = line.charAt(i);
                                if (!isInQuotes) break block42;
                                if (c == '\"') {
                                    isInQuotes = false;
                                }
                                buffer.append(c);
                                break block43;
                            }
                            if (!isInList) break block44;
                            if (c == '>') {
                                isInList = false;
                                listFlag = false;
                                if (consumeList) {
                                    writer.println(">");
                                }
                                break block43;
                            } else if (consumeList) {
                                if (listFlag) {
                                    writer.print(", ");
                                }
                                writer.print(line);
                                listFlag = true;
                            }
                            break block43;
                        }
                        switch (c) {
                            case '#': {
                                continue block20;
                            }
                            case '\"': {
                                isInQuotes = true;
                                buffer.append(c);
                                break;
                            }
                            case '{': {
                                categoryPath.add(buffer.toString().trim());
                                buffer = new StringBuilder();
                                break;
                            }
                            case '}': {
                                categoryPath.remove(categoryPath.size() - 1);
                                break;
                            }
                            case '<': {
                                isInList = true;
                                consumeList = false;
                                String category = StringUtils.join(categoryPath, (String)".");
                                String name = buffer.toString().trim();
                                String type = name.substring(0, 1);
                                name = name.substring(2);
                                int j = 0;
                                while (true) {
                                    if (j >= entries.size()) continue block20;
                                    LocalConfigEntry entry = entries.get(j);
                                    if (entry.passesProperty(category, name, type)) {
                                        foundProperty[j] = true;
                                        if (entry.containsWildcard()) {
                                            for (LocalConfigEntry notEntry : notEntries) {
                                                if (!notEntry.passesProperty(category, name, type)) continue;
                                                continue block20;
                                            }
                                        }
                                        consumeList = true;
                                        writer.print(entry.getIdentifier(entry.file, category, type, name));
                                        writer.print("=<");
                                        continue block20;
                                    }
                                    ++j;
                                }
                            }
                            case '=': {
                                String category = StringUtils.join(categoryPath, (String)".");
                                String name = buffer.toString().trim();
                                String type = name.substring(0, 1);
                                name = name.substring(2);
                                String value = line.substring(i + 1);
                                int j = 0;
                                while (true) {
                                    if (j >= entries.size()) continue block20;
                                    LocalConfigEntry entry = entries.get(j);
                                    if (entry.passesProperty(category, name, type)) {
                                        foundProperty[j] = true;
                                        if (entry.containsWildcard()) {
                                            for (LocalConfigEntry notEntry : notEntries) {
                                                if (!notEntry.passesProperty(category, name, type)) continue;
                                                continue block20;
                                            }
                                        }
                                        writer.println(entry.getIdentifier(entry.file, category, type, name) + "=" + value);
                                        continue block20;
                                    }
                                    ++j;
                                }
                            }
                            default: {
                                buffer.append(c);
                            }
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void restore(List<LocalConfigEntry> entries, File configFile) {
        boolean[] foundProperty = new boolean[entries.size()];
        ArrayList<LocalConfigEntry> notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        File backupFile = new File(configFile.getParentFile(), configFile.getName() + ".bak");
        try {
            FileUtils.copyFile((File)configFile, (File)backupFile);
        }
        catch (IOException e) {
            logger.error("Could not create backup file {}: {}", new Object[]{backupFile, e});
        }
        try {
            List lines = FileUtils.readLines((File)configFile);
            try (PrintWriter writer = new PrintWriter(configFile);){
                ArrayList<String> categoryPath = new ArrayList<String>();
                boolean isInQuotes = false;
                boolean isInList = false;
                boolean discardList = false;
                block24: for (String line : lines) {
                    StringBuilder buffer = new StringBuilder();
                    block25: for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (isInQuotes) {
                            if (c == '\"') {
                                isInQuotes = false;
                            }
                            buffer.append(c);
                            continue;
                        }
                        if (isInList) {
                            if (c == '>') {
                                isInList = false;
                            }
                            if (!discardList) continue;
                            continue block24;
                        }
                        switch (c) {
                            case '#': {
                                break block25;
                            }
                            case '\"': {
                                isInQuotes = true;
                                buffer.append(c);
                                continue block25;
                            }
                            case '{': {
                                categoryPath.add(buffer.toString().trim());
                                buffer = new StringBuilder();
                                continue block25;
                            }
                            case '}': {
                                categoryPath.remove(categoryPath.size() - 1);
                                continue block25;
                            }
                            case '<': {
                                LocalConfigEntry entry;
                                int j;
                                isInList = true;
                                discardList = false;
                                String category = StringUtils.join(categoryPath, (String)".");
                                String name = buffer.toString().trim();
                                String type = name.substring(0, 1);
                                name = name.substring(2);
                                for (j = 0; j < entries.size(); ++j) {
                                    String[] values;
                                    entry = entries.get(j);
                                    if (!entry.passesProperty(category, name, type)) continue;
                                    foundProperty[j] = true;
                                    if (entry.containsWildcard()) {
                                        for (LocalConfigEntry notEntry : notEntries) {
                                            if (!notEntry.passesProperty(category, name, type)) continue;
                                            break block25;
                                        }
                                    }
                                    discardList = true;
                                    String indent = StringUtils.repeat((char)' ', (int)ForgeConfigHandler.getIndent(line));
                                    writer.print(indent);
                                    writer.println('<');
                                    for (String value : values = entry.value.split(",")) {
                                        writer.print(indent);
                                        writer.print("    ");
                                        writer.println(value.trim());
                                    }
                                    writer.print(indent);
                                    writer.println('>');
                                    continue block24;
                                }
                                break block25;
                            }
                            case '=': {
                                LocalConfigEntry entry;
                                int j;
                                String category = StringUtils.join(categoryPath, (String)".");
                                String name = buffer.toString().trim();
                                String type = name.substring(0, 1);
                                name = name.substring(2);
                                for (j = 0; j < entries.size(); ++j) {
                                    entry = entries.get(j);
                                    if (!entry.passesProperty(category, name, type)) continue;
                                    foundProperty[j] = true;
                                    if (entry.containsWildcard()) {
                                        for (LocalConfigEntry notEntry : notEntries) {
                                            if (!notEntry.passesProperty(category, name, type)) continue;
                                            break block25;
                                        }
                                    }
                                    line = line.substring(0, i) + "=" + entry.value;
                                    break block25;
                                }
                                break block25;
                            }
                            default: {
                                buffer.append(c);
                            }
                        }
                    }
                    writer.println(line);
                }
            }
            for (int i = 0; i < foundProperty.length; ++i) {
                if (foundProperty[i] || entries.get((int)i).not) continue;
                logger.warn("Failed to restore local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
            }
        }
        catch (IOException e) {
            logger.error("Failed to restore local values in {}: {}", new Object[]{configFile, e});
            try {
                FileUtils.copyFile((File)backupFile, (File)configFile);
            }
            catch (IOException e2) {
                logger.error("Could not restore config file {} from backup: {}", new Object[]{configFile, e2});
            }
        }
    }

    private static int getIndent(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) && c == '\t') continue;
            return i;
        }
        return line.length();
    }
}

