/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.common;

import cpw.mods.fml.common.FMLLog;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class DLTransformer
implements IClassTransformer {
    private String classNameWorld = "ahb";
    private String blockAccessJava = "ahl";
    private String blockJava = "aji";
    private String computeLightValueMethodName = "a";
    private String targetMethodDesc = "(IIILahn;)I";

    private static void log(String message) {
        FMLLog.log((String)"DynamicLights", (Level)Level.INFO, (String)"%s", (Object[])new Object[]{message});
    }

    private static void error(String message) {
        FMLLog.log((String)"DynamicLights", (Level)Level.ERROR, (String)"%s", (Object[])new Object[]{message});
    }

    public byte[] transform(String name, String newName, byte[] bytes) {
        if (name.equals(this.classNameWorld)) {
            return this.handleWorldTransform(bytes, true);
        }
        if (name.equals("net.minecraft.world.World")) {
            this.blockJava = "net/minecraft/block/Block";
            this.blockAccessJava = "net/minecraft/world/IBlockAccess";
            this.computeLightValueMethodName = "computeLightValue";
            this.targetMethodDesc = "(IIILnet/minecraft/world/EnumSkyBlock;)I";
            return this.handleWorldTransform(bytes, false);
        }
        return bytes;
    }

    private byte[] handleWorldTransform(byte[] bytes, boolean obf) {
        DLTransformer.log("Patching World, obf: " + obf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(this.computeLightValueMethodName) || !m.desc.equals(this.targetMethodDesc)) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            boolean deleting = false;
            boolean replacing = false;
            while (iter.hasNext()) {
                targetNode = (AbstractInsnNode)iter.next();
                if (targetNode instanceof VarInsnNode) {
                    VarInsnNode vNode = (VarInsnNode)targetNode;
                    if (vNode.var == 6) {
                        if (vNode.getOpcode() == 58) {
                            deleting = true;
                            continue;
                        }
                        if (vNode.getOpcode() == 54) {
                            replacing = true;
                            targetNode = (AbstractInsnNode)iter.next();
                            break;
                        }
                    }
                    if (vNode.var == 7 && deleting) break;
                }
                if (!deleting) continue;
                System.out.println("Removing " + targetNode);
                iter.remove();
            }
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 5));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
            try {
                try {
                    AbstractInsnNode node = (AbstractInsnNode)MethodInsnNode.class.getConstructor(Integer.TYPE, String.class, String.class, String.class).newInstance(184, "atomicstryker/dynamiclights/client/DynamicLights", "getLightValue", "(L" + this.blockAccessJava + ";L" + this.blockJava + ";III)I");
                    toInject.add(node);
                }
                catch (NoSuchMethodException e) {
                    AbstractInsnNode node = (AbstractInsnNode)MethodInsnNode.class.getConstructor(Integer.TYPE, String.class, String.class, String.class, Boolean.TYPE).newInstance(184, "atomicstryker/dynamiclights/client/DynamicLights", "getLightValue", "(L" + this.blockAccessJava + ";L" + this.blockJava + ";III)I", false);
                    toInject.add(node);
                }
            }
            catch (Exception e) {
                DLTransformer.error("Dynamic Lights ASM transform failed T_T");
                e.printStackTrace();
                return bytes;
            }
            if (replacing) {
                toInject.add((AbstractInsnNode)new VarInsnNode(54, 6));
            }
            m.instructions.insertBefore(targetNode, toInject);
            DLTransformer.log("Patching Complete!");
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

