/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client;

import coloredlightscore.src.api.CLBlock;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ItemConfigHelper {
    private final String SWILDCARD = "*";
    private final int WILDCARD = -1;
    private Map<ItemData, Integer> dataMap = new HashMap<ItemData, Integer>();

    public ItemConfigHelper(String configLine, int defaultValue) {
        for (String s : configLine.split(",")) {
            try {
                String[] duo = s.split("=");
                this.dataMap.put(this.fromString(duo[0]), duo.length > 1 ? Integer.parseInt(duo[1]) : defaultValue);
            }
            catch (Exception e) {
                System.err.println("Error, String [" + s + "] is not a valid Entry, skipping.");
                e.printStackTrace();
            }
        }
    }

    public int getLightFromItemStack(ItemStack stack) {
        if (stack != null) {
            int r = this.retrieveValue(GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b()), stack.func_77960_j());
            return r < 0 ? 0 : r;
        }
        return 0;
    }

    public int retrieveValue(String name, int meta) {
        if (name != null) {
            for (ItemData item : this.dataMap.keySet()) {
                if (!item.matches(name, meta)) continue;
                int val = this.dataMap.get(item);
                if (val == -1) {
                    Block b = (Block)GameData.getBlockRegistry().func_82594_a(name);
                    if (b instanceof CLBlock) {
                        return ((CLBlock)b).getColorLightValue(meta);
                    }
                    return b != null ? b.func_149750_m() : 0;
                }
                return val;
            }
        }
        return -1;
    }

    private ItemData fromString(String s) {
        int em;
        int sm;
        String[] strings = s.split("-");
        int len = strings.length;
        int n = len > 1 ? this.catchWildcard(strings[len > 3 ? 2 : 1]) : (sm = -1);
        int n2 = len > 2 ? this.catchWildcard(strings[len > 3 ? 3 : 2]) : (em = sm);
        if (!strings[0].contains(":")) {
            strings[0] = "minecraft:" + strings[0];
        }
        return new ItemData(strings[0], sm, em);
    }

    private int catchWildcard(String s) {
        if (s.equals("*")) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private class ItemData {
        private String nameOf;
        final int startMeta;
        final int endMeta;

        public ItemData(String name, int startmetarange, int endmetarange) {
            this.nameOf = name;
            this.startMeta = startmetarange;
            this.endMeta = endmetarange;
        }

        public String toString() {
            return this.nameOf + " " + this.startMeta + " " + this.endMeta;
        }

        public boolean matches(String name, int meta) {
            return name.equals(this.nameOf) && this.isContained(this.startMeta, this.endMeta, meta);
        }

        private boolean isContained(int s, int e, int i) {
            return !(s != -1 && i < s || e != -1 && i > e);
        }

        public boolean equals(Object o) {
            if (o instanceof ItemData) {
                ItemData i = (ItemData)o;
                return i.nameOf.equals(this.nameOf) && i.startMeta == this.startMeta && i.endMeta == this.endMeta;
            }
            return false;
        }

        public int hashCode() {
            return this.nameOf.hashCode() + this.startMeta + this.endMeta;
        }
    }
}

